/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.Collection;

import com.sodiumarc.patchwork.util.Collection.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class MultiHashMap<K, V>
extends LinkedHashMap<K, List<V>>
implements MultiMap<K, V> {
    private static final long serialVersionUID = 97105648442519981L;

    @Override
    public boolean putLast(K key, V value) {
        ArrayList<V> values = (ArrayList<V>)this.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            this.put(key, values);
        }
        values.add(value);
        return values.size() == 1;
    }

    @Override
    public V getFirst(K key) {
        List values = (List)this.get(key);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return null;
        }
        return (V)values.get(0);
    }

    @Override
    public V getLast(K key) {
        List values = (List)this.get(key);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return null;
        }
        return (V)values.get(values.size() - 1);
    }

    @Override
    public List<V> getAll(K key) {
        List values = (List)this.get(key);
        return values == null ? Collections.emptyList() : values;
    }

    @Override
    public boolean remove(K key, V value) {
        List values = (List)this.get(key);
        if (values == null) {
            return false;
        }
        boolean result = values.remove(value);
        if (values.size() == 0) {
            this.remove(key);
        }
        return result;
    }

    @Override
    public boolean clearValues(K key) {
        List values = (List)this.get(key);
        if (values == null || values.isEmpty()) {
            return false;
        }
        values.clear();
        return true;
    }

    @Override
    public V removeFirst(K key) {
        List values = (List)this.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object result = values.remove(0);
        if (values.isEmpty()) {
            this.remove(key);
        }
        return (V)result;
    }
}

