/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util.Collection;

import com.sodiumarc.patchwork.util.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <T> Collection<T> filter(Collection<T> source, Filter<T> filter, Collection<T> result) {
        for (T t : source) {
            if (!filter.accept(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> filterList(Collection<T> source, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : source) {
            if (!filter.accept(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> void addAll(Collection<T> dest, Iterable<T> source) {
        assert (dest != null) : "Destination collection is null";
        if (source == null) {
            return;
        }
        for (T t : source) {
            dest.add(t);
        }
    }

    public static <T> void addAll(Collection<T> dest, T ... elements) {
        assert (dest != null) : "Destination collection is null";
        if (elements == null) {
            return;
        }
        for (T t : elements) {
            dest.add(t);
        }
    }

    public static <T> void ensureSize(Collection<T> c, int size, T fillValue) {
        assert (c != null) : "collection is null";
        while (c.size() < size) {
            c.add(fillValue);
        }
    }

    public static <T> List<T> subList(List<T> source, int startIndex, int endIndex) {
        if (startIndex >= source.size()) {
            throw new IndexOutOfBoundsException(startIndex + ">=" + source.size());
        }
        if (endIndex >= source.size()) {
            throw new IndexOutOfBoundsException(endIndex + ">=" + source.size());
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = startIndex; i <= endIndex; ++i) {
            result.add(source.get(i));
        }
        return result;
    }

    public static <T> List<T> copyList(List<T> source) {
        if (source == null) {
            return null;
        }
        return new ArrayList<T>(source);
    }

    public static <T> T first(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iter = iterable.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static <T> T last(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            return list.isEmpty() ? null : (T)list.get(list.size() - 1);
        }
        Iterator<T> iter = iterable.iterator();
        T result = null;
        while (iter.hasNext()) {
            result = iter.next();
        }
        return result;
    }

    public static <T> T firstValue(Map<?, T> map) {
        if (map == null) {
            return null;
        }
        return CollectionUtils.first(map.values());
    }

    public static <T> void addIfNotNull(Collection<T> collection, T element) {
        if (element != null) {
            collection.add(element);
        }
    }

    public static <T> List<T> asListIgnoreNulls(T ... values) {
        ArrayList<T> result = new ArrayList<T>(values.length);
        for (T t : values) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> Set<T> asHashSetIgnoreNulls(T ... values) {
        HashSet<T> result = new HashSet<T>(values.length);
        for (T t : values) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> concatenate(Collection<T> iterable0, Collection<T> iterable1) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(iterable0);
        result.addAll(iterable1);
        return result;
    }

    public static List<Float> asList(float ... array) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (int i = 0; i < array.length; ++i) {
            result.add(Float.valueOf(array[i]));
        }
        return result;
    }
}

