/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.util;

import com.sodiumarc.patchwork.util.ClickOrDragEvent;
import com.sodiumarc.patchwork.util.ClickOrDragListener;
import com.sodiumarc.patchwork.util.Filter;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public abstract class ClickOrDragSensor {
    private final double clickMaxDistance;
    private final long clickMaxDuration;
    private final Filter<MouseEvent> eventFilter;
    private boolean clickEnabled;
    private boolean dragEnabled;
    private boolean gestureInProgress;
    private long mouseDownTime = 0L;
    private final Point mouseDownLocation;
    private final Point lastDragLocation;
    private boolean dragInProgress;
    private final List<ClickOrDragListener> listeners;

    public ClickOrDragSensor(Component target, double clickMaxDistance, long clickMaxDuration, Filter<MouseEvent> eventFilter) {
        this.eventFilter = eventFilter;
        this.clickMaxDistance = clickMaxDistance;
        this.clickMaxDuration = clickMaxDuration;
        this.mouseDownLocation = new Point();
        this.lastDragLocation = new Point();
        target.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ClickOrDragSensor.this.isRelevant(e)) {
                    ClickOrDragSensor.this.onPressed(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ClickOrDragSensor.this.onReleased();
            }
        });
        target.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ClickOrDragSensor.this.onDragged(e.getPoint());
            }
        });
        this.listeners = new ArrayList<ClickOrDragListener>();
        this.clickEnabled = true;
        this.dragEnabled = true;
    }

    public boolean isClickEnabled() {
        return this.clickEnabled;
    }

    public void setClickEnabled(boolean clickEnabled) {
        this.clickEnabled = clickEnabled;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public void addListener(ClickOrDragListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClickOrDragListener listener) {
        this.listeners.remove(listener);
    }

    protected void eventOccurred(ClickOrDragEvent event) {
    }

    private boolean isRelevant(MouseEvent event) {
        return this.eventFilter == null || this.eventFilter.accept(event);
    }

    private void fireEvent(ClickOrDragEvent.Type type, Point location, Point delta) {
        ClickOrDragEvent event = new ClickOrDragEvent(type, location, delta);
        this.eventOccurred(event);
        for (ClickOrDragListener listener : this.listeners) {
            listener.eventOccurred(this, event);
        }
    }

    private void onPressed(Point loc) {
        this.mouseDownTime = System.currentTimeMillis();
        this.mouseDownLocation.setLocation(loc);
        this.gestureInProgress = true;
    }

    private void onReleased() {
        if (!this.gestureInProgress) {
            return;
        }
        if (this.dragInProgress) {
            this.fireEvent(ClickOrDragEvent.Type.DRAG_ENDED, this.lastDragLocation, null);
            this.dragInProgress = false;
        } else if (this.clickEnabled) {
            this.fireEvent(ClickOrDragEvent.Type.CLICKED, this.mouseDownLocation, null);
        }
        this.gestureInProgress = false;
    }

    private void onDragged(Point loc) {
        if (!this.gestureInProgress || !this.dragEnabled) {
            return;
        }
        double dragDistance = loc.distance(this.mouseDownLocation);
        long dragDuration = System.currentTimeMillis() - this.mouseDownTime;
        if (!this.dragInProgress && (dragDistance > this.clickMaxDistance || dragDuration > this.clickMaxDuration)) {
            this.fireEvent(ClickOrDragEvent.Type.DRAG_STARTED, loc, null);
            this.dragInProgress = true;
        }
        if (this.dragInProgress) {
            this.lastDragLocation.setLocation(loc);
            this.fireEvent(ClickOrDragEvent.Type.DRAGGED, loc, new Point(loc.x - this.mouseDownLocation.x, loc.y - this.mouseDownLocation.y));
        }
    }
}

