/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.sketch.SketchFiller;
import com.sodiumarc.patchwork.sketch.Splotcher;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SplotcherApp {
    public static void main(String[] args) throws IOException {
        File inputPath = new File(args[0]);
        File outputPath = new File(args[1]);
        File[] inputFiles = null;
        inputFiles = inputPath.isDirectory() ? inputPath.listFiles(FileUtils.JPG_FILTER) : new File[]{inputPath};
        Splotcher splotcher = Splotcher.getDefaultInstance();
        SketchFiller sketchFiller = SketchFiller.getDefaultInstance();
        for (File file : inputFiles) {
            long startTime = System.currentTimeMillis();
            System.out.print("Processing file \"" + file.getName() + "\"...");
            BufferedImage image = ImageIO.read(file);
            image = ImageUtils.trimColor(image, Color.BLACK, 25);
            image = ImageUtils.fillExterior(image, Color.BLACK, 25, 0);
            image = sketchFiller.createFillImage(image);
            System.out.println("done (" + (System.currentTimeMillis() - startTime) + ")");
            String outputFilename = FileUtils.appendBeforeExtension(file.getName(), "_S");
            ImageUtils.saveRGBImage(image, new File(outputPath, outputFilename).getPath());
        }
    }
}

