/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.sketch.SketchAsset;
import com.sodiumarc.patchwork.util.Collection.Pair;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.image.ImageFilter;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SketchFiller
implements ImageFilter {
    private static SketchFiller DEFAULT_INSTANCE;
    private static final int SAMPLE_SIZE = 10;
    private final List<Pair<Range<Integer>, Fill>> _fillLayers = new ArrayList<Pair<Range<Integer>, Fill>>();

    public static SketchFiller getTestInstance() {
        int width = 600;
        int height = 600;
        SketchFiller instance = new SketchFiller();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        ImageUtils.paintCheckerboard(g, new Rectangle(0, 0, width, height), 16, 16, Color.WHITE, Color.DARK_GRAY);
        g.dispose();
        instance.addFill(new SketchAsset("0", image, 1.0f, 1.0f), 80, 255, 0.0f);
        image = new BufferedImage(width, height, 2);
        g = image.createGraphics();
        ImageUtils.paintCheckerboard(g, new Rectangle(0, 0, width, height), 8, 8, Color.WHITE, Color.DARK_GRAY);
        g.dispose();
        instance.addFill(new SketchAsset("1", image, 1.0f, 1.0f), 0, 200, 0.0f);
        return instance;
    }

    public static SketchFiller getDefaultInstance() throws IOException {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new SketchFiller();
            SketchAsset softM = new SketchAsset("fills/fill_soft_s.jpg", 1.0f, 0.8f);
            SketchAsset med1500 = new SketchAsset("fills/fill_med1_500.jpg", 1.0f, 1.0f, true, false);
            SketchAsset med2500 = new SketchAsset("fills/fill_med2_500.jpg", 1.0f, 0.9f, true, false);
            SketchAsset dark500 = new SketchAsset("fills/fill_dark_500.jpg", 1.0f, 1.0f, true, false);
            DEFAULT_INSTANCE.addFill(softM, 0, 255, -0.1f);
            DEFAULT_INSTANCE.addFill(med1500, 0, 200, 0.0f);
            DEFAULT_INSTANCE.addFill(med2500, 0, 200, 0.0f);
            DEFAULT_INSTANCE.addFill(dark500, 0, 200, 0.0f);
        }
        return DEFAULT_INSTANCE;
    }

    public void addFill(SketchAsset asset, int minIntensity, int maxIntensity, float alphaAdjust) {
        this._fillLayers.add(new Pair<Range<Integer>, Fill>(new Range<Integer>(minIntensity, maxIntensity), new Fill(asset, 10, alphaAdjust, new Point(150, 150))));
    }

    public BufferedImage createFillImage(BufferedImage source) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        float alphaAdjust = 0.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int sourceColor = source.getRGB(x, y);
                int resultColor = -16777216;
                for (ColorComponent component : ColorComponent.values()) {
                    int sourceValue = ColorUtils.getComponent(sourceColor, component);
                    int resultActualValue = 255;
                    int resultAverageValue = 255;
                    Iterator<Pair<Range<Integer>, Fill>> iter = this._fillLayers.iterator();
                    while (iter.hasNext()) {
                        Fill fill = iter.next().getSecond();
                        float fillAlphaActual = fill.getAlphaActual(x, y) + alphaAdjust;
                        float fillAlphaAverage = fill.getAlphaAveraged(x, y) + alphaAdjust;
                        float layerScale = (float)(resultAverageValue - sourceValue) / (fillAlphaAverage * (float)resultAverageValue);
                        if ((layerScale = MathUtils.clamp(layerScale, 0.0f, 1.0f)) == 0.0f) break;
                        resultActualValue = (int)((float)resultActualValue * (1.0f - layerScale * fillAlphaActual));
                        resultAverageValue = (int)((float)resultAverageValue * (1.0f - layerScale * fillAlphaAverage));
                    }
                    resultColor = ColorUtils.setComponent(resultColor, component, resultActualValue);
                }
                result.setRGB(x, y, resultColor);
            }
        }
        return result;
    }

    @Override
    public BufferedImage apply(BufferedImage input, Properties properties) {
        return this.createFillImage(input);
    }

    private static class Fill {
        private final SketchAsset _asset;
        private final BufferedImage _fillImage;
        private final BufferedImage _fillImageAveraged;
        private final boolean _flipTile = false;
        private final int _blendMargin = 20;
        private final float _alphaAdjust;
        private final Point _offset;

        Fill(SketchAsset asset, int sampleSize, float alphaAdjust, Point offset) {
            this._asset = asset;
            this._fillImage = this._asset.makeSplotchImage(Color.WHITE, false);
            this._fillImageAveraged = this.generateAveragedImage(this._fillImage, sampleSize);
            this._alphaAdjust = alphaAdjust;
            this._offset = offset == null ? new Point(0, 0) : offset;
        }

        float getAlphaActual(int x, int y) {
            float alpha = (float)ColorUtils.getComponent(ImageUtils.getRGBTiled(this._fillImage, x += this._offset.x, y += this._offset.y, false, 20), ColorComponent.ALPHA) / 255.0f;
            return MathUtils.clamp(alpha + this._alphaAdjust, 0.0f, 1.0f);
        }

        float getAlphaAveraged(int x, int y) {
            float alpha = (float)ColorUtils.getComponent(ImageUtils.getRGBTiled(this._fillImageAveraged, x += this._offset.x, y += this._offset.y, false, 20), ColorComponent.ALPHA) / 255.0f;
            return MathUtils.clamp(alpha + this._alphaAdjust, 0.0f, 1.0f);
        }

        private BufferedImage generateAveragedImage(BufferedImage source, int sampleSize) {
            Image downScaled = source.getScaledInstance(sampleSize, sampleSize, 16);
            BufferedImage averagedImage = new BufferedImage(source.getWidth(), source.getHeight(), 2);
            Graphics2D g = averagedImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(downScaled, 0, 0, source.getWidth(), source.getHeight(), 0, 0, sampleSize, sampleSize, null);
            g.dispose();
            return averagedImage;
        }
    }
}

