/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.sketch;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.common.FooterButtonPanel;
import com.sodiumarc.patchwork.app.scanimport.ImagePanel;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SketchConvertPanel
extends FooterButtonPanel {
    private JFileChooser fileChooser;
    private ImagePanel imagePanel;

    @Override
    protected Component createMainPanel() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(RenderResourceIO.getInstance().getImageInputDir());
        this.imagePanel = new ImagePanel();
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        JScrollPane scrollPane = new JScrollPane(this.imagePanel);
        scrollPane.setVerticalScrollBarPolicy(22);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    @Override
    protected Iterable<?> getButtons() {
        return EnumSet.of(MyButton.Convert);
    }

    @Override
    protected void onButtonPress(Object key) {
        switch ((MyButton)((Object)key)) {
            case Convert: {
                this.doConvert();
            }
        }
    }

    @Override
    protected void updateControlEnabling() {
    }

    private void doConvert() {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            try {
                File inputFile = this.fileChooser.getSelectedFile();
                BufferedImage inputImage = ImageIO.read(inputFile);
                SketchAsset asset = new SketchAsset("dummy", inputImage, 1.0f, 1.0f);
                BufferedImage processedImage = asset.makeSplotchImage(Color.BLACK, true);
                RenderResourceIO resourceIO = RenderResourceIO.getInstance();
                resourceIO.writeOutputImage(processedImage, resourceIO.getProcessedScanDir(), FileUtils.getFilenameWithoutExtension(inputFile.getName()));
                this.imagePanel.setImage(processedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.updateControlEnabling();
        }
    }

    private static enum MyButton {
        Convert;

    }
}

