/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.GMatrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;

public class Transform3D {
    double[] mat = new double[16];
    double[] rot = null;
    double[] scales = null;
    private int type = 0;
    private static final int AFFINE_BIT = 1;
    private static final int ORTHO_BIT = 2;
    private static final int CONGRUENT_BIT = 4;
    private static final int RIGID_BIT = 8;
    private static final int CLASSIFY_BIT = 16;
    private static final int SCALE_BIT = 32;
    private static final int ROTATION_BIT = 64;
    private static final int SVD_BIT = 128;
    private static final int CLASSIFY_ALL_DIRTY = 31;
    private static final int ROTSCALESVD_DIRTY = 224;
    private static final int ALL_DIRTY = 255;
    private int dirtyBits;
    boolean autoNormalize = false;
    private static final double EPS = 1.110223024E-16;
    static final double EPSILON = 1.0E-10;
    static final double EPSILON_ABSOLUTE = 1.0E-5;
    static final double EPSILON_RELATIVE = 1.0E-4;
    public static final int ZERO = 1;
    public static final int IDENTITY = 2;
    public static final int SCALE = 4;
    public static final int TRANSLATION = 8;
    public static final int ORTHOGONAL = 16;
    public static final int RIGID = 32;
    public static final int CONGRUENT = 64;
    public static final int AFFINE = 128;
    public static final int NEGATIVE_DETERMINANT = 256;
    private static final int ORTHO = 0x40000000;

    public Transform3D(Matrix4f m1) {
        this.set(m1);
    }

    public Transform3D(Matrix4d m1) {
        this.set(m1);
    }

    public Transform3D(Transform3D t1) {
        this.set(t1);
    }

    public Transform3D() {
        this.setIdentity();
    }

    public Transform3D(float[] matrix) {
        this.set(matrix);
    }

    public Transform3D(double[] matrix) {
        this.set(matrix);
    }

    public Transform3D(Quat4d q1, Vector3d t1, double s) {
        this.set(q1, t1, s);
    }

    public Transform3D(Quat4f q1, Vector3d t1, double s) {
        this.set(q1, t1, s);
    }

    public Transform3D(Quat4f q1, Vector3f t1, float s) {
        this.set(q1, t1, s);
    }

    public Transform3D(GMatrix m1) {
        this.set(m1);
    }

    public Transform3D(Matrix3f m1, Vector3d t1, double s) {
        this.set(m1, t1, s);
    }

    public Transform3D(Matrix3d m1, Vector3d t1, double s) {
        this.set(m1, t1, s);
    }

    public Transform3D(Matrix3f m1, Vector3f t1, float s) {
        this.set(m1, t1, s);
    }

    public final int getType() {
        if ((this.dirtyBits & 0x10) != 0) {
            this.classify();
        }
        return this.type & 0xBFFFFFFF;
    }

    final boolean isOrtho() {
        if ((this.dirtyBits & 2) != 0) {
            if (Transform3D.almostZero(this.mat[0] * this.mat[2] + this.mat[4] * this.mat[6] + this.mat[8] * this.mat[10]) && Transform3D.almostZero(this.mat[0] * this.mat[1] + this.mat[4] * this.mat[5] + this.mat[8] * this.mat[9]) && Transform3D.almostZero(this.mat[1] * this.mat[2] + this.mat[5] * this.mat[6] + this.mat[9] * this.mat[10])) {
                this.type |= 0x40000000;
                this.dirtyBits &= 0xFFFFFFFD;
                return true;
            }
            this.type &= 0xBFFFFFFF;
            this.dirtyBits &= 0xFFFFFFFD;
            return false;
        }
        return (this.type & 0x40000000) != 0;
    }

    final boolean isCongruent() {
        if ((this.dirtyBits & 4) != 0) {
            this.classifyRigid();
        }
        return (this.type & 0x40) != 0;
    }

    final boolean isAffine() {
        if ((this.dirtyBits & 1) != 0) {
            this.classifyAffine();
        }
        return (this.type & 0x80) != 0;
    }

    final boolean isRigid() {
        if ((this.dirtyBits & 8) != 0) {
            if ((this.dirtyBits & 4) != 0) {
                this.classifyRigid();
            } else {
                if ((this.type & 0x40) != 0) {
                    double s;
                    if ((this.dirtyBits & 0x20) != 0) {
                        s = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                    } else {
                        if (this.scales == null) {
                            this.scales = new double[3];
                        }
                        s = this.scales[0];
                    }
                    this.type = Transform3D.almostOne(s) ? (this.type |= 0x20) : (this.type &= 0xFFFFFFDF);
                } else {
                    this.type &= 0xFFFFFFDF;
                }
                this.dirtyBits &= 0xFFFFFFF7;
            }
        }
        return (this.type & 0x20) != 0;
    }

    public final int getBestType() {
        this.getType();
        if ((this.type & 1) != 0) {
            return 1;
        }
        if ((this.type & 2) != 0) {
            return 2;
        }
        if ((this.type & 4) != 0) {
            return 4;
        }
        if ((this.type & 8) != 0) {
            return 8;
        }
        if ((this.type & 0x10) != 0) {
            return 16;
        }
        if ((this.type & 0x20) != 0) {
            return 32;
        }
        if ((this.type & 0x40) != 0) {
            return 64;
        }
        if ((this.type & 0x80) != 0) {
            return 128;
        }
        if ((this.type & 0x100) != 0) {
            return 256;
        }
        return 0;
    }

    public final boolean getDeterminantSign() {
        double det = this.determinant();
        if (Double.isNaN(det)) {
            return true;
        }
        return det >= 0.0;
    }

    public final void setAutoNormalize(boolean autoNormalize) {
        this.autoNormalize = autoNormalize;
        if (autoNormalize) {
            this.normalize();
        }
    }

    public final boolean getAutoNormalize() {
        return this.autoNormalize;
    }

    void transform(Point3d point, Point4d pointOut) {
        pointOut.x = this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3];
        pointOut.y = this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7];
        pointOut.z = this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11];
        pointOut.w = this.mat[12] * point.x + this.mat[13] * point.y + this.mat[14] * point.z + this.mat[15];
    }

    private static final boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    private static final boolean almostOne(double a) {
        return a < 1.00001 && a > 0.99999;
    }

    private static final boolean almostEqual(double a, double b) {
        double diff = a - b;
        if (diff >= 0.0) {
            if (diff < 1.0E-10) {
                return true;
            }
            if (b > 0.0 || a > -b) {
                return diff < 1.0E-4 * a;
            }
            return diff < -1.0E-4 * b;
        }
        if (diff > -1.0E-10) {
            return true;
        }
        if (b < 0.0 || -a > b) {
            return diff > 1.0E-4 * a;
        }
        return diff > -1.0E-4 * b;
    }

    private final void classifyAffine() {
        this.type = !this.isInfOrNaN() && Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostOne(this.mat[15]) ? (this.type |= 0x80) : (this.type &= 0xFFFFFF7F);
        this.dirtyBits &= 0xFFFFFFFE;
    }

    private final void classifyRigid() {
        if ((this.dirtyBits & 1) != 0) {
            this.type &= 0x40000000;
            this.classifyAffine();
        } else {
            this.type &= 0x40000080;
        }
        if ((this.type & 0x80) != 0 && this.isOrtho()) {
            if ((this.dirtyBits & 0x20) != 0) {
                double s2;
                double s0 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                double s1 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
                if (Transform3D.almostEqual(s0, s1) && Transform3D.almostEqual(s2 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10], s0)) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(s0)) {
                        this.type |= 0x20;
                    }
                }
            } else {
                double s;
                if (this.scales == null) {
                    this.scales = new double[3];
                }
                if (Transform3D.almostEqual(s = this.scales[0], this.scales[1]) && Transform3D.almostEqual(s, this.scales[2])) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(s)) {
                        this.type |= 0x20;
                    }
                }
            }
        }
        this.dirtyBits &= 0xFFFFFFFF;
    }

    private final void classify() {
        if ((this.dirtyBits & 0xD) != 0) {
            this.classifyRigid();
        }
        if ((this.type & 0x80) != 0) {
            if ((this.type & 0x40) != 0) {
                if ((this.type & 0x20) != 0) {
                    if (this.zeroTranslation()) {
                        this.type |= 0x10;
                        if (this.rotateZero() && this.mat[0] > 0.0 && this.mat[5] > 0.0 && this.mat[10] > 0.0) {
                            this.type |= 0xE;
                        }
                    } else if (this.rotateZero()) {
                        this.type |= 8;
                    }
                } else if (this.zeroTranslation() && this.rotateZero()) {
                    this.type |= 4;
                }
            }
        } else if (Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostZero(this.mat[15]) && this.zeroTranslation() && this.rotateZero() && Transform3D.almostZero(this.mat[0]) && Transform3D.almostZero(this.mat[5]) && Transform3D.almostZero(this.mat[10])) {
            this.type |= 1;
        }
        if (!this.getDeterminantSign()) {
            this.type |= 0x100;
        }
        this.dirtyBits &= 0xFFFFFFEF;
    }

    final boolean zeroTranslation() {
        return Transform3D.almostZero(this.mat[3]) && Transform3D.almostZero(this.mat[7]) && Transform3D.almostZero(this.mat[11]);
    }

    final boolean rotateZero() {
        return Transform3D.almostZero(this.mat[1]) && Transform3D.almostZero(this.mat[2]) && Transform3D.almostZero(this.mat[4]) && Transform3D.almostZero(this.mat[6]) && Transform3D.almostZero(this.mat[8]) && Transform3D.almostZero(this.mat[9]);
    }

    public String toString() {
        return this.mat[0] + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15] + "\n";
    }

    public final void setIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 1073742078;
        this.dirtyBits = 96;
    }

    public final void setZero() {
        this.mat[0] = 0.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 0.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 0.0;
        this.type = 0x40000001;
        this.dirtyBits = 96;
    }

    public final void add(Transform3D t1) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.mat[n] = this.mat[n] + t1.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void add(Transform3D t1, Transform3D t2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = t1.mat[i] + t2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D t1) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.mat[n] = this.mat[n] - t1.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D t1, Transform3D t2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = t1.mat[i] - t2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose() {
        double temp = this.mat[4];
        this.mat[4] = this.mat[1];
        this.mat[1] = temp;
        temp = this.mat[8];
        this.mat[8] = this.mat[2];
        this.mat[2] = temp;
        temp = this.mat[12];
        this.mat[12] = this.mat[3];
        this.mat[3] = temp;
        temp = this.mat[9];
        this.mat[9] = this.mat[6];
        this.mat[6] = temp;
        temp = this.mat[13];
        this.mat[13] = this.mat[7];
        this.mat[7] = temp;
        temp = this.mat[14];
        this.mat[14] = this.mat[11];
        this.mat[11] = temp;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose(Transform3D t1) {
        if (this != t1) {
            this.mat[0] = t1.mat[0];
            this.mat[1] = t1.mat[4];
            this.mat[2] = t1.mat[8];
            this.mat[3] = t1.mat[12];
            this.mat[4] = t1.mat[1];
            this.mat[5] = t1.mat[5];
            this.mat[6] = t1.mat[9];
            this.mat[7] = t1.mat[13];
            this.mat[8] = t1.mat[2];
            this.mat[9] = t1.mat[6];
            this.mat[10] = t1.mat[10];
            this.mat[11] = t1.mat[14];
            this.mat[12] = t1.mat[3];
            this.mat[13] = t1.mat[7];
            this.mat[14] = t1.mat[11];
            this.mat[15] = t1.mat[15];
            this.dirtyBits = 255;
            if (this.autoNormalize) {
                this.normalize();
            }
        } else {
            this.transpose();
        }
    }

    public final void set(Quat4f q1) {
        this.mat[0] = 1.0f - 2.0f * q1.y * q1.y - 2.0f * q1.z * q1.z;
        this.mat[4] = 2.0f * (q1.x * q1.y + q1.w * q1.z);
        this.mat[8] = 2.0f * (q1.x * q1.z - q1.w * q1.y);
        this.mat[1] = 2.0f * (q1.x * q1.y - q1.w * q1.z);
        this.mat[5] = 1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.z * q1.z;
        this.mat[9] = 2.0f * (q1.y * q1.z + q1.w * q1.x);
        this.mat[2] = 2.0f * (q1.x * q1.z + q1.w * q1.y);
        this.mat[6] = 2.0f * (q1.y * q1.z - q1.w * q1.x);
        this.mat[10] = 1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.y * q1.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(q1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits = 112;
        this.type = 0x400000E0;
    }

    public final void set(Quat4d q1) {
        this.mat[0] = 1.0 - 2.0 * q1.y * q1.y - 2.0 * q1.z * q1.z;
        this.mat[4] = 2.0 * (q1.x * q1.y + q1.w * q1.z);
        this.mat[8] = 2.0 * (q1.x * q1.z - q1.w * q1.y);
        this.mat[1] = 2.0 * (q1.x * q1.y - q1.w * q1.z);
        this.mat[5] = 1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.z * q1.z;
        this.mat[9] = 2.0 * (q1.y * q1.z + q1.w * q1.x);
        this.mat[2] = 2.0 * (q1.x * q1.z + q1.w * q1.y);
        this.mat[6] = 2.0 * (q1.y * q1.z - q1.w * q1.x);
        this.mat[10] = 1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.y * q1.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(q1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits = 112;
        this.type = 0x400000E0;
    }

    public final void setRotation(Matrix3d m1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = m1.m00 * this.scales[0];
        this.mat[1] = m1.m01 * this.scales[1];
        this.mat[2] = m1.m02 * this.scales[2];
        this.mat[4] = m1.m10 * this.scales[0];
        this.mat[5] = m1.m11 * this.scales[1];
        this.mat[6] = m1.m12 * this.scales[2];
        this.mat[8] = m1.m20 * this.scales[0];
        this.mat[9] = m1.m21 * this.scales[1];
        this.mat[10] = m1.m22 * this.scales[2];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Matrix3f m1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (double)m1.m00 * this.scales[0];
        this.mat[1] = (double)m1.m01 * this.scales[1];
        this.mat[2] = (double)m1.m02 * this.scales[2];
        this.mat[4] = (double)m1.m10 * this.scales[0];
        this.mat[5] = (double)m1.m11 * this.scales[1];
        this.mat[6] = (double)m1.m12 * this.scales[2];
        this.mat[8] = (double)m1.m20 * this.scales[0];
        this.mat[9] = (double)m1.m21 * this.scales[1];
        this.mat[10] = (double)m1.m22 * this.scales[2];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Quat4f q1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * (double)q1.y * (double)q1.y - 2.0 * (double)q1.z * (double)q1.z) * this.scales[0];
        this.mat[4] = 2.0 * (double)(q1.x * q1.y + q1.w * q1.z) * this.scales[0];
        this.mat[8] = 2.0 * (double)(q1.x * q1.z - q1.w * q1.y) * this.scales[0];
        this.mat[1] = 2.0 * (double)(q1.x * q1.y - q1.w * q1.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * (double)q1.x * (double)q1.x - 2.0 * (double)q1.z * (double)q1.z) * this.scales[1];
        this.mat[9] = 2.0 * (double)(q1.y * q1.z + q1.w * q1.x) * this.scales[1];
        this.mat[2] = 2.0 * (double)(q1.x * q1.z + q1.w * q1.y) * this.scales[2];
        this.mat[6] = 2.0 * (double)(q1.y * q1.z - q1.w * q1.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * (double)q1.x * (double)q1.x - 2.0 * (double)q1.y * (double)q1.y) * this.scales[2];
        if (this.isInfOrNaN(q1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void setRotation(Quat4d q1) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * q1.y * q1.y - 2.0 * q1.z * q1.z) * this.scales[0];
        this.mat[4] = 2.0 * (q1.x * q1.y + q1.w * q1.z) * this.scales[0];
        this.mat[8] = 2.0 * (q1.x * q1.z - q1.w * q1.y) * this.scales[0];
        this.mat[1] = 2.0 * (q1.x * q1.y - q1.w * q1.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.z * q1.z) * this.scales[1];
        this.mat[9] = 2.0 * (q1.y * q1.z + q1.w * q1.x) * this.scales[1];
        this.mat[2] = 2.0 * (q1.x * q1.z + q1.w * q1.y) * this.scales[2];
        this.mat[6] = 2.0 * (q1.y * q1.z - q1.w * q1.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.y * q1.y) * this.scales[2];
        if (this.isInfOrNaN(q1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void set(AxisAngle4f a1) {
        double mag = Math.sqrt(a1.x * a1.x + a1.y * a1.y + a1.z * a1.z);
        if (Transform3D.almostZero(mag)) {
            this.setIdentity();
        } else {
            mag = 1.0 / mag;
            double ax = (double)a1.x * mag;
            double ay = (double)a1.y * mag;
            double az = (double)a1.z * mag;
            double sinTheta = Math.sin(a1.angle);
            double cosTheta = Math.cos(a1.angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = t * ax * ax + cosTheta;
            this.mat[1] = t * xy - sinTheta * az;
            this.mat[2] = t * xz + sinTheta * ay;
            this.mat[3] = 0.0;
            this.mat[4] = t * xy + sinTheta * az;
            this.mat[5] = t * ay * ay + cosTheta;
            this.mat[6] = t * yz - sinTheta * ax;
            this.mat[7] = 0.0;
            this.mat[8] = t * xz - sinTheta * ay;
            this.mat[9] = t * yz + sinTheta * ax;
            this.mat[10] = t * az * az + cosTheta;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            if (this.isInfOrNaN(a1)) {
                this.dirtyBits = 255;
                return;
            }
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void set(AxisAngle4d a1) {
        double mag = Math.sqrt(a1.x * a1.x + a1.y * a1.y + a1.z * a1.z);
        if (Transform3D.almostZero(mag)) {
            this.setIdentity();
        } else {
            mag = 1.0 / mag;
            double ax = a1.x * mag;
            double ay = a1.y * mag;
            double az = a1.z * mag;
            double sinTheta = Math.sin(a1.angle);
            double cosTheta = Math.cos(a1.angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = t * ax * ax + cosTheta;
            this.mat[1] = t * xy - sinTheta * az;
            this.mat[2] = t * xz + sinTheta * ay;
            this.mat[3] = 0.0;
            this.mat[4] = t * xy + sinTheta * az;
            this.mat[5] = t * ay * ay + cosTheta;
            this.mat[6] = t * yz - sinTheta * ax;
            this.mat[7] = 0.0;
            this.mat[8] = t * xz - sinTheta * ay;
            this.mat[9] = t * yz + sinTheta * ax;
            this.mat[10] = t * az * az + cosTheta;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            if (this.isInfOrNaN(a1)) {
                this.dirtyBits = 255;
                return;
            }
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setRotation(AxisAngle4d a1) {
        double mag;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(mag = Math.sqrt(a1.x * a1.x + a1.y * a1.y + a1.z * a1.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            mag = 1.0 / mag;
            double ax = a1.x * mag;
            double ay = a1.y * mag;
            double az = a1.z * mag;
            double sinTheta = Math.sin(a1.angle);
            double cosTheta = Math.cos(a1.angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = (t * ax * ax + cosTheta) * this.scales[0];
            this.mat[1] = (t * xy - sinTheta * az) * this.scales[1];
            this.mat[2] = (t * xz + sinTheta * ay) * this.scales[2];
            this.mat[4] = (t * xy + sinTheta * az) * this.scales[0];
            this.mat[5] = (t * ay * ay + cosTheta) * this.scales[1];
            this.mat[6] = (t * yz - sinTheta * ax) * this.scales[2];
            this.mat[8] = (t * xz - sinTheta * ay) * this.scales[0];
            this.mat[9] = (t * yz + sinTheta * ax) * this.scales[1];
            this.mat[10] = (t * az * az + cosTheta) * this.scales[2];
        }
        if (this.isInfOrNaN(a1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void setRotation(AxisAngle4f a1) {
        double mag;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(mag = Math.sqrt(a1.x * a1.x + a1.y * a1.y + a1.z * a1.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            mag = 1.0 / mag;
            double ax = (double)a1.x * mag;
            double ay = (double)a1.y * mag;
            double az = (double)a1.z * mag;
            double sinTheta = Math.sin(a1.angle);
            double cosTheta = Math.cos(a1.angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            this.mat[0] = (t * ax * ax + cosTheta) * this.scales[0];
            this.mat[1] = (t * xy - sinTheta * az) * this.scales[1];
            this.mat[2] = (t * xz + sinTheta * ay) * this.scales[2];
            this.mat[4] = (t * xy + sinTheta * az) * this.scales[0];
            this.mat[5] = (t * ay * ay + cosTheta) * this.scales[1];
            this.mat[6] = (t * yz - sinTheta * ax) * this.scales[2];
            this.mat[8] = (t * xz - sinTheta * ay) * this.scales[0];
            this.mat[9] = (t * yz + sinTheta * ax) * this.scales[1];
            this.mat[10] = (t * az * az + cosTheta) * this.scales[2];
        }
        if (this.isInfOrNaN(a1)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFF;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public void rotX(double angle) {
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = cosAngle;
        this.mat[6] = -sinAngle;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = sinAngle;
        this.mat[10] = cosAngle;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(angle)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public void rotY(double angle) {
        double cosAngle;
        double sinAngle = Math.sin(angle);
        this.mat[0] = cosAngle = Math.cos(angle);
        this.mat[1] = 0.0;
        this.mat[2] = sinAngle;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = -sinAngle;
        this.mat[9] = 0.0;
        this.mat[10] = cosAngle;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(angle)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public void rotZ(double angle) {
        double cosAngle;
        double sinAngle = Math.sin(angle);
        this.mat[0] = cosAngle = Math.cos(angle);
        this.mat[1] = -sinAngle;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = sinAngle;
        this.mat[5] = cosAngle;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(angle)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void set(Vector3f trans) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = trans.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = trans.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = trans.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(trans)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void set(Vector3d trans) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = trans.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = trans.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = trans.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(trans)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void setScale(double scale) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[1] = this.scales[2] = scale;
        this.scales[0] = this.scales[2];
        this.mat[0] = this.rot[0] * scale;
        this.mat[1] = this.rot[1] * scale;
        this.mat[2] = this.rot[2] * scale;
        this.mat[4] = this.rot[3] * scale;
        this.mat[5] = this.rot[4] * scale;
        this.mat[6] = this.rot[5] * scale;
        this.mat[8] = this.rot[6] * scale;
        this.mat[9] = this.rot[7] * scale;
        this.mat[10] = this.rot[8] * scale;
        if (this.isInfOrNaN(scale)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x9C;
        this.dirtyBits &= 0xFFFFFFDF;
    }

    public final void setScale(Vector3d scale) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[0] = scale.x;
        this.scales[1] = scale.y;
        this.scales[2] = scale.z;
        this.mat[0] = this.rot[0] * scale.x;
        this.mat[1] = this.rot[1] * scale.y;
        this.mat[2] = this.rot[2] * scale.z;
        this.mat[4] = this.rot[3] * scale.x;
        this.mat[5] = this.rot[4] * scale.y;
        this.mat[6] = this.rot[5] * scale.z;
        this.mat[8] = this.rot[6] * scale.x;
        this.mat[9] = this.rot[7] * scale.y;
        this.mat[10] = this.rot[8] * scale.z;
        if (this.isInfOrNaN(scale)) {
            this.dirtyBits = 255;
            return;
        }
        this.dirtyBits |= 0x9C;
        this.dirtyBits &= 0xFFFFFFDF;
    }

    public final void setNonUniformScale(double xScale, double yScale, double zScale) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[0] = xScale;
        this.scales[1] = yScale;
        this.scales[2] = zScale;
        this.mat[0] = xScale;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = yScale;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = zScale;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void setTranslation(Vector3f trans) {
        this.mat[3] = trans.x;
        this.mat[7] = trans.y;
        this.mat[11] = trans.z;
        if (this.isInfOrNaN(trans)) {
            this.dirtyBits = 255;
            return;
        }
        this.type &= 0xFFFFFFE0;
        this.dirtyBits |= 0x10;
    }

    public final void setTranslation(Vector3d trans) {
        this.mat[3] = trans.x;
        this.mat[7] = trans.y;
        this.mat[11] = trans.z;
        if (this.isInfOrNaN(trans)) {
            this.dirtyBits = 255;
            return;
        }
        this.type &= 0xFFFFFFE0;
        this.dirtyBits |= 0x10;
    }

    public final void set(Quat4d q1, Vector3d t1, double s) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = s;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0 - 2.0 * q1.y * q1.y - 2.0 * q1.z * q1.z) * s;
        this.mat[4] = 2.0 * (q1.x * q1.y + q1.w * q1.z) * s;
        this.mat[8] = 2.0 * (q1.x * q1.z - q1.w * q1.y) * s;
        this.mat[1] = 2.0 * (q1.x * q1.y - q1.w * q1.z) * s;
        this.mat[5] = (1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.z * q1.z) * s;
        this.mat[9] = 2.0 * (q1.y * q1.z + q1.w * q1.x) * s;
        this.mat[2] = 2.0 * (q1.x * q1.z + q1.w * q1.y) * s;
        this.mat[6] = 2.0 * (q1.y * q1.z - q1.w * q1.x) * s;
        this.mat[10] = (1.0 - 2.0 * q1.x * q1.x - 2.0 * q1.y * q1.y) * s;
        this.mat[3] = t1.x;
        this.mat[7] = t1.y;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Quat4f q1, Vector3d t1, double s) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = s;
        this.scales[0] = this.scales[2];
        this.mat[0] = (double)(1.0f - 2.0f * q1.y * q1.y - 2.0f * q1.z * q1.z) * s;
        this.mat[4] = (double)(2.0f * (q1.x * q1.y + q1.w * q1.z)) * s;
        this.mat[8] = (double)(2.0f * (q1.x * q1.z - q1.w * q1.y)) * s;
        this.mat[1] = (double)(2.0f * (q1.x * q1.y - q1.w * q1.z)) * s;
        this.mat[5] = (double)(1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.z * q1.z) * s;
        this.mat[9] = (double)(2.0f * (q1.y * q1.z + q1.w * q1.x)) * s;
        this.mat[2] = (double)(2.0f * (q1.x * q1.z + q1.w * q1.y)) * s;
        this.mat[6] = (double)(2.0f * (q1.y * q1.z - q1.w * q1.x)) * s;
        this.mat[10] = (double)(1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.y * q1.y) * s;
        this.mat[3] = t1.x;
        this.mat[7] = t1.y;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Quat4f q1, Vector3f t1, float s) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = (double)s;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0f - 2.0f * q1.y * q1.y - 2.0f * q1.z * q1.z) * s;
        this.mat[4] = 2.0f * (q1.x * q1.y + q1.w * q1.z) * s;
        this.mat[8] = 2.0f * (q1.x * q1.z - q1.w * q1.y) * s;
        this.mat[1] = 2.0f * (q1.x * q1.y - q1.w * q1.z) * s;
        this.mat[5] = (1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.z * q1.z) * s;
        this.mat[9] = 2.0f * (q1.y * q1.z + q1.w * q1.x) * s;
        this.mat[2] = 2.0f * (q1.x * q1.z + q1.w * q1.y) * s;
        this.mat[6] = 2.0f * (q1.y * q1.z - q1.w * q1.x) * s;
        this.mat[10] = (1.0f - 2.0f * q1.x * q1.x - 2.0f * q1.y * q1.y) * s;
        this.mat[3] = t1.x;
        this.mat[7] = t1.y;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public final void set(Matrix3f m1, Vector3f t1, float s) {
        this.mat[0] = m1.m00 * s;
        this.mat[1] = m1.m01 * s;
        this.mat[2] = m1.m02 * s;
        this.mat[3] = t1.x;
        this.mat[4] = m1.m10 * s;
        this.mat[5] = m1.m11 * s;
        this.mat[6] = m1.m12 * s;
        this.mat[7] = t1.y;
        this.mat[8] = m1.m20 * s;
        this.mat[9] = m1.m21 * s;
        this.mat[10] = m1.m22 * s;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f m1, Vector3d t1, double s) {
        this.mat[0] = (double)m1.m00 * s;
        this.mat[1] = (double)m1.m01 * s;
        this.mat[2] = (double)m1.m02 * s;
        this.mat[3] = t1.x;
        this.mat[4] = (double)m1.m10 * s;
        this.mat[5] = (double)m1.m11 * s;
        this.mat[6] = (double)m1.m12 * s;
        this.mat[7] = t1.y;
        this.mat[8] = (double)m1.m20 * s;
        this.mat[9] = (double)m1.m21 * s;
        this.mat[10] = (double)m1.m22 * s;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d m1, Vector3d t1, double s) {
        this.mat[0] = m1.m00 * s;
        this.mat[1] = m1.m01 * s;
        this.mat[2] = m1.m02 * s;
        this.mat[3] = t1.x;
        this.mat[4] = m1.m10 * s;
        this.mat[5] = m1.m11 * s;
        this.mat[6] = m1.m12 * s;
        this.mat[7] = t1.y;
        this.mat[8] = m1.m20 * s;
        this.mat[9] = m1.m21 * s;
        this.mat[10] = m1.m22 * s;
        this.mat[11] = t1.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(GMatrix matrix) {
        int numRows = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        for (int i = 0; i < 4; ++i) {
            int k = i * 4;
            for (int j = 0; j < 4; ++j) {
                this.mat[k + j] = i >= numRows || j >= numCol ? 0.0 : matrix.getElement(i, j);
            }
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Transform3D t1) {
        this.mat[0] = t1.mat[0];
        this.mat[1] = t1.mat[1];
        this.mat[2] = t1.mat[2];
        this.mat[3] = t1.mat[3];
        this.mat[4] = t1.mat[4];
        this.mat[5] = t1.mat[5];
        this.mat[6] = t1.mat[6];
        this.mat[7] = t1.mat[7];
        this.mat[8] = t1.mat[8];
        this.mat[9] = t1.mat[9];
        this.mat[10] = t1.mat[10];
        this.mat[11] = t1.mat[11];
        this.mat[12] = t1.mat[12];
        this.mat[13] = t1.mat[13];
        this.mat[14] = t1.mat[14];
        this.mat[15] = t1.mat[15];
        this.type = t1.type;
        this.dirtyBits = t1.dirtyBits | 0x40 | 0x20;
        this.autoNormalize = t1.autoNormalize;
    }

    public final void set(double[] matrix) {
        this.mat[0] = matrix[0];
        this.mat[1] = matrix[1];
        this.mat[2] = matrix[2];
        this.mat[3] = matrix[3];
        this.mat[4] = matrix[4];
        this.mat[5] = matrix[5];
        this.mat[6] = matrix[6];
        this.mat[7] = matrix[7];
        this.mat[8] = matrix[8];
        this.mat[9] = matrix[9];
        this.mat[10] = matrix[10];
        this.mat[11] = matrix[11];
        this.mat[12] = matrix[12];
        this.mat[13] = matrix[13];
        this.mat[14] = matrix[14];
        this.mat[15] = matrix[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(float[] matrix) {
        this.mat[0] = matrix[0];
        this.mat[1] = matrix[1];
        this.mat[2] = matrix[2];
        this.mat[3] = matrix[3];
        this.mat[4] = matrix[4];
        this.mat[5] = matrix[5];
        this.mat[6] = matrix[6];
        this.mat[7] = matrix[7];
        this.mat[8] = matrix[8];
        this.mat[9] = matrix[9];
        this.mat[10] = matrix[10];
        this.mat[11] = matrix[11];
        this.mat[12] = matrix[12];
        this.mat[13] = matrix[13];
        this.mat[14] = matrix[14];
        this.mat[15] = matrix[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4d m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[3] = m1.m03;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[7] = m1.m13;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.mat[11] = m1.m23;
        this.mat[12] = m1.m30;
        this.mat[13] = m1.m31;
        this.mat[14] = m1.m32;
        this.mat[15] = m1.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4f m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[3] = m1.m03;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[7] = m1.m13;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.mat[11] = m1.m23;
        this.mat[12] = m1.m30;
        this.mat[13] = m1.m31;
        this.mat[14] = m1.m32;
        this.mat[15] = m1.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[3] = 0.0;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[7] = 0.0;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[3] = 0.0;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[7] = 0.0;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setEuler(Vector3d euler) {
        double sina = Math.sin(euler.x);
        double sinb = Math.sin(euler.y);
        double sinc = Math.sin(euler.z);
        double cosa = Math.cos(euler.x);
        double cosb = Math.cos(euler.y);
        double cosc = Math.cos(euler.z);
        this.mat[0] = cosb * cosc;
        this.mat[1] = -(cosa * sinc) + sina * sinb * cosc;
        this.mat[2] = sina * sinc + cosa * sinb * cosc;
        this.mat[3] = 0.0;
        this.mat[4] = cosb * sinc;
        this.mat[5] = cosa * cosc + sina * sinb * sinc;
        this.mat[6] = -(sina * cosc) + cosa * sinb * sinc;
        this.mat[7] = 0.0;
        this.mat[8] = -sinb;
        this.mat[9] = sina * cosb;
        this.mat[10] = cosa * cosb;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.isInfOrNaN(euler)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void get(double[] matrix) {
        matrix[0] = this.mat[0];
        matrix[1] = this.mat[1];
        matrix[2] = this.mat[2];
        matrix[3] = this.mat[3];
        matrix[4] = this.mat[4];
        matrix[5] = this.mat[5];
        matrix[6] = this.mat[6];
        matrix[7] = this.mat[7];
        matrix[8] = this.mat[8];
        matrix[9] = this.mat[9];
        matrix[10] = this.mat[10];
        matrix[11] = this.mat[11];
        matrix[12] = this.mat[12];
        matrix[13] = this.mat[13];
        matrix[14] = this.mat[14];
        matrix[15] = this.mat[15];
    }

    public final void get(float[] matrix) {
        matrix[0] = (float)this.mat[0];
        matrix[1] = (float)this.mat[1];
        matrix[2] = (float)this.mat[2];
        matrix[3] = (float)this.mat[3];
        matrix[4] = (float)this.mat[4];
        matrix[5] = (float)this.mat[5];
        matrix[6] = (float)this.mat[6];
        matrix[7] = (float)this.mat[7];
        matrix[8] = (float)this.mat[8];
        matrix[9] = (float)this.mat[9];
        matrix[10] = (float)this.mat[10];
        matrix[11] = (float)this.mat[11];
        matrix[12] = (float)this.mat[12];
        matrix[13] = (float)this.mat[13];
        matrix[14] = (float)this.mat[14];
        matrix[15] = (float)this.mat[15];
    }

    public final void get(Matrix3d m1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        m1.m00 = this.rot[0];
        m1.m01 = this.rot[1];
        m1.m02 = this.rot[2];
        m1.m10 = this.rot[3];
        m1.m11 = this.rot[4];
        m1.m12 = this.rot[5];
        m1.m20 = this.rot[6];
        m1.m21 = this.rot[7];
        m1.m22 = this.rot[8];
    }

    public final void get(Matrix3f m1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        m1.m00 = (float)this.rot[0];
        m1.m01 = (float)this.rot[1];
        m1.m02 = (float)this.rot[2];
        m1.m10 = (float)this.rot[3];
        m1.m11 = (float)this.rot[4];
        m1.m12 = (float)this.rot[5];
        m1.m20 = (float)this.rot[6];
        m1.m21 = (float)this.rot[7];
        m1.m22 = (float)this.rot[8];
    }

    public final void get(Quat4f q1) {
        double ww;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((ww = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.w = (float)Math.sqrt(ww);
            ww = 0.25 / (double)q1.w;
            q1.x = (float)((this.rot[7] - this.rot[5]) * ww);
            q1.y = (float)((this.rot[2] - this.rot[6]) * ww);
            q1.z = (float)((this.rot[3] - this.rot[1]) * ww);
            return;
        }
        q1.w = 0.0f;
        ww = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.x = (float)Math.sqrt(ww);
            ww = 0.5 / (double)q1.x;
            q1.y = (float)(this.rot[3] * ww);
            q1.z = (float)(this.rot[6] * ww);
            return;
        }
        q1.x = 0.0f;
        ww = 0.5 * (1.0 - this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.y = (float)Math.sqrt(ww);
            q1.z = (float)(this.rot[7] / (2.0 * (double)q1.y));
            return;
        }
        q1.y = 0.0f;
        q1.z = 1.0f;
    }

    public final void get(Quat4d q1) {
        double ww;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((ww = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.w = Math.sqrt(ww);
            ww = 0.25 / q1.w;
            q1.x = (this.rot[7] - this.rot[5]) * ww;
            q1.y = (this.rot[2] - this.rot[6]) * ww;
            q1.z = (this.rot[3] - this.rot[1]) * ww;
            return;
        }
        q1.w = 0.0;
        ww = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.x = Math.sqrt(ww);
            ww = 0.5 / q1.x;
            q1.y = this.rot[3] * ww;
            q1.z = this.rot[6] * ww;
            return;
        }
        q1.x = 0.0;
        ww = 0.5 * (1.0 - this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.y = Math.sqrt(ww);
            q1.z = this.rot[7] / (2.0 * q1.y);
            return;
        }
        q1.y = 0.0;
        q1.z = 1.0;
    }

    public final void get(Matrix4d matrix) {
        matrix.m00 = this.mat[0];
        matrix.m01 = this.mat[1];
        matrix.m02 = this.mat[2];
        matrix.m03 = this.mat[3];
        matrix.m10 = this.mat[4];
        matrix.m11 = this.mat[5];
        matrix.m12 = this.mat[6];
        matrix.m13 = this.mat[7];
        matrix.m20 = this.mat[8];
        matrix.m21 = this.mat[9];
        matrix.m22 = this.mat[10];
        matrix.m23 = this.mat[11];
        matrix.m30 = this.mat[12];
        matrix.m31 = this.mat[13];
        matrix.m32 = this.mat[14];
        matrix.m33 = this.mat[15];
    }

    public final void get(Matrix4f matrix) {
        matrix.m00 = (float)this.mat[0];
        matrix.m01 = (float)this.mat[1];
        matrix.m02 = (float)this.mat[2];
        matrix.m03 = (float)this.mat[3];
        matrix.m10 = (float)this.mat[4];
        matrix.m11 = (float)this.mat[5];
        matrix.m12 = (float)this.mat[6];
        matrix.m13 = (float)this.mat[7];
        matrix.m20 = (float)this.mat[8];
        matrix.m21 = (float)this.mat[9];
        matrix.m22 = (float)this.mat[10];
        matrix.m23 = (float)this.mat[11];
        matrix.m30 = (float)this.mat[12];
        matrix.m31 = (float)this.mat[13];
        matrix.m32 = (float)this.mat[14];
        matrix.m33 = (float)this.mat[15];
    }

    public final double get(Quat4d q1, Vector3d t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        t1.x = this.mat[3];
        t1.y = this.mat[7];
        t1.z = this.mat[11];
        double maxScale = Transform3D.max3(this.scales);
        double ww = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.w = Math.sqrt(ww);
            ww = 0.25 / q1.w;
            q1.x = (this.rot[7] - this.rot[5]) * ww;
            q1.y = (this.rot[2] - this.rot[6]) * ww;
            q1.z = (this.rot[3] - this.rot[1]) * ww;
            return maxScale;
        }
        q1.w = 0.0;
        ww = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.x = Math.sqrt(ww);
            ww = 0.5 / q1.x;
            q1.y = this.rot[3] * ww;
            q1.z = this.rot[6] * ww;
            return maxScale;
        }
        q1.x = 0.0;
        ww = 0.5 * (1.0 - this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.y = Math.sqrt(ww);
            q1.z = this.rot[7] / (2.0 * q1.y);
            return maxScale;
        }
        q1.y = 0.0;
        q1.z = 1.0;
        return maxScale;
    }

    public final float get(Quat4f q1, Vector3f t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double maxScale = Transform3D.max3(this.scales);
        t1.x = (float)this.mat[3];
        t1.y = (float)this.mat[7];
        t1.z = (float)this.mat[11];
        double ww = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.w = (float)Math.sqrt(ww);
            ww = 0.25 / (double)q1.w;
            q1.x = (float)((this.rot[7] - this.rot[5]) * ww);
            q1.y = (float)((this.rot[2] - this.rot[6]) * ww);
            q1.z = (float)((this.rot[3] - this.rot[1]) * ww);
            return (float)maxScale;
        }
        q1.w = 0.0f;
        ww = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.x = (float)Math.sqrt(ww);
            ww = 0.5 / (double)q1.x;
            q1.y = (float)(this.rot[3] * ww);
            q1.z = (float)(this.rot[6] * ww);
            return (float)maxScale;
        }
        q1.x = 0.0f;
        ww = 0.5 * (1.0 - this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.y = (float)Math.sqrt(ww);
            q1.z = (float)(this.rot[7] / (2.0 * (double)q1.y));
            return (float)maxScale;
        }
        q1.y = 0.0f;
        q1.z = 1.0f;
        return (float)maxScale;
    }

    public final double get(Quat4f q1, Vector3d t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double maxScale = Transform3D.max3(this.scales);
        t1.x = this.mat[3];
        t1.y = this.mat[7];
        t1.z = this.mat[11];
        double ww = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.w = (float)Math.sqrt(ww);
            ww = 0.25 / (double)q1.w;
            q1.x = (float)((this.rot[7] - this.rot[5]) * ww);
            q1.y = (float)((this.rot[2] - this.rot[6]) * ww);
            q1.z = (float)((this.rot[3] - this.rot[1]) * ww);
            return maxScale;
        }
        q1.w = 0.0f;
        ww = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.x = (float)Math.sqrt(ww);
            ww = 0.5 / (double)q1.x;
            q1.y = (float)(this.rot[3] * ww);
            q1.z = (float)(this.rot[6] * ww);
            return maxScale;
        }
        q1.x = 0.0f;
        ww = 0.5 * (1.0 - this.rot[8]);
        if (!((ww < 0.0 ? -ww : ww) < 1.0E-10)) {
            q1.y = (float)Math.sqrt(ww);
            q1.z = (float)(this.rot[7] / (2.0 * (double)q1.y));
            return maxScale;
        }
        q1.y = 0.0f;
        q1.z = 1.0f;
        return maxScale;
    }

    public final double get(Matrix3d m1, Vector3d t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        t1.x = this.mat[3];
        t1.y = this.mat[7];
        t1.z = this.mat[11];
        m1.m00 = this.rot[0];
        m1.m01 = this.rot[1];
        m1.m02 = this.rot[2];
        m1.m10 = this.rot[3];
        m1.m11 = this.rot[4];
        m1.m12 = this.rot[5];
        m1.m20 = this.rot[6];
        m1.m21 = this.rot[7];
        m1.m22 = this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final float get(Matrix3f m1, Vector3f t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        t1.x = (float)this.mat[3];
        t1.y = (float)this.mat[7];
        t1.z = (float)this.mat[11];
        m1.m00 = (float)this.rot[0];
        m1.m01 = (float)this.rot[1];
        m1.m02 = (float)this.rot[2];
        m1.m10 = (float)this.rot[3];
        m1.m11 = (float)this.rot[4];
        m1.m12 = (float)this.rot[5];
        m1.m20 = (float)this.rot[6];
        m1.m21 = (float)this.rot[7];
        m1.m22 = (float)this.rot[8];
        return (float)Transform3D.max3(this.scales);
    }

    public final double get(Matrix3f m1, Vector3d t1) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        t1.x = this.mat[3];
        t1.y = this.mat[7];
        t1.z = this.mat[11];
        m1.m00 = (float)this.rot[0];
        m1.m01 = (float)this.rot[1];
        m1.m02 = (float)this.rot[2];
        m1.m10 = (float)this.rot[3];
        m1.m11 = (float)this.rot[4];
        m1.m12 = (float)this.rot[5];
        m1.m20 = (float)this.rot[6];
        m1.m21 = (float)this.rot[7];
        m1.m22 = (float)this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final double getScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        return Transform3D.max3(this.scales);
    }

    public final void getScale(Vector3d scale) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        scale.x = this.scales[0];
        scale.y = this.scales[1];
        scale.z = this.scales[2];
    }

    public final void get(Vector3f trans) {
        trans.x = (float)this.mat[3];
        trans.y = (float)this.mat[7];
        trans.z = (float)this.mat[11];
    }

    public final void get(Vector3d trans) {
        trans.x = this.mat[3];
        trans.y = this.mat[7];
        trans.z = this.mat[11];
    }

    public final void invert(Transform3D t1) {
        if (t1 == this) {
            this.invert();
        } else if (t1.isAffine()) {
            this.invertAffine(t1);
        } else {
            this.invertGeneral(t1);
        }
    }

    public final void invert() {
        if (this.isAffine()) {
            this.invertAffine();
        } else {
            this.invertGeneral(this);
        }
    }

    final void invertAffine(Transform3D t1) {
        double determinant = t1.affineDeterminant();
        if (determinant == 0.0) {
            throw new SingularMatrixException("Transform3D1");
        }
        double s = (t1.mat[0] * t1.mat[0] + t1.mat[1] * t1.mat[1] + t1.mat[2] * t1.mat[2] + t1.mat[3] * t1.mat[3]) * (t1.mat[4] * t1.mat[4] + t1.mat[5] * t1.mat[5] + t1.mat[6] * t1.mat[6] + t1.mat[7] * t1.mat[7]) * (t1.mat[8] * t1.mat[8] + t1.mat[9] * t1.mat[9] + t1.mat[10] * t1.mat[10] + t1.mat[11] * t1.mat[11]);
        if (determinant * determinant < 1.110223024E-16 * s) {
            this.invertGeneral(t1);
            return;
        }
        s = 1.0 / determinant;
        this.mat[0] = (t1.mat[5] * t1.mat[10] - t1.mat[9] * t1.mat[6]) * s;
        this.mat[1] = -(t1.mat[1] * t1.mat[10] - t1.mat[9] * t1.mat[2]) * s;
        this.mat[2] = (t1.mat[1] * t1.mat[6] - t1.mat[5] * t1.mat[2]) * s;
        this.mat[4] = -(t1.mat[4] * t1.mat[10] - t1.mat[8] * t1.mat[6]) * s;
        this.mat[5] = (t1.mat[0] * t1.mat[10] - t1.mat[8] * t1.mat[2]) * s;
        this.mat[6] = -(t1.mat[0] * t1.mat[6] - t1.mat[4] * t1.mat[2]) * s;
        this.mat[8] = (t1.mat[4] * t1.mat[9] - t1.mat[8] * t1.mat[5]) * s;
        this.mat[9] = -(t1.mat[0] * t1.mat[9] - t1.mat[8] * t1.mat[1]) * s;
        this.mat[10] = (t1.mat[0] * t1.mat[5] - t1.mat[4] * t1.mat[1]) * s;
        this.mat[3] = -(t1.mat[3] * this.mat[0] + t1.mat[7] * this.mat[1] + t1.mat[11] * this.mat[2]);
        this.mat[7] = -(t1.mat[3] * this.mat[4] + t1.mat[7] * this.mat[5] + t1.mat[11] * this.mat[6]);
        this.mat[11] = -(t1.mat[3] * this.mat[8] + t1.mat[7] * this.mat[9] + t1.mat[11] * this.mat[10]);
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = t1.dirtyBits | 0xE0 | 0x10 | 2;
        this.type = t1.type;
    }

    final void invertAffine() {
        double determinant = this.affineDeterminant();
        if (determinant == 0.0) {
            throw new SingularMatrixException("Transform3D1");
        }
        double s = (this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3]) * (this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7]) * (this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11]);
        if (determinant * determinant < 1.110223024E-16 * s) {
            this.invertGeneral(this);
            return;
        }
        s = 1.0 / determinant;
        double tmp0 = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * s;
        double tmp1 = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * s;
        double tmp2 = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * s;
        double tmp4 = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * s;
        double tmp5 = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * s;
        double tmp6 = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * s;
        double tmp8 = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * s;
        double tmp9 = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * s;
        double tmp10 = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * s;
        double tmp3 = -(this.mat[3] * tmp0 + this.mat[7] * tmp1 + this.mat[11] * tmp2);
        double tmp7 = -(this.mat[3] * tmp4 + this.mat[7] * tmp5 + this.mat[11] * tmp6);
        this.mat[11] = -(this.mat[3] * tmp8 + this.mat[7] * tmp9 + this.mat[11] * tmp10);
        this.mat[0] = tmp0;
        this.mat[1] = tmp1;
        this.mat[2] = tmp2;
        this.mat[3] = tmp3;
        this.mat[4] = tmp4;
        this.mat[5] = tmp5;
        this.mat[6] = tmp6;
        this.mat[7] = tmp7;
        this.mat[8] = tmp8;
        this.mat[9] = tmp9;
        this.mat[10] = tmp10;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits |= 0xF2;
    }

    final void invertGeneral(Transform3D t1) {
        double[] tmp = new double[16];
        int[] row_perm = new int[4];
        System.arraycopy(t1.mat, 0, tmp, 0, tmp.length);
        if (!Transform3D.luDecomposition(tmp, row_perm)) {
            throw new SingularMatrixException("Transform3D1");
        }
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        Transform3D.luBacksubstitution(tmp, row_perm, this.mat);
        this.type = 0;
        this.dirtyBits = 255;
    }

    static boolean luDecomposition(double[] matrix0, int[] row_perm) {
        double[] row_scale = new double[4];
        int ptr = 0;
        int rs = 0;
        int i = 4;
        while (i-- != 0) {
            double big = 0.0;
            int j = 4;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            row_scale[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j = 0; j < 4; ++j) {
            double temp;
            int p1;
            int k;
            int p2;
            double sum;
            int target;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                int k2 = i2;
                int p12 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k2-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 4;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i2 = j; i2 < 4; ++i2) {
                double d;
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                k = j;
                p1 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                temp = row_scale[i2] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = temp;
                imax = i2;
            }
            if (imax < 0) {
                return false;
            }
            if (j != imax) {
                k = 4;
                p1 = mtx + 4 * imax;
                p2 = mtx + 4 * j;
                while (k-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                row_scale[imax] = row_scale[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 4 * j + j] == 0.0) {
                return false;
            }
            if (j == 3) continue;
            temp = 1.0 / matrix0[mtx + 4 * j + j];
            target = mtx + 4 * (j + 1) + j;
            i2 = 3 - j;
            while (i2-- != 0) {
                int n = target;
                matrix0[n] = matrix0[n] * temp;
                target += 4;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k = 0; k < 4; ++k) {
            int rv;
            int cv = k;
            int ii = -1;
            for (int i = 0; i < 4; ++i) {
                int ip = row_perm[rp + i];
                double sum = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i];
                if (ii >= 0) {
                    rv = i * 4;
                    for (int j = ii; j <= i - 1; ++j) {
                        sum -= matrix1[rv + j] * matrix2[cv + 4 * j];
                    }
                } else if (sum != 0.0) {
                    ii = i;
                }
                matrix2[cv + 4 * i] = sum;
            }
            rv = 12;
            int n = cv + 12;
            matrix2[n] = matrix2[n] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
        }
    }

    final double affineDeterminant() {
        return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
    }

    public final double determinant() {
        if (this.isAffine()) {
            return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
        }
        return this.mat[0] * (this.mat[5] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) + this.mat[7] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13])) - this.mat[1] * (this.mat[4] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12])) + this.mat[2] * (this.mat[4] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12])) - this.mat[3] * (this.mat[4] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12]) + this.mat[6] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12]));
    }

    public final void set(double scale) {
        this.setScaleTranslation(0.0, 0.0, 0.0, scale);
    }

    public final void set(double scale, Vector3d v1) {
        this.setScaleTranslation(v1.x, v1.y, v1.z, scale);
    }

    public final void set(float scale, Vector3f v1) {
        this.setScaleTranslation(v1.x, v1.y, v1.z, scale);
    }

    public final void set(Vector3d v1, double scale) {
        this.setScaleTranslation(v1.x * scale, v1.y * scale, v1.z * scale, scale);
    }

    public final void set(Vector3f v1, float scale) {
        this.setScaleTranslation(v1.x * scale, v1.y * scale, v1.z * scale, scale);
    }

    private final void setScaleTranslation(double x, double y, double z, double scale) {
        this.mat[0] = scale;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = x;
        this.mat[4] = 0.0;
        this.mat[5] = scale;
        this.mat[6] = 0.0;
        this.mat[7] = y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = scale;
        this.mat[11] = z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = scale;
        this.scales[0] = this.scales[2];
        if (this.isInfOrNaN(x) || this.isInfOrNaN(y) || this.isInfOrNaN(z) || this.isInfOrNaN(scale)) {
            this.dirtyBits = 255;
            return;
        }
        this.type = 0x400000C0;
        this.dirtyBits = 88;
    }

    public final void mul(double scalar) {
        int i = 0;
        while (i < 16) {
            int n = i++;
            this.mat[n] = this.mat[n] * scalar;
        }
        this.dirtyBits = 255;
    }

    public final void mul(double scalar, Transform3D t1) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = t1.mat[i] * scalar;
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D t1) {
        double tmp11;
        double tmp10;
        double tmp9;
        double tmp8;
        double tmp7;
        double tmp6;
        double tmp5;
        double tmp4;
        double tmp3;
        double tmp2;
        double tmp1;
        double tmp0;
        boolean aff = false;
        if (t1.isAffine()) {
            tmp0 = this.mat[0] * t1.mat[0] + this.mat[1] * t1.mat[4] + this.mat[2] * t1.mat[8];
            tmp1 = this.mat[0] * t1.mat[1] + this.mat[1] * t1.mat[5] + this.mat[2] * t1.mat[9];
            tmp2 = this.mat[0] * t1.mat[2] + this.mat[1] * t1.mat[6] + this.mat[2] * t1.mat[10];
            tmp3 = this.mat[0] * t1.mat[3] + this.mat[1] * t1.mat[7] + this.mat[2] * t1.mat[11] + this.mat[3];
            tmp4 = this.mat[4] * t1.mat[0] + this.mat[5] * t1.mat[4] + this.mat[6] * t1.mat[8];
            tmp5 = this.mat[4] * t1.mat[1] + this.mat[5] * t1.mat[5] + this.mat[6] * t1.mat[9];
            tmp6 = this.mat[4] * t1.mat[2] + this.mat[5] * t1.mat[6] + this.mat[6] * t1.mat[10];
            tmp7 = this.mat[4] * t1.mat[3] + this.mat[5] * t1.mat[7] + this.mat[6] * t1.mat[11] + this.mat[7];
            tmp8 = this.mat[8] * t1.mat[0] + this.mat[9] * t1.mat[4] + this.mat[10] * t1.mat[8];
            tmp9 = this.mat[8] * t1.mat[1] + this.mat[9] * t1.mat[5] + this.mat[10] * t1.mat[9];
            tmp10 = this.mat[8] * t1.mat[2] + this.mat[9] * t1.mat[6] + this.mat[10] * t1.mat[10];
            tmp11 = this.mat[8] * t1.mat[3] + this.mat[9] * t1.mat[7] + this.mat[10] * t1.mat[11] + this.mat[11];
            if (this.isAffine()) {
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                aff = true;
            } else {
                double tmp12 = this.mat[12] * t1.mat[0] + this.mat[13] * t1.mat[4] + this.mat[14] * t1.mat[8];
                double tmp13 = this.mat[12] * t1.mat[1] + this.mat[13] * t1.mat[5] + this.mat[14] * t1.mat[9];
                double tmp14 = this.mat[12] * t1.mat[2] + this.mat[13] * t1.mat[6] + this.mat[14] * t1.mat[10];
                double tmp15 = this.mat[12] * t1.mat[3] + this.mat[13] * t1.mat[7] + this.mat[14] * t1.mat[11] + this.mat[15];
                this.mat[12] = tmp12;
                this.mat[13] = tmp13;
                this.mat[14] = tmp14;
                this.mat[15] = tmp15;
            }
        } else {
            tmp0 = this.mat[0] * t1.mat[0] + this.mat[1] * t1.mat[4] + this.mat[2] * t1.mat[8] + this.mat[3] * t1.mat[12];
            tmp1 = this.mat[0] * t1.mat[1] + this.mat[1] * t1.mat[5] + this.mat[2] * t1.mat[9] + this.mat[3] * t1.mat[13];
            tmp2 = this.mat[0] * t1.mat[2] + this.mat[1] * t1.mat[6] + this.mat[2] * t1.mat[10] + this.mat[3] * t1.mat[14];
            tmp3 = this.mat[0] * t1.mat[3] + this.mat[1] * t1.mat[7] + this.mat[2] * t1.mat[11] + this.mat[3] * t1.mat[15];
            tmp4 = this.mat[4] * t1.mat[0] + this.mat[5] * t1.mat[4] + this.mat[6] * t1.mat[8] + this.mat[7] * t1.mat[12];
            tmp5 = this.mat[4] * t1.mat[1] + this.mat[5] * t1.mat[5] + this.mat[6] * t1.mat[9] + this.mat[7] * t1.mat[13];
            tmp6 = this.mat[4] * t1.mat[2] + this.mat[5] * t1.mat[6] + this.mat[6] * t1.mat[10] + this.mat[7] * t1.mat[14];
            tmp7 = this.mat[4] * t1.mat[3] + this.mat[5] * t1.mat[7] + this.mat[6] * t1.mat[11] + this.mat[7] * t1.mat[15];
            tmp8 = this.mat[8] * t1.mat[0] + this.mat[9] * t1.mat[4] + this.mat[10] * t1.mat[8] + this.mat[11] * t1.mat[12];
            tmp9 = this.mat[8] * t1.mat[1] + this.mat[9] * t1.mat[5] + this.mat[10] * t1.mat[9] + this.mat[11] * t1.mat[13];
            tmp10 = this.mat[8] * t1.mat[2] + this.mat[9] * t1.mat[6] + this.mat[10] * t1.mat[10] + this.mat[11] * t1.mat[14];
            tmp11 = this.mat[8] * t1.mat[3] + this.mat[9] * t1.mat[7] + this.mat[10] * t1.mat[11] + this.mat[11] * t1.mat[15];
            if (this.isAffine()) {
                this.mat[12] = t1.mat[12];
                this.mat[13] = t1.mat[13];
                this.mat[14] = t1.mat[14];
                this.mat[15] = t1.mat[15];
            } else {
                double tmp12 = this.mat[12] * t1.mat[0] + this.mat[13] * t1.mat[4] + this.mat[14] * t1.mat[8] + this.mat[15] * t1.mat[12];
                double tmp13 = this.mat[12] * t1.mat[1] + this.mat[13] * t1.mat[5] + this.mat[14] * t1.mat[9] + this.mat[15] * t1.mat[13];
                double tmp14 = this.mat[12] * t1.mat[2] + this.mat[13] * t1.mat[6] + this.mat[14] * t1.mat[10] + this.mat[15] * t1.mat[14];
                double tmp15 = this.mat[12] * t1.mat[3] + this.mat[13] * t1.mat[7] + this.mat[14] * t1.mat[11] + this.mat[15] * t1.mat[15];
                this.mat[12] = tmp12;
                this.mat[13] = tmp13;
                this.mat[14] = tmp14;
                this.mat[15] = tmp15;
            }
        }
        this.mat[0] = tmp0;
        this.mat[1] = tmp1;
        this.mat[2] = tmp2;
        this.mat[3] = tmp3;
        this.mat[4] = tmp4;
        this.mat[5] = tmp5;
        this.mat[6] = tmp6;
        this.mat[7] = tmp7;
        this.mat[8] = tmp8;
        this.mat[9] = tmp9;
        this.mat[10] = tmp10;
        this.mat[11] = tmp11;
        if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0 && (t1.dirtyBits & 4) == 0 && (t1.type & 0x40) != 0) {
            this.type &= t1.type;
            this.dirtyBits |= t1.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = aff ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D t1, Transform3D t2) {
        boolean aff = false;
        if (this != t1 && this != t2) {
            if (t2.isAffine()) {
                this.mat[0] = t1.mat[0] * t2.mat[0] + t1.mat[1] * t2.mat[4] + t1.mat[2] * t2.mat[8];
                this.mat[1] = t1.mat[0] * t2.mat[1] + t1.mat[1] * t2.mat[5] + t1.mat[2] * t2.mat[9];
                this.mat[2] = t1.mat[0] * t2.mat[2] + t1.mat[1] * t2.mat[6] + t1.mat[2] * t2.mat[10];
                this.mat[3] = t1.mat[0] * t2.mat[3] + t1.mat[1] * t2.mat[7] + t1.mat[2] * t2.mat[11] + t1.mat[3];
                this.mat[4] = t1.mat[4] * t2.mat[0] + t1.mat[5] * t2.mat[4] + t1.mat[6] * t2.mat[8];
                this.mat[5] = t1.mat[4] * t2.mat[1] + t1.mat[5] * t2.mat[5] + t1.mat[6] * t2.mat[9];
                this.mat[6] = t1.mat[4] * t2.mat[2] + t1.mat[5] * t2.mat[6] + t1.mat[6] * t2.mat[10];
                this.mat[7] = t1.mat[4] * t2.mat[3] + t1.mat[5] * t2.mat[7] + t1.mat[6] * t2.mat[11] + t1.mat[7];
                this.mat[8] = t1.mat[8] * t2.mat[0] + t1.mat[9] * t2.mat[4] + t1.mat[10] * t2.mat[8];
                this.mat[9] = t1.mat[8] * t2.mat[1] + t1.mat[9] * t2.mat[5] + t1.mat[10] * t2.mat[9];
                this.mat[10] = t1.mat[8] * t2.mat[2] + t1.mat[9] * t2.mat[6] + t1.mat[10] * t2.mat[10];
                this.mat[11] = t1.mat[8] * t2.mat[3] + t1.mat[9] * t2.mat[7] + t1.mat[10] * t2.mat[11] + t1.mat[11];
                if (t1.isAffine()) {
                    aff = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    this.mat[12] = t1.mat[12] * t2.mat[0] + t1.mat[13] * t2.mat[4] + t1.mat[14] * t2.mat[8];
                    this.mat[13] = t1.mat[12] * t2.mat[1] + t1.mat[13] * t2.mat[5] + t1.mat[14] * t2.mat[9];
                    this.mat[14] = t1.mat[12] * t2.mat[2] + t1.mat[13] * t2.mat[6] + t1.mat[14] * t2.mat[10];
                    this.mat[15] = t1.mat[12] * t2.mat[3] + t1.mat[13] * t2.mat[7] + t1.mat[14] * t2.mat[11] + t1.mat[15];
                }
            } else {
                this.mat[0] = t1.mat[0] * t2.mat[0] + t1.mat[1] * t2.mat[4] + t1.mat[2] * t2.mat[8] + t1.mat[3] * t2.mat[12];
                this.mat[1] = t1.mat[0] * t2.mat[1] + t1.mat[1] * t2.mat[5] + t1.mat[2] * t2.mat[9] + t1.mat[3] * t2.mat[13];
                this.mat[2] = t1.mat[0] * t2.mat[2] + t1.mat[1] * t2.mat[6] + t1.mat[2] * t2.mat[10] + t1.mat[3] * t2.mat[14];
                this.mat[3] = t1.mat[0] * t2.mat[3] + t1.mat[1] * t2.mat[7] + t1.mat[2] * t2.mat[11] + t1.mat[3] * t2.mat[15];
                this.mat[4] = t1.mat[4] * t2.mat[0] + t1.mat[5] * t2.mat[4] + t1.mat[6] * t2.mat[8] + t1.mat[7] * t2.mat[12];
                this.mat[5] = t1.mat[4] * t2.mat[1] + t1.mat[5] * t2.mat[5] + t1.mat[6] * t2.mat[9] + t1.mat[7] * t2.mat[13];
                this.mat[6] = t1.mat[4] * t2.mat[2] + t1.mat[5] * t2.mat[6] + t1.mat[6] * t2.mat[10] + t1.mat[7] * t2.mat[14];
                this.mat[7] = t1.mat[4] * t2.mat[3] + t1.mat[5] * t2.mat[7] + t1.mat[6] * t2.mat[11] + t1.mat[7] * t2.mat[15];
                this.mat[8] = t1.mat[8] * t2.mat[0] + t1.mat[9] * t2.mat[4] + t1.mat[10] * t2.mat[8] + t1.mat[11] * t2.mat[12];
                this.mat[9] = t1.mat[8] * t2.mat[1] + t1.mat[9] * t2.mat[5] + t1.mat[10] * t2.mat[9] + t1.mat[11] * t2.mat[13];
                this.mat[10] = t1.mat[8] * t2.mat[2] + t1.mat[9] * t2.mat[6] + t1.mat[10] * t2.mat[10] + t1.mat[11] * t2.mat[14];
                this.mat[11] = t1.mat[8] * t2.mat[3] + t1.mat[9] * t2.mat[7] + t1.mat[10] * t2.mat[11] + t1.mat[11] * t2.mat[15];
                if (t1.isAffine()) {
                    this.mat[12] = t2.mat[12];
                    this.mat[13] = t2.mat[13];
                    this.mat[14] = t2.mat[14];
                    this.mat[15] = t2.mat[15];
                } else {
                    this.mat[12] = t1.mat[12] * t2.mat[0] + t1.mat[13] * t2.mat[4] + t1.mat[14] * t2.mat[8] + t1.mat[15] * t2.mat[12];
                    this.mat[13] = t1.mat[12] * t2.mat[1] + t1.mat[13] * t2.mat[5] + t1.mat[14] * t2.mat[9] + t1.mat[15] * t2.mat[13];
                    this.mat[14] = t1.mat[12] * t2.mat[2] + t1.mat[13] * t2.mat[6] + t1.mat[14] * t2.mat[10] + t1.mat[15] * t2.mat[14];
                    this.mat[15] = t1.mat[12] * t2.mat[3] + t1.mat[13] * t2.mat[7] + t1.mat[14] * t2.mat[11] + t1.mat[15] * t2.mat[15];
                }
            }
        } else {
            double tmp11;
            double tmp10;
            double tmp9;
            double tmp8;
            double tmp7;
            double tmp6;
            double tmp5;
            double tmp4;
            double tmp3;
            double tmp2;
            double tmp1;
            double tmp0;
            if (t2.isAffine()) {
                tmp0 = t1.mat[0] * t2.mat[0] + t1.mat[1] * t2.mat[4] + t1.mat[2] * t2.mat[8];
                tmp1 = t1.mat[0] * t2.mat[1] + t1.mat[1] * t2.mat[5] + t1.mat[2] * t2.mat[9];
                tmp2 = t1.mat[0] * t2.mat[2] + t1.mat[1] * t2.mat[6] + t1.mat[2] * t2.mat[10];
                tmp3 = t1.mat[0] * t2.mat[3] + t1.mat[1] * t2.mat[7] + t1.mat[2] * t2.mat[11] + t1.mat[3];
                tmp4 = t1.mat[4] * t2.mat[0] + t1.mat[5] * t2.mat[4] + t1.mat[6] * t2.mat[8];
                tmp5 = t1.mat[4] * t2.mat[1] + t1.mat[5] * t2.mat[5] + t1.mat[6] * t2.mat[9];
                tmp6 = t1.mat[4] * t2.mat[2] + t1.mat[5] * t2.mat[6] + t1.mat[6] * t2.mat[10];
                tmp7 = t1.mat[4] * t2.mat[3] + t1.mat[5] * t2.mat[7] + t1.mat[6] * t2.mat[11] + t1.mat[7];
                tmp8 = t1.mat[8] * t2.mat[0] + t1.mat[9] * t2.mat[4] + t1.mat[10] * t2.mat[8];
                tmp9 = t1.mat[8] * t2.mat[1] + t1.mat[9] * t2.mat[5] + t1.mat[10] * t2.mat[9];
                tmp10 = t1.mat[8] * t2.mat[2] + t1.mat[9] * t2.mat[6] + t1.mat[10] * t2.mat[10];
                tmp11 = t1.mat[8] * t2.mat[3] + t1.mat[9] * t2.mat[7] + t1.mat[10] * t2.mat[11] + t1.mat[11];
                if (t1.isAffine()) {
                    aff = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    double tmp12 = t1.mat[12] * t2.mat[0] + t1.mat[13] * t2.mat[4] + t1.mat[14] * t2.mat[8];
                    double tmp13 = t1.mat[12] * t2.mat[1] + t1.mat[13] * t2.mat[5] + t1.mat[14] * t2.mat[9];
                    double tmp14 = t1.mat[12] * t2.mat[2] + t1.mat[13] * t2.mat[6] + t1.mat[14] * t2.mat[10];
                    double tmp15 = t1.mat[12] * t2.mat[3] + t1.mat[13] * t2.mat[7] + t1.mat[14] * t2.mat[11] + t1.mat[15];
                    this.mat[12] = tmp12;
                    this.mat[13] = tmp13;
                    this.mat[14] = tmp14;
                    this.mat[15] = tmp15;
                }
            } else {
                tmp0 = t1.mat[0] * t2.mat[0] + t1.mat[1] * t2.mat[4] + t1.mat[2] * t2.mat[8] + t1.mat[3] * t2.mat[12];
                tmp1 = t1.mat[0] * t2.mat[1] + t1.mat[1] * t2.mat[5] + t1.mat[2] * t2.mat[9] + t1.mat[3] * t2.mat[13];
                tmp2 = t1.mat[0] * t2.mat[2] + t1.mat[1] * t2.mat[6] + t1.mat[2] * t2.mat[10] + t1.mat[3] * t2.mat[14];
                tmp3 = t1.mat[0] * t2.mat[3] + t1.mat[1] * t2.mat[7] + t1.mat[2] * t2.mat[11] + t1.mat[3] * t2.mat[15];
                tmp4 = t1.mat[4] * t2.mat[0] + t1.mat[5] * t2.mat[4] + t1.mat[6] * t2.mat[8] + t1.mat[7] * t2.mat[12];
                tmp5 = t1.mat[4] * t2.mat[1] + t1.mat[5] * t2.mat[5] + t1.mat[6] * t2.mat[9] + t1.mat[7] * t2.mat[13];
                tmp6 = t1.mat[4] * t2.mat[2] + t1.mat[5] * t2.mat[6] + t1.mat[6] * t2.mat[10] + t1.mat[7] * t2.mat[14];
                tmp7 = t1.mat[4] * t2.mat[3] + t1.mat[5] * t2.mat[7] + t1.mat[6] * t2.mat[11] + t1.mat[7] * t2.mat[15];
                tmp8 = t1.mat[8] * t2.mat[0] + t1.mat[9] * t2.mat[4] + t1.mat[10] * t2.mat[8] + t1.mat[11] * t2.mat[12];
                tmp9 = t1.mat[8] * t2.mat[1] + t1.mat[9] * t2.mat[5] + t1.mat[10] * t2.mat[9] + t1.mat[11] * t2.mat[13];
                tmp10 = t1.mat[8] * t2.mat[2] + t1.mat[9] * t2.mat[6] + t1.mat[10] * t2.mat[10] + t1.mat[11] * t2.mat[14];
                tmp11 = t1.mat[8] * t2.mat[3] + t1.mat[9] * t2.mat[7] + t1.mat[10] * t2.mat[11] + t1.mat[11] * t2.mat[15];
                if (t1.isAffine()) {
                    this.mat[12] = t2.mat[12];
                    this.mat[13] = t2.mat[13];
                    this.mat[14] = t2.mat[14];
                    this.mat[15] = t2.mat[15];
                } else {
                    double tmp12 = t1.mat[12] * t2.mat[0] + t1.mat[13] * t2.mat[4] + t1.mat[14] * t2.mat[8] + t1.mat[15] * t2.mat[12];
                    double tmp13 = t1.mat[12] * t2.mat[1] + t1.mat[13] * t2.mat[5] + t1.mat[14] * t2.mat[9] + t1.mat[15] * t2.mat[13];
                    double tmp14 = t1.mat[12] * t2.mat[2] + t1.mat[13] * t2.mat[6] + t1.mat[14] * t2.mat[10] + t1.mat[15] * t2.mat[14];
                    double tmp15 = t1.mat[12] * t2.mat[3] + t1.mat[13] * t2.mat[7] + t1.mat[14] * t2.mat[11] + t1.mat[15] * t2.mat[15];
                    this.mat[12] = tmp12;
                    this.mat[13] = tmp13;
                    this.mat[14] = tmp14;
                    this.mat[15] = tmp15;
                }
            }
            this.mat[0] = tmp0;
            this.mat[1] = tmp1;
            this.mat[2] = tmp2;
            this.mat[3] = tmp3;
            this.mat[4] = tmp4;
            this.mat[5] = tmp5;
            this.mat[6] = tmp6;
            this.mat[7] = tmp7;
            this.mat[8] = tmp8;
            this.mat[9] = tmp9;
            this.mat[10] = tmp10;
            this.mat[11] = tmp11;
        }
        if ((t1.dirtyBits & 4) == 0 && (t1.type & 0x40) != 0 && (t2.dirtyBits & 4) == 0 && (t2.type & 0x40) != 0) {
            this.type = t1.type & t2.type;
            this.dirtyBits = t1.dirtyBits | t2.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = aff ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mulInverse(Transform3D t1) {
        Transform3D t2 = new Transform3D();
        t2.autoNormalize = false;
        t2.invert(t1);
        this.mul(t2);
    }

    public final void mulInverse(Transform3D t1, Transform3D t2) {
        Transform3D t3 = new Transform3D();
        t3.autoNormalize = false;
        t3.invert(t2);
        this.mul(t1, t3);
    }

    public final void mulTransposeRight(Transform3D t1, Transform3D t2) {
        Transform3D t3 = new Transform3D();
        t3.autoNormalize = false;
        t3.transpose(t2);
        this.mul(t1, t3);
    }

    public final void mulTransposeLeft(Transform3D t1, Transform3D t2) {
        Transform3D t3 = new Transform3D();
        t3.autoNormalize = false;
        t3.transpose(t1);
        this.mul(t3, t2);
    }

    public final void mulTransposeBoth(Transform3D t1, Transform3D t2) {
        Transform3D t3 = new Transform3D();
        Transform3D t4 = new Transform3D();
        t3.autoNormalize = false;
        t4.autoNormalize = false;
        t3.transpose(t1);
        t4.transpose(t2);
        this.mul(t3, t4);
    }

    public final void normalize() {
        if (!this.isAffine() && this.isInfOrNaN()) {
            return;
        }
        if ((this.dirtyBits & 0xC0) != 0) {
            this.computeScaleRotation(true);
        } else if ((this.dirtyBits & 0xA0) != 0) {
            this.computeScales(true);
        }
        this.mat[0] = this.rot[0] * this.scales[0];
        this.mat[1] = this.rot[1] * this.scales[1];
        this.mat[2] = this.rot[2] * this.scales[2];
        this.mat[4] = this.rot[3] * this.scales[0];
        this.mat[5] = this.rot[4] * this.scales[1];
        this.mat[6] = this.rot[5] * this.scales[2];
        this.mat[8] = this.rot[6] * this.scales[0];
        this.mat[9] = this.rot[7] * this.scales[1];
        this.mat[10] = this.rot[8] * this.scales[2];
        this.dirtyBits |= 0x10;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final void normalize(Transform3D t1) {
        this.set(t1);
        this.normalize();
    }

    public final void normalizeCP() {
        double mag;
        if (!this.isAffine() && this.isInfOrNaN()) {
            return;
        }
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if ((mag = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]) != 0.0) {
            mag = 1.0 / Math.sqrt(mag);
            this.mat[0] = this.mat[0] * mag;
            this.mat[4] = this.mat[4] * mag;
            this.mat[8] = this.mat[8] * mag;
        }
        if ((mag = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]) != 0.0) {
            mag = 1.0 / Math.sqrt(mag);
            this.mat[1] = this.mat[1] * mag;
            this.mat[5] = this.mat[5] * mag;
            this.mat[9] = this.mat[9] * mag;
        }
        this.mat[2] = (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]) * this.scales[0];
        this.mat[6] = (this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9]) * this.scales[1];
        this.mat[10] = (this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4]) * this.scales[2];
        this.mat[0] = this.mat[0] * this.scales[0];
        this.mat[1] = this.mat[1] * this.scales[0];
        this.mat[4] = this.mat[4] * this.scales[1];
        this.mat[5] = this.mat[5] * this.scales[1];
        this.mat[8] = this.mat[8] * this.scales[2];
        this.mat[9] = this.mat[9] * this.scales[2];
        this.dirtyBits |= 0xDC;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final void normalizeCP(Transform3D t1) {
        this.set(t1);
        this.normalizeCP();
    }

    public boolean equals(Transform3D t1) {
        return t1 != null && this.mat[0] == t1.mat[0] && this.mat[1] == t1.mat[1] && this.mat[2] == t1.mat[2] && this.mat[3] == t1.mat[3] && this.mat[4] == t1.mat[4] && this.mat[5] == t1.mat[5] && this.mat[6] == t1.mat[6] && this.mat[7] == t1.mat[7] && this.mat[8] == t1.mat[8] && this.mat[9] == t1.mat[9] && this.mat[10] == t1.mat[10] && this.mat[11] == t1.mat[11] && this.mat[12] == t1.mat[12] && this.mat[13] == t1.mat[13] && this.mat[14] == t1.mat[14] && this.mat[15] == t1.mat[15];
    }

    public boolean equals(Object o1) {
        return o1 instanceof Transform3D && this.equals((Transform3D)o1);
    }

    public boolean epsilonEquals(Transform3D t1, double epsilon) {
        for (int i = 0; i < 16; ++i) {
            double diff = this.mat[i] - t1.mat[i];
            double d = diff < 0.0 ? -diff : diff;
            if (!(d > epsilon)) continue;
            return false;
        }
        return true;
    }

    public final void transform(Vector4d vec, Vector4d vecOut) {
        if (vec != vecOut) {
            vecOut.x = this.mat[0] * vec.x + this.mat[1] * vec.y + this.mat[2] * vec.z + this.mat[3] * vec.w;
            vecOut.y = this.mat[4] * vec.x + this.mat[5] * vec.y + this.mat[6] * vec.z + this.mat[7] * vec.w;
            vecOut.z = this.mat[8] * vec.x + this.mat[9] * vec.y + this.mat[10] * vec.z + this.mat[11] * vec.w;
            vecOut.w = this.mat[12] * vec.x + this.mat[13] * vec.y + this.mat[14] * vec.z + this.mat[15] * vec.w;
        } else {
            this.transform(vec);
        }
    }

    public final void transform(Vector4d vec) {
        double x = this.mat[0] * vec.x + this.mat[1] * vec.y + this.mat[2] * vec.z + this.mat[3] * vec.w;
        double y = this.mat[4] * vec.x + this.mat[5] * vec.y + this.mat[6] * vec.z + this.mat[7] * vec.w;
        double z = this.mat[8] * vec.x + this.mat[9] * vec.y + this.mat[10] * vec.z + this.mat[11] * vec.w;
        vec.w = this.mat[12] * vec.x + this.mat[13] * vec.y + this.mat[14] * vec.z + this.mat[15] * vec.w;
        vec.x = x;
        vec.y = y;
        vec.z = z;
    }

    public final void transform(Vector4f vec, Vector4f vecOut) {
        if (vecOut != vec) {
            vecOut.x = (float)(this.mat[0] * (double)vec.x + this.mat[1] * (double)vec.y + this.mat[2] * (double)vec.z + this.mat[3] * (double)vec.w);
            vecOut.y = (float)(this.mat[4] * (double)vec.x + this.mat[5] * (double)vec.y + this.mat[6] * (double)vec.z + this.mat[7] * (double)vec.w);
            vecOut.z = (float)(this.mat[8] * (double)vec.x + this.mat[9] * (double)vec.y + this.mat[10] * (double)vec.z + this.mat[11] * (double)vec.w);
            vecOut.w = (float)(this.mat[12] * (double)vec.x + this.mat[13] * (double)vec.y + this.mat[14] * (double)vec.z + this.mat[15] * (double)vec.w);
        } else {
            this.transform(vec);
        }
    }

    public final void transform(Vector4f vec) {
        float x = (float)(this.mat[0] * (double)vec.x + this.mat[1] * (double)vec.y + this.mat[2] * (double)vec.z + this.mat[3] * (double)vec.w);
        float y = (float)(this.mat[4] * (double)vec.x + this.mat[5] * (double)vec.y + this.mat[6] * (double)vec.z + this.mat[7] * (double)vec.w);
        float z = (float)(this.mat[8] * (double)vec.x + this.mat[9] * (double)vec.y + this.mat[10] * (double)vec.z + this.mat[11] * (double)vec.w);
        vec.w = (float)(this.mat[12] * (double)vec.x + this.mat[13] * (double)vec.y + this.mat[14] * (double)vec.z + this.mat[15] * (double)vec.w);
        vec.x = x;
        vec.y = y;
        vec.z = z;
    }

    public final void transform(Point3d point, Point3d pointOut) {
        if (point != pointOut) {
            pointOut.x = this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3];
            pointOut.y = this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7];
            pointOut.z = this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11];
        } else {
            this.transform(point);
        }
    }

    public final void transform(Point3d point) {
        double x = this.mat[0] * point.x + this.mat[1] * point.y + this.mat[2] * point.z + this.mat[3];
        double y = this.mat[4] * point.x + this.mat[5] * point.y + this.mat[6] * point.z + this.mat[7];
        point.z = this.mat[8] * point.x + this.mat[9] * point.y + this.mat[10] * point.z + this.mat[11];
        point.x = x;
        point.y = y;
    }

    public final void transform(Vector3d normal, Vector3d normalOut) {
        if (normalOut != normal) {
            normalOut.x = this.mat[0] * normal.x + this.mat[1] * normal.y + this.mat[2] * normal.z;
            normalOut.y = this.mat[4] * normal.x + this.mat[5] * normal.y + this.mat[6] * normal.z;
            normalOut.z = this.mat[8] * normal.x + this.mat[9] * normal.y + this.mat[10] * normal.z;
        } else {
            this.transform(normal);
        }
    }

    public final void transform(Vector3d normal) {
        double x = this.mat[0] * normal.x + this.mat[1] * normal.y + this.mat[2] * normal.z;
        double y = this.mat[4] * normal.x + this.mat[5] * normal.y + this.mat[6] * normal.z;
        normal.z = this.mat[8] * normal.x + this.mat[9] * normal.y + this.mat[10] * normal.z;
        normal.x = x;
        normal.y = y;
    }

    public final void transform(Point3f point, Point3f pointOut) {
        if (point != pointOut) {
            pointOut.x = (float)(this.mat[0] * (double)point.x + this.mat[1] * (double)point.y + this.mat[2] * (double)point.z + this.mat[3]);
            pointOut.y = (float)(this.mat[4] * (double)point.x + this.mat[5] * (double)point.y + this.mat[6] * (double)point.z + this.mat[7]);
            pointOut.z = (float)(this.mat[8] * (double)point.x + this.mat[9] * (double)point.y + this.mat[10] * (double)point.z + this.mat[11]);
        } else {
            this.transform(point);
        }
    }

    public final void transform(Point3f point) {
        float x = (float)(this.mat[0] * (double)point.x + this.mat[1] * (double)point.y + this.mat[2] * (double)point.z + this.mat[3]);
        float y = (float)(this.mat[4] * (double)point.x + this.mat[5] * (double)point.y + this.mat[6] * (double)point.z + this.mat[7]);
        point.z = (float)(this.mat[8] * (double)point.x + this.mat[9] * (double)point.y + this.mat[10] * (double)point.z + this.mat[11]);
        point.x = x;
        point.y = y;
    }

    public final void transform(Vector3f normal, Vector3f normalOut) {
        if (normal != normalOut) {
            normalOut.x = (float)(this.mat[0] * (double)normal.x + this.mat[1] * (double)normal.y + this.mat[2] * (double)normal.z);
            normalOut.y = (float)(this.mat[4] * (double)normal.x + this.mat[5] * (double)normal.y + this.mat[6] * (double)normal.z);
            normalOut.z = (float)(this.mat[8] * (double)normal.x + this.mat[9] * (double)normal.y + this.mat[10] * (double)normal.z);
        } else {
            this.transform(normal);
        }
    }

    public final void transform(Vector3f normal) {
        float x = (float)(this.mat[0] * (double)normal.x + this.mat[1] * (double)normal.y + this.mat[2] * (double)normal.z);
        float y = (float)(this.mat[4] * (double)normal.x + this.mat[5] * (double)normal.y + this.mat[6] * (double)normal.z);
        normal.z = (float)(this.mat[8] * (double)normal.x + this.mat[9] * (double)normal.y + this.mat[10] * (double)normal.z);
        normal.x = x;
        normal.y = y;
    }

    public final void setRotationScale(Matrix3f m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotationScale(Matrix3d m1) {
        this.mat[0] = m1.m00;
        this.mat[1] = m1.m01;
        this.mat[2] = m1.m02;
        this.mat[4] = m1.m10;
        this.mat[5] = m1.m11;
        this.mat[6] = m1.m12;
        this.mat[8] = m1.m20;
        this.mat[9] = m1.m21;
        this.mat[10] = m1.m22;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double s, Transform3D t1, Transform3D t2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = s * t1.mat[i] + t2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double s, Transform3D t1) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = s * this.mat[i] + t1.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void getRotationScale(Matrix3f m1) {
        m1.m00 = (float)this.mat[0];
        m1.m01 = (float)this.mat[1];
        m1.m02 = (float)this.mat[2];
        m1.m10 = (float)this.mat[4];
        m1.m11 = (float)this.mat[5];
        m1.m12 = (float)this.mat[6];
        m1.m20 = (float)this.mat[8];
        m1.m21 = (float)this.mat[9];
        m1.m22 = (float)this.mat[10];
    }

    public final void getRotationScale(Matrix3d m1) {
        m1.m00 = this.mat[0];
        m1.m01 = this.mat[1];
        m1.m02 = this.mat[2];
        m1.m10 = this.mat[4];
        m1.m11 = this.mat[5];
        m1.m12 = this.mat[6];
        m1.m20 = this.mat[8];
        m1.m21 = this.mat[9];
        m1.m22 = this.mat[10];
    }

    public void lookAt(Point3d eye, Point3d center, Vector3d up) {
        double forwardx = eye.x - center.x;
        double forwardy = eye.y - center.y;
        double forwardz = eye.z - center.z;
        double invMag = 1.0 / Math.sqrt(forwardx * forwardx + forwardy * forwardy + forwardz * forwardz);
        forwardx *= invMag;
        forwardy *= invMag;
        forwardz *= invMag;
        invMag = 1.0 / Math.sqrt(up.x * up.x + up.y * up.y + up.z * up.z);
        double upx = up.x * invMag;
        double upy = up.y * invMag;
        double upz = up.z * invMag;
        double sidex = upy * forwardz - forwardy * upz;
        double sidey = upz * forwardx - upx * forwardz;
        double sidez = upx * forwardy - upy * forwardx;
        invMag = 1.0 / Math.sqrt(sidex * sidex + sidey * sidey + sidez * sidez);
        upx = forwardy * (sidez *= invMag) - (sidey *= invMag) * forwardz;
        upy = forwardz * (sidex *= invMag) - forwardx * sidez;
        upz = forwardx * sidey - forwardy * sidex;
        this.mat[0] = sidex;
        this.mat[1] = sidey;
        this.mat[2] = sidez;
        this.mat[4] = upx;
        this.mat[5] = upy;
        this.mat[6] = upz;
        this.mat[8] = forwardx;
        this.mat[9] = forwardy;
        this.mat[10] = forwardz;
        this.mat[3] = -eye.x * this.mat[0] + -eye.y * this.mat[1] + -eye.z * this.mat[2];
        this.mat[7] = -eye.x * this.mat[4] + -eye.y * this.mat[5] + -eye.z * this.mat[6];
        this.mat[11] = -eye.x * this.mat[8] + -eye.y * this.mat[9] + -eye.z * this.mat[10];
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    public void frustum(double left, double right, double bottom, double top, double near, double far) {
        double dx = 1.0 / (right - left);
        double dy = 1.0 / (top - bottom);
        double dz = 1.0 / (far - near);
        this.mat[0] = 2.0 * near * dx;
        this.mat[5] = 2.0 * near * dy;
        this.mat[10] = (far + near) * dz;
        this.mat[2] = (right + left) * dx;
        this.mat[6] = (top + bottom) * dy;
        this.mat[11] = 2.0 * far * near * dz;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void perspective(double fovx, double aspect, double zNear, double zFar) {
        double cotangent;
        double half_fov = fovx * 0.5;
        double deltaZ = zFar - zNear;
        double sine = Math.sin(half_fov);
        this.mat[0] = cotangent = Math.cos(half_fov) / sine;
        this.mat[5] = cotangent * aspect;
        this.mat[10] = (zFar + zNear) / deltaZ;
        this.mat[11] = 2.0 * zNear * zFar / deltaZ;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 255;
    }

    public void ortho(double left, double right, double bottom, double top, double near, double far) {
        double deltax = 1.0 / (right - left);
        double deltay = 1.0 / (top - bottom);
        double deltaz = 1.0 / (far - near);
        this.mat[0] = 2.0 * deltax;
        this.mat[3] = -(right + left) * deltax;
        this.mat[5] = 2.0 * deltay;
        this.mat[7] = -(top + bottom) * deltay;
        this.mat[10] = 2.0 * deltaz;
        this.mat[11] = (far + near) * deltaz;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 255;
    }

    double getDistanceScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            double max = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
            if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0) {
                return Math.sqrt(max);
            }
            double tmp = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
            if (tmp > max) {
                max = tmp;
            }
            return Math.sqrt((tmp = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]) > max ? tmp : max);
        }
        return Transform3D.max3(this.scales);
    }

    private static void mat_mul(double[] m1, double[] m2, double[] m3) {
        double[] result = m3;
        if (m1 == m3 || m2 == m3) {
            result = new double[]{m1[0] * m2[0] + m1[1] * m2[3] + m1[2] * m2[6], m1[0] * m2[1] + m1[1] * m2[4] + m1[2] * m2[7], m1[0] * m2[2] + m1[1] * m2[5] + m1[2] * m2[8], m1[3] * m2[0] + m1[4] * m2[3] + m1[5] * m2[6], m1[3] * m2[1] + m1[4] * m2[4] + m1[5] * m2[7], m1[3] * m2[2] + m1[4] * m2[5] + m1[5] * m2[8], m1[6] * m2[0] + m1[7] * m2[3] + m1[8] * m2[6], m1[6] * m2[1] + m1[7] * m2[4] + m1[8] * m2[7], m1[6] * m2[2] + m1[7] * m2[5] + m1[8] * m2[8]};
        }
        if (result != m3) {
            for (int i = 0; i < 9; ++i) {
                m3[i] = result[i];
            }
        }
    }

    private static void transpose_mat(double[] in, double[] out) {
        out[0] = in[0];
        out[1] = in[3];
        out[2] = in[6];
        out[3] = in[1];
        out[4] = in[4];
        out[5] = in[7];
        out[6] = in[2];
        out[7] = in[5];
        out[8] = in[8];
    }

    private void compute_svd(Transform3D matrix, double[] outScale, double[] outRot) {
        double g;
        double[] m = new double[9];
        double[] u1 = new double[9];
        double[] v1 = new double[9];
        double[] t1 = new double[9];
        double[] t2 = new double[9];
        double[] svdRot = new double[9];
        double[] e = new double[3];
        double[] svdScales = new double[3];
        int negCnt = 0;
        svdRot[0] = m[0] = matrix.mat[0];
        svdRot[1] = m[1] = matrix.mat[1];
        svdRot[2] = m[2] = matrix.mat[2];
        svdRot[3] = m[3] = matrix.mat[4];
        svdRot[4] = m[4] = matrix.mat[5];
        svdRot[5] = m[5] = matrix.mat[6];
        svdRot[6] = m[6] = matrix.mat[8];
        svdRot[7] = m[7] = matrix.mat[9];
        svdRot[8] = m[8] = matrix.mat[10];
        if (m[3] * m[3] < 1.110223024E-16) {
            u1[0] = 1.0;
            u1[1] = 0.0;
            u1[2] = 0.0;
            u1[3] = 0.0;
            u1[4] = 1.0;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        } else if (m[0] * m[0] < 1.110223024E-16) {
            t1[0] = m[0];
            t1[1] = m[1];
            t1[2] = m[2];
            m[0] = m[3];
            m[1] = m[4];
            m[2] = m[5];
            m[3] = -t1[0];
            m[4] = -t1[1];
            m[5] = -t1[2];
            u1[0] = 0.0;
            u1[1] = 1.0;
            u1[2] = 0.0;
            u1[3] = -1.0;
            u1[4] = 0.0;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        } else {
            g = 1.0 / Math.sqrt(m[0] * m[0] + m[3] * m[3]);
            double c1 = m[0] * g;
            double s1 = m[3] * g;
            t1[0] = c1 * m[0] + s1 * m[3];
            t1[1] = c1 * m[1] + s1 * m[4];
            t1[2] = c1 * m[2] + s1 * m[5];
            m[3] = -s1 * m[0] + c1 * m[3];
            m[4] = -s1 * m[1] + c1 * m[4];
            m[5] = -s1 * m[2] + c1 * m[5];
            m[0] = t1[0];
            m[1] = t1[1];
            m[2] = t1[2];
            u1[0] = c1;
            u1[1] = s1;
            u1[2] = 0.0;
            u1[3] = -s1;
            u1[4] = c1;
            u1[5] = 0.0;
            u1[6] = 0.0;
            u1[7] = 0.0;
            u1[8] = 1.0;
        }
        if (!(m[6] * m[6] < 1.110223024E-16)) {
            if (m[0] * m[0] < 1.110223024E-16) {
                t1[0] = m[0];
                t1[1] = m[1];
                t1[2] = m[2];
                m[0] = m[6];
                m[1] = m[7];
                m[2] = m[8];
                m[6] = -t1[0];
                m[7] = -t1[1];
                m[8] = -t1[2];
                t1[0] = u1[0];
                t1[1] = u1[1];
                t1[2] = u1[2];
                u1[0] = u1[6];
                u1[1] = u1[7];
                u1[2] = u1[8];
                u1[6] = -t1[0];
                u1[7] = -t1[1];
                u1[8] = -t1[2];
            } else {
                g = 1.0 / Math.sqrt(m[0] * m[0] + m[6] * m[6]);
                double c2 = m[0] * g;
                double s2 = m[6] * g;
                t1[0] = c2 * m[0] + s2 * m[6];
                t1[1] = c2 * m[1] + s2 * m[7];
                t1[2] = c2 * m[2] + s2 * m[8];
                m[6] = -s2 * m[0] + c2 * m[6];
                m[7] = -s2 * m[1] + c2 * m[7];
                m[8] = -s2 * m[2] + c2 * m[8];
                m[0] = t1[0];
                m[1] = t1[1];
                m[2] = t1[2];
                t1[0] = c2 * u1[0];
                t1[1] = c2 * u1[1];
                u1[2] = s2;
                t1[6] = -u1[0] * s2;
                t1[7] = -u1[1] * s2;
                u1[8] = c2;
                u1[0] = t1[0];
                u1[1] = t1[1];
                u1[6] = t1[6];
                u1[7] = t1[7];
            }
        }
        if (m[2] * m[2] < 1.110223024E-16) {
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = 1.0;
            v1[5] = 0.0;
            v1[6] = 0.0;
            v1[7] = 0.0;
            v1[8] = 1.0;
        } else if (m[1] * m[1] < 1.110223024E-16) {
            t1[2] = m[2];
            t1[5] = m[5];
            t1[8] = m[8];
            m[2] = -m[1];
            m[5] = -m[4];
            m[8] = -m[7];
            m[1] = t1[2];
            m[4] = t1[5];
            m[7] = t1[8];
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = 0.0;
            v1[5] = -1.0;
            v1[6] = 0.0;
            v1[7] = 1.0;
            v1[8] = 0.0;
        } else {
            g = 1.0 / Math.sqrt(m[1] * m[1] + m[2] * m[2]);
            double c3 = m[1] * g;
            double s3 = m[2] * g;
            t1[1] = c3 * m[1] + s3 * m[2];
            m[2] = -s3 * m[1] + c3 * m[2];
            m[1] = t1[1];
            t1[4] = c3 * m[4] + s3 * m[5];
            m[5] = -s3 * m[4] + c3 * m[5];
            m[4] = t1[4];
            t1[7] = c3 * m[7] + s3 * m[8];
            m[8] = -s3 * m[7] + c3 * m[8];
            m[7] = t1[7];
            v1[0] = 1.0;
            v1[1] = 0.0;
            v1[2] = 0.0;
            v1[3] = 0.0;
            v1[4] = c3;
            v1[5] = -s3;
            v1[6] = 0.0;
            v1[7] = s3;
            v1[8] = c3;
        }
        if (!(m[7] * m[7] < 1.110223024E-16)) {
            if (m[4] * m[4] < 1.110223024E-16) {
                t1[3] = m[3];
                t1[4] = m[4];
                t1[5] = m[5];
                m[3] = m[6];
                m[4] = m[7];
                m[5] = m[8];
                m[6] = -t1[3];
                m[7] = -t1[4];
                m[8] = -t1[5];
                t1[3] = u1[3];
                t1[4] = u1[4];
                t1[5] = u1[5];
                u1[3] = u1[6];
                u1[4] = u1[7];
                u1[5] = u1[8];
                u1[6] = -t1[3];
                u1[7] = -t1[4];
                u1[8] = -t1[5];
            } else {
                g = 1.0 / Math.sqrt(m[4] * m[4] + m[7] * m[7]);
                double c4 = m[4] * g;
                double s4 = m[7] * g;
                t1[3] = c4 * m[3] + s4 * m[6];
                m[6] = -s4 * m[3] + c4 * m[6];
                m[3] = t1[3];
                t1[4] = c4 * m[4] + s4 * m[7];
                m[7] = -s4 * m[4] + c4 * m[7];
                m[4] = t1[4];
                t1[5] = c4 * m[5] + s4 * m[8];
                m[8] = -s4 * m[5] + c4 * m[8];
                m[5] = t1[5];
                t1[3] = c4 * u1[3] + s4 * u1[6];
                u1[6] = -s4 * u1[3] + c4 * u1[6];
                u1[3] = t1[3];
                t1[4] = c4 * u1[4] + s4 * u1[7];
                u1[7] = -s4 * u1[4] + c4 * u1[7];
                u1[4] = t1[4];
                t1[5] = c4 * u1[5] + s4 * u1[8];
                u1[8] = -s4 * u1[5] + c4 * u1[8];
                u1[5] = t1[5];
            }
        }
        t2[0] = m[0];
        t2[1] = m[4];
        t2[2] = m[8];
        e[0] = m[1];
        e[1] = m[5];
        if (e[0] * e[0] > 1.110223024E-16 || e[1] * e[1] > 1.110223024E-16) {
            this.compute_qr(t2, e, u1, v1);
        }
        svdScales[0] = t2[0];
        svdScales[1] = t2[1];
        svdScales[2] = t2[2];
        if (Transform3D.almostOne(Math.abs(svdScales[0])) && Transform3D.almostOne(Math.abs(svdScales[1])) && Transform3D.almostOne(Math.abs(svdScales[2]))) {
            int i;
            for (i = 0; i < 3; ++i) {
                if (!(svdScales[i] < 0.0)) continue;
                ++negCnt;
            }
            if (negCnt == 0 || negCnt == 2) {
                outScale[2] = 1.0;
                outScale[1] = 1.0;
                outScale[0] = 1.0;
                for (i = 0; i < 9; ++i) {
                    outRot[i] = svdRot[i];
                }
                return;
            }
        }
        Transform3D.transpose_mat(u1, t1);
        Transform3D.transpose_mat(v1, t2);
        this.svdReorder(m, t1, t2, svdRot, svdScales, outRot, outScale);
    }

    private void svdReorder(double[] m, double[] t1, double[] t2, double[] rot, double[] scales, double[] outRot, double[] outScale) {
        int[] svdOut = new int[3];
        double[] svdMag = new double[3];
        if (scales[0] < 0.0) {
            scales[0] = -scales[0];
            t2[0] = -t2[0];
            t2[1] = -t2[1];
            t2[2] = -t2[2];
        }
        if (scales[1] < 0.0) {
            scales[1] = -scales[1];
            t2[3] = -t2[3];
            t2[4] = -t2[4];
            t2[5] = -t2[5];
        }
        if (scales[2] < 0.0) {
            scales[2] = -scales[2];
            t2[6] = -t2[6];
            t2[7] = -t2[7];
            t2[8] = -t2[8];
        }
        Transform3D.mat_mul(t1, t2, rot);
        if (Transform3D.almostEqual(Math.abs(scales[0]), Math.abs(scales[1])) && Transform3D.almostEqual(Math.abs(scales[1]), Math.abs(scales[2]))) {
            int i;
            for (i = 0; i < 9; ++i) {
                outRot[i] = rot[i];
            }
            for (i = 0; i < 3; ++i) {
                outScale[i] = scales[i];
            }
        } else {
            int in1;
            int in2;
            int in0;
            if (scales[0] > scales[1]) {
                if (scales[0] > scales[2]) {
                    if (scales[2] > scales[1]) {
                        svdOut[0] = 0;
                        svdOut[1] = 2;
                        svdOut[2] = 1;
                    } else {
                        svdOut[0] = 0;
                        svdOut[1] = 1;
                        svdOut[2] = 2;
                    }
                } else {
                    svdOut[0] = 2;
                    svdOut[1] = 0;
                    svdOut[2] = 1;
                }
            } else if (scales[1] > scales[2]) {
                if (scales[2] > scales[0]) {
                    svdOut[0] = 1;
                    svdOut[1] = 2;
                    svdOut[2] = 0;
                } else {
                    svdOut[0] = 1;
                    svdOut[1] = 0;
                    svdOut[2] = 2;
                }
            } else {
                svdOut[0] = 2;
                svdOut[1] = 1;
                svdOut[2] = 0;
            }
            svdMag[0] = m[0] * m[0] + m[1] * m[1] + m[2] * m[2];
            svdMag[1] = m[3] * m[3] + m[4] * m[4] + m[5] * m[5];
            svdMag[2] = m[6] * m[6] + m[7] * m[7] + m[8] * m[8];
            if (svdMag[0] > svdMag[1]) {
                if (svdMag[0] > svdMag[2]) {
                    if (svdMag[2] > svdMag[1]) {
                        in0 = 0;
                        in2 = 1;
                        in1 = 2;
                    } else {
                        in0 = 0;
                        in1 = 1;
                        in2 = 2;
                    }
                } else {
                    in2 = 0;
                    in0 = 1;
                    in1 = 2;
                }
            } else if (svdMag[1] > svdMag[2]) {
                if (svdMag[2] > svdMag[0]) {
                    in1 = 0;
                    in2 = 1;
                    in0 = 2;
                } else {
                    in1 = 0;
                    in0 = 1;
                    in2 = 2;
                }
            } else {
                in2 = 0;
                in1 = 1;
                in0 = 2;
            }
            int index = svdOut[in0];
            outScale[0] = scales[index];
            index = svdOut[in1];
            outScale[1] = scales[index];
            index = svdOut[in2];
            outScale[2] = scales[index];
            index = svdOut[in0];
            outRot[0] = rot[index];
            index = svdOut[in0] + 3;
            outRot[3] = rot[index];
            index = svdOut[in0] + 6;
            outRot[6] = rot[index];
            index = svdOut[in1];
            outRot[1] = rot[index];
            index = svdOut[in1] + 3;
            outRot[4] = rot[index];
            index = svdOut[in1] + 6;
            outRot[7] = rot[index];
            index = svdOut[in2];
            outRot[2] = rot[index];
            index = svdOut[in2] + 3;
            outRot[5] = rot[index];
            index = svdOut[in2] + 6;
            outRot[8] = rot[index];
        }
    }

    private int compute_qr(double[] s, double[] e, double[] u, double[] v) {
        double vtemp;
        double utemp;
        int MAX_INTERATIONS = 10;
        double CONVERGE_TOL = 4.89E-15;
        double[] cosl = new double[2];
        double[] cosr = new double[2];
        double[] sinl = new double[2];
        double[] sinr = new double[2];
        double[] qr_m = new double[9];
        double c_b48 = 1.0;
        boolean converged = false;
        int first = 1;
        if (Math.abs(e[1]) < 4.89E-15 || Math.abs(e[0]) < 4.89E-15) {
            converged = true;
        }
        for (int k = 0; k < 10 && !converged; ++k) {
            double shift = Transform3D.compute_shift(s[1], e[1], s[2]);
            double f = (Math.abs(s[0]) - shift) * (Transform3D.d_sign(c_b48, s[0]) + shift / s[0]);
            double g = e[0];
            double r = Transform3D.compute_rot(f, g, sinr, cosr, 0, first);
            f = cosr[0] * s[0] + sinr[0] * e[0];
            e[0] = cosr[0] * e[0] - sinr[0] * s[0];
            g = sinr[0] * s[1];
            s[1] = cosr[0] * s[1];
            r = Transform3D.compute_rot(f, g, sinl, cosl, 0, first);
            first = 0;
            s[0] = r;
            f = cosl[0] * e[0] + sinl[0] * s[1];
            s[1] = cosl[0] * s[1] - sinl[0] * e[0];
            g = sinl[0] * e[1];
            e[1] = cosl[0] * e[1];
            e[0] = r = Transform3D.compute_rot(f, g, sinr, cosr, 1, first);
            f = cosr[1] * s[1] + sinr[1] * e[1];
            e[1] = cosr[1] * e[1] - sinr[1] * s[1];
            g = sinr[1] * s[2];
            s[2] = cosr[1] * s[2];
            s[1] = r = Transform3D.compute_rot(f, g, sinl, cosl, 1, first);
            f = cosl[1] * e[1] + sinl[1] * s[2];
            s[2] = cosl[1] * s[2] - sinl[1] * e[1];
            e[1] = f;
            utemp = u[0];
            u[0] = cosl[0] * utemp + sinl[0] * u[3];
            u[3] = -sinl[0] * utemp + cosl[0] * u[3];
            utemp = u[1];
            u[1] = cosl[0] * utemp + sinl[0] * u[4];
            u[4] = -sinl[0] * utemp + cosl[0] * u[4];
            utemp = u[2];
            u[2] = cosl[0] * utemp + sinl[0] * u[5];
            u[5] = -sinl[0] * utemp + cosl[0] * u[5];
            utemp = u[3];
            u[3] = cosl[1] * utemp + sinl[1] * u[6];
            u[6] = -sinl[1] * utemp + cosl[1] * u[6];
            utemp = u[4];
            u[4] = cosl[1] * utemp + sinl[1] * u[7];
            u[7] = -sinl[1] * utemp + cosl[1] * u[7];
            utemp = u[5];
            u[5] = cosl[1] * utemp + sinl[1] * u[8];
            u[8] = -sinl[1] * utemp + cosl[1] * u[8];
            vtemp = v[0];
            v[0] = cosr[0] * vtemp + sinr[0] * v[1];
            v[1] = -sinr[0] * vtemp + cosr[0] * v[1];
            vtemp = v[3];
            v[3] = cosr[0] * vtemp + sinr[0] * v[4];
            v[4] = -sinr[0] * vtemp + cosr[0] * v[4];
            vtemp = v[6];
            v[6] = cosr[0] * vtemp + sinr[0] * v[7];
            v[7] = -sinr[0] * vtemp + cosr[0] * v[7];
            vtemp = v[1];
            v[1] = cosr[1] * vtemp + sinr[1] * v[2];
            v[2] = -sinr[1] * vtemp + cosr[1] * v[2];
            vtemp = v[4];
            v[4] = cosr[1] * vtemp + sinr[1] * v[5];
            v[5] = -sinr[1] * vtemp + cosr[1] * v[5];
            vtemp = v[7];
            v[7] = cosr[1] * vtemp + sinr[1] * v[8];
            v[8] = -sinr[1] * vtemp + cosr[1] * v[8];
            qr_m[0] = s[0];
            qr_m[1] = e[0];
            qr_m[2] = 0.0;
            qr_m[3] = 0.0;
            qr_m[4] = s[1];
            qr_m[5] = e[1];
            qr_m[6] = 0.0;
            qr_m[7] = 0.0;
            qr_m[8] = s[2];
            if (!(Math.abs(e[1]) < 4.89E-15) && !(Math.abs(e[0]) < 4.89E-15)) continue;
            converged = true;
        }
        if (Math.abs(e[1]) < 4.89E-15) {
            Transform3D.compute_2X2(s[0], e[0], s[1], s, sinl, cosl, sinr, cosr, 0);
            utemp = u[0];
            u[0] = cosl[0] * utemp + sinl[0] * u[3];
            u[3] = -sinl[0] * utemp + cosl[0] * u[3];
            utemp = u[1];
            u[1] = cosl[0] * utemp + sinl[0] * u[4];
            u[4] = -sinl[0] * utemp + cosl[0] * u[4];
            utemp = u[2];
            u[2] = cosl[0] * utemp + sinl[0] * u[5];
            u[5] = -sinl[0] * utemp + cosl[0] * u[5];
            vtemp = v[0];
            v[0] = cosr[0] * vtemp + sinr[0] * v[1];
            v[1] = -sinr[0] * vtemp + cosr[0] * v[1];
            vtemp = v[3];
            v[3] = cosr[0] * vtemp + sinr[0] * v[4];
            v[4] = -sinr[0] * vtemp + cosr[0] * v[4];
            vtemp = v[6];
            v[6] = cosr[0] * vtemp + sinr[0] * v[7];
            v[7] = -sinr[0] * vtemp + cosr[0] * v[7];
        } else {
            Transform3D.compute_2X2(s[1], e[1], s[2], s, sinl, cosl, sinr, cosr, 1);
            utemp = u[3];
            u[3] = cosl[0] * utemp + sinl[0] * u[6];
            u[6] = -sinl[0] * utemp + cosl[0] * u[6];
            utemp = u[4];
            u[4] = cosl[0] * utemp + sinl[0] * u[7];
            u[7] = -sinl[0] * utemp + cosl[0] * u[7];
            utemp = u[5];
            u[5] = cosl[0] * utemp + sinl[0] * u[8];
            u[8] = -sinl[0] * utemp + cosl[0] * u[8];
            vtemp = v[1];
            v[1] = cosr[0] * vtemp + sinr[0] * v[2];
            v[2] = -sinr[0] * vtemp + cosr[0] * v[2];
            vtemp = v[4];
            v[4] = cosr[0] * vtemp + sinr[0] * v[5];
            v[5] = -sinr[0] * vtemp + cosr[0] * v[5];
            vtemp = v[7];
            v[7] = cosr[0] * vtemp + sinr[0] * v[8];
            v[8] = -sinr[0] * vtemp + cosr[0] * v[8];
        }
        return 0;
    }

    static final double max(double a, double b) {
        return a > b ? a : b;
    }

    static final double min(double a, double b) {
        return a < b ? a : b;
    }

    static final double d_sign(double a, double b) {
        double x = a >= 0.0 ? a : -a;
        return b >= 0.0 ? x : -x;
    }

    static final double compute_shift(double f, double g, double h) {
        double ssmin;
        double fa = Math.abs(f);
        double ga = Math.abs(g);
        double ha = Math.abs(h);
        double fhmn = Transform3D.min(fa, ha);
        double fhmx = Transform3D.max(fa, ha);
        if (fhmn == 0.0) {
            ssmin = 0.0;
            if (fhmx != 0.0) {
                double d__1 = Transform3D.min(fhmx, ga) / Transform3D.max(fhmx, ga);
            }
        } else if (ga < fhmx) {
            double as = fhmn / fhmx + 1.0;
            double at = (fhmx - fhmn) / fhmx;
            double d__1 = ga / fhmx;
            double au = d__1 * d__1;
            double c = 2.0 / (Math.sqrt(as * as + au) + Math.sqrt(at * at + au));
            ssmin = fhmn * c;
        } else {
            double au = fhmx / ga;
            if (au == 0.0) {
                ssmin = fhmn * fhmx / ga;
            } else {
                double as = fhmn / fhmx + 1.0;
                double at = (fhmx - fhmn) / fhmx;
                double d__1 = as * au;
                double d__2 = at * au;
                double c = 1.0 / (Math.sqrt(d__1 * d__1 + 1.0) + Math.sqrt(d__2 * d__2 + 1.0));
                ssmin = fhmn * c * au;
                ssmin += ssmin;
            }
        }
        return ssmin;
    }

    static int compute_2X2(double f, double g, double h, double[] single_values, double[] snl, double[] csl, double[] snr, double[] csr, int index) {
        double gt;
        double ga;
        double c_b3 = 2.0;
        double c_b4 = 1.0;
        double ssmax = single_values[0];
        double ssmin = single_values[1];
        double clt = 0.0;
        double crt = 0.0;
        double slt = 0.0;
        double srt = 0.0;
        double tsign = 0.0;
        double ft = f;
        double fa = Math.abs(ft);
        double ht = h;
        double ha = Math.abs(h);
        int pmax = 1;
        boolean swap = ha > fa;
        if (swap) {
            pmax = 3;
            double temp = ft;
            ft = ht;
            ht = temp;
            temp = fa;
            fa = ha;
            ha = temp;
        }
        if ((ga = Math.abs(gt = g)) == 0.0) {
            single_values[1] = ha;
            single_values[0] = fa;
            clt = 1.0;
            crt = 1.0;
            slt = 0.0;
            srt = 0.0;
        } else {
            boolean gasmal = true;
            if (ga > fa) {
                pmax = 2;
                if (fa / ga < 1.110223024E-16) {
                    gasmal = false;
                    ssmax = ga;
                    ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                    clt = 1.0;
                    slt = ht / gt;
                    srt = 1.0;
                    crt = ft / gt;
                }
            }
            if (gasmal) {
                double d = fa - ha;
                double l = d == fa ? 1.0 : d / fa;
                double m = gt / ft;
                double t = 2.0 - l;
                double mm = m * m;
                double tt = t * t;
                double s = Math.sqrt(tt + mm);
                double r = l == 0.0 ? Math.abs(m) : Math.sqrt(l * l + mm);
                double a = (s + r) * 0.5;
                if (ga > fa) {
                    pmax = 2;
                    if (fa / ga < 1.110223024E-16) {
                        gasmal = false;
                        ssmax = ga;
                        ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                        clt = 1.0;
                        slt = ht / gt;
                        srt = 1.0;
                        crt = ft / gt;
                    }
                }
                if (gasmal) {
                    d = fa - ha;
                    l = d == fa ? 1.0 : d / fa;
                    m = gt / ft;
                    t = 2.0 - l;
                    mm = m * m;
                    tt = t * t;
                    s = Math.sqrt(tt + mm);
                    r = l == 0.0 ? Math.abs(m) : Math.sqrt(l * l + mm);
                    a = (s + r) * 0.5;
                    ssmin = ha / a;
                    ssmax = fa * a;
                    t = mm == 0.0 ? (l == 0.0 ? Transform3D.d_sign(c_b3, ft) * Transform3D.d_sign(c_b4, gt) : gt / Transform3D.d_sign(d, ft) + m / t) : (m / (s + t) + m / (r + l)) * (a + 1.0);
                    l = Math.sqrt(t * t + 4.0);
                    crt = 2.0 / l;
                    srt = t / l;
                    clt = (crt + srt * m) / a;
                    slt = ht / ft * srt / a;
                }
            }
            if (swap) {
                csl[0] = srt;
                snl[0] = crt;
                csr[0] = slt;
                snr[0] = clt;
            } else {
                csl[0] = clt;
                snl[0] = slt;
                csr[0] = crt;
                snr[0] = srt;
            }
            if (pmax == 1) {
                tsign = Transform3D.d_sign(c_b4, csr[0]) * Transform3D.d_sign(c_b4, csl[0]) * Transform3D.d_sign(c_b4, f);
            }
            if (pmax == 2) {
                tsign = Transform3D.d_sign(c_b4, snr[0]) * Transform3D.d_sign(c_b4, csl[0]) * Transform3D.d_sign(c_b4, g);
            }
            if (pmax == 3) {
                tsign = Transform3D.d_sign(c_b4, snr[0]) * Transform3D.d_sign(c_b4, snl[0]) * Transform3D.d_sign(c_b4, h);
            }
            single_values[index] = Transform3D.d_sign(ssmax, tsign);
            double d__1 = tsign * Transform3D.d_sign(c_b4, f) * Transform3D.d_sign(c_b4, h);
            single_values[index + 1] = Transform3D.d_sign(ssmin, d__1);
        }
        return 0;
    }

    static double compute_rot(double f, double g, double[] sin, double[] cos, int index, int first) {
        double r;
        double sn;
        double cs;
        double safmn2 = 2.002083095183101E-146;
        double safmx2 = 4.994797680505588E145;
        if (g == 0.0) {
            cs = 1.0;
            sn = 0.0;
            r = f;
        } else if (f == 0.0) {
            cs = 0.0;
            sn = 1.0;
            r = g;
        } else {
            double f1 = f;
            double g1 = g;
            double scale = Transform3D.max(Math.abs(f1), Math.abs(g1));
            if (scale >= 4.994797680505588E145) {
                int count = 0;
                while (scale >= 4.994797680505588E145) {
                    ++count;
                    scale = Transform3D.max(Math.abs(f1 *= 2.002083095183101E-146), Math.abs(g1 *= 2.002083095183101E-146));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                for (int i = 1; i <= count; ++i) {
                    r *= 4.994797680505588E145;
                }
            } else if (scale <= 2.002083095183101E-146) {
                int count = 0;
                while (scale <= 2.002083095183101E-146) {
                    ++count;
                    scale = Transform3D.max(Math.abs(f1 *= 4.994797680505588E145), Math.abs(g1 *= 4.994797680505588E145));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                for (int i = 1; i <= count; ++i) {
                    r *= 2.002083095183101E-146;
                }
            } else {
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
            }
            if (Math.abs(f) > Math.abs(g) && cs < 0.0) {
                cs = -cs;
                sn = -sn;
                r = -r;
            }
        }
        sin[index] = sn;
        cos[index] = cs;
        return r;
    }

    private static final double max3(double[] values) {
        if (values[0] > values[1]) {
            if (values[0] > values[2]) {
                return values[0];
            }
            return values[2];
        }
        if (values[1] > values[2]) {
            return values[1];
        }
        return values[2];
    }

    private final void computeScales(boolean forceSVD) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!forceSVD || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFDF;
                    return;
                }
                this.scales[1] = this.scales[2] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[0] = this.scales[2];
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
        }
        if (this.rot == null) {
            this.rot = new double[9];
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    private final void computeScaleRotation(boolean forceSVD) {
        if (this.rot == null) {
            this.rot = new double[9];
        }
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!forceSVD || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.rot[0] = this.mat[0];
                    this.rot[1] = this.mat[1];
                    this.rot[2] = this.mat[2];
                    this.rot[3] = this.mat[4];
                    this.rot[4] = this.mat[5];
                    this.rot[5] = this.mat[6];
                    this.rot[6] = this.mat[8];
                    this.rot[7] = this.mat[9];
                    this.rot[8] = this.mat[10];
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFFF;
                    return;
                }
                double s = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                if (s == 0.0) {
                    this.compute_svd(this, this.scales, this.rot);
                    return;
                }
                this.scales[1] = this.scales[2] = s;
                this.scales[0] = this.scales[2];
                s = 1.0 / s;
                this.rot[0] = this.mat[0] * s;
                this.rot[1] = this.mat[1] * s;
                this.rot[2] = this.mat[2] * s;
                this.rot[3] = this.mat[4] * s;
                this.rot[4] = this.mat[5] * s;
                this.rot[5] = this.mat[6] * s;
                this.rot[6] = this.mat[8] * s;
                this.rot[7] = this.mat[9] * s;
                this.rot[8] = this.mat[10] * s;
                this.dirtyBits &= 0xFFFFFFFF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                if (this.scales[0] == 0.0 || this.scales[1] == 0.0 || this.scales[2] == 0.0) {
                    this.compute_svd(this, this.scales, this.rot);
                    return;
                }
                double s = 1.0 / this.scales[0];
                this.rot[0] = this.mat[0] * s;
                this.rot[3] = this.mat[4] * s;
                this.rot[6] = this.mat[8] * s;
                s = 1.0 / this.scales[1];
                this.rot[1] = this.mat[1] * s;
                this.rot[4] = this.mat[5] * s;
                this.rot[7] = this.mat[9] * s;
                s = 1.0 / this.scales[2];
                this.rot[2] = this.mat[2] * s;
                this.rot[5] = this.mat[6] * s;
                this.rot[8] = this.mat[10] * s;
                this.dirtyBits &= 0xFFFFFFFF;
                return;
            }
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    final void getRotation(Transform3D t) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        t.mat[14] = 0.0;
        t.mat[13] = 0.0;
        t.mat[12] = 0.0;
        t.mat[11] = 0.0;
        t.mat[7] = 0.0;
        t.mat[3] = 0.0;
        t.mat[15] = 1.0;
        t.mat[0] = this.rot[0];
        t.mat[1] = this.rot[1];
        t.mat[2] = this.rot[2];
        t.mat[4] = this.rot[3];
        t.mat[5] = this.rot[4];
        t.mat[6] = this.rot[5];
        t.mat[8] = this.rot[6];
        t.mat[9] = this.rot[7];
        t.mat[10] = this.rot[8];
        t.dirtyBits = 255;
    }

    final void setOrthoDirtyBit() {
        this.dirtyBits = 255;
        this.type = 0;
    }

    private final boolean isInfOrNaN() {
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            d *= this.mat[i];
        }
        return d != 0.0;
    }

    private final boolean isInfOrNaN(Quat4f q) {
        return Float.isNaN(q.x) || Float.isInfinite(q.x) || Float.isNaN(q.y) || Float.isInfinite(q.y) || Float.isNaN(q.z) || Float.isInfinite(q.z) || Float.isNaN(q.w) || Float.isInfinite(q.w);
    }

    private boolean isInfOrNaN(Quat4d q) {
        return Double.isNaN(q.x) || Double.isInfinite(q.x) || Double.isNaN(q.y) || Double.isInfinite(q.y) || Double.isNaN(q.z) || Double.isInfinite(q.z) || Double.isNaN(q.w) || Double.isInfinite(q.w);
    }

    private boolean isInfOrNaN(AxisAngle4f a) {
        return Float.isNaN(a.x) || Float.isInfinite(a.x) || Float.isNaN(a.y) || Float.isInfinite(a.y) || Float.isNaN(a.z) || Float.isInfinite(a.z) || Float.isNaN(a.angle) || Float.isInfinite(a.angle);
    }

    private boolean isInfOrNaN(AxisAngle4d a) {
        return Double.isNaN(a.x) || Double.isInfinite(a.x) || Double.isNaN(a.y) || Double.isInfinite(a.y) || Double.isNaN(a.z) || Double.isInfinite(a.z) || Double.isNaN(a.angle) || Double.isInfinite(a.angle);
    }

    private boolean isInfOrNaN(double val) {
        return Double.isNaN(val) || Double.isInfinite(val);
    }

    private boolean isInfOrNaN(Vector3f v) {
        return Float.isNaN(v.x) || Float.isInfinite(v.x) || Float.isNaN(v.y) || Float.isInfinite(v.y) || Float.isNaN(v.z) || Float.isInfinite(v.z);
    }

    private boolean isInfOrNaN(Vector3d v) {
        return Double.isNaN(v.x) || Double.isInfinite(v.x) || Double.isNaN(v.y) || Double.isInfinite(v.y) || Double.isNaN(v.z) || Double.isInfinite(v.z);
    }
}

