/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scanconverter.ScanConverter;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class PointLight {
    private final Point3d position;
    private final String id;
    private final Color color;
    private final float[] colorComponents;
    private Camera shadowCam;
    private WritableDeepImage shadowMap;
    private Rectangle4d shadowViewport;
    private Dimension shadowImageSize;
    private double defaultShadowBias = 0.0;
    private int defaultSampleRadius = 0;
    private float multiplier = 2.0f;
    private static final Logger LOGGER = Logger.getLogger(PointLight.class);
    private static final Logger SHADOW_MAP_LOGGER = Logger.getLogger(PointLight.class.getCanonicalName() + "|shadowMap");

    public PointLight(String id, Color color) {
        this(id, color, new Point3d(0.0, 0.0, 0.0));
    }

    public PointLight(String id, Color color, Point3d position) {
        this.id = id;
        this.color = color;
        this.position = position;
        this.colorComponents = color.getColorComponents(null);
    }

    public String getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public Point3d getPosition() {
        return this.position;
    }

    public Color3f lightVertex(Point3d vertex, Vector3d normal, Color3f vertexDiffuseColor) {
        if (vertexDiffuseColor == null) {
            return new Color3f(0.0f, 0.0f, 0.0f);
        }
        float[] resultComponents = new float[3];
        float[] diffuseComponents = new float[3];
        vertexDiffuseColor.get(diffuseComponents);
        Vector3d lightVector = new Vector3d();
        lightVector.set(this.getPosition());
        lightVector.sub(vertex);
        lightVector.normalize();
        double diffuseAngle = normal.dot(lightVector);
        for (int i = 0; i < 3; ++i) {
            float resultComponent;
            resultComponents[i] = resultComponent = diffuseAngle < 0.0 ? 0.0f : (float)((double)(diffuseComponents[i] * this.multiplier * this.colorComponents[i]) * diffuseAngle);
        }
        return new Color3f(resultComponents);
    }

    public List<Color3f> lightPolygon(Polygon3D polygon, Color3f diffuseColor, CoordinateSystem coordinateSystem) {
        ArrayList<Color3f> vertexColors = new ArrayList<Color3f>(polygon.getVertexCount());
        int n = polygon.getVertexCount();
        for (int i = 0; i < n; ++i) {
            Point3d vertex = polygon.getVertex(i, coordinateSystem);
            Vector3d normal = polygon.getNormal();
            Color3f litColor = this.lightVertex(vertex, normal, diffuseColor);
            vertexColors.add(litColor);
        }
        return vertexColors;
    }

    public boolean isFacing(Polygon3D polygon, CoordinateSystem coordinateSystem) {
        Vector3d normal = polygon.getNormal();
        Vector3d lightVector = new Vector3d();
        lightVector.set(this.getPosition());
        lightVector.sub(polygon.getVertex(0, coordinateSystem));
        lightVector.normalize();
        double diffuseAngle = normal.dot(lightVector);
        return diffuseAngle > 0.0;
    }

    public float getShadowFactor(Point3d point, double bias, int sampleRadius) {
        if (this.shadowCam == null) {
            return 1.0f;
        }
        Point3d transformedPoint = this.shadowCam.globalToCamera(point);
        Point3d projectedPoint = this.shadowCam.cameraToProjected(transformedPoint);
        Point3d displayPoint = this.shadowCam.projectedToDisplay(projectedPoint, this.shadowViewport, this.shadowImageSize, new Point3d());
        int x = (int)Math.round(displayPoint.x);
        int y = (int)Math.round(displayPoint.y);
        return this.getShadowFactor(x, y, projectedPoint.z, bias, sampleRadius);
    }

    public float getShadowFactor(Point3d point) {
        return this.getShadowFactor(point, this.defaultShadowBias, this.defaultSampleRadius);
    }

    public void setDefaultShadowBias(double defaultShadowBias) {
        this.defaultShadowBias = defaultShadowBias;
    }

    public void setDefaultSampleRadius(int defaultSampleRadius) {
        this.defaultSampleRadius = defaultSampleRadius;
    }

    public void initShadowMap(Collection<PolyMesh3D> shadowCastingMeshes, Dimension imageSize) {
        BoundingBox3D combinedBounds = MeshUtils.getCombinedBounds(shadowCastingMeshes);
        Point3d lookAt = combinedBounds == null ? new Point3d(0.0, 0.0, 0.0) : combinedBounds.getCenterPoint();
        Vector3d direction = new Vector3d(lookAt);
        direction.sub(this.position);
        this.initShadowMap(shadowCastingMeshes, direction, null, imageSize);
    }

    public void initShadowMap(Collection<PolyMesh3D> shadowCastingMeshes, Vector3d direction, Rectangle4d viewport, Dimension imageSize) {
        if (shadowCastingMeshes.isEmpty()) {
            return;
        }
        Transform3D cumulativeTransform = new Transform3D();
        cumulativeTransform.setIdentity();
        Transform3D translation = new Transform3D();
        translation.setTranslation(new Vector3d(this.position));
        cumulativeTransform.mul(translation);
        double angleAboutY = this.getAngle(-direction.z, direction.x);
        Transform3D rotationAboutY = new Transform3D();
        rotationAboutY.setRotation(new AxisAngle4d(0.0, 1.0, 0.0, angleAboutY));
        cumulativeTransform.mul(rotationAboutY);
        Vector3d xzVector = new Vector3d(direction);
        VectorUtils.setComponent(xzVector, GeometricAxis.Y, 0.0);
        double angleAboutX = this.getAngle(xzVector.length(), direction.y);
        Transform3D rotationAboutX = new Transform3D();
        rotationAboutX.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, -angleAboutX));
        cumulativeTransform.mul(rotationAboutX);
        this.shadowCam = new Camera("SHADOW");
        this.shadowCam.setCumulativeTransform(cumulativeTransform);
        this.shadowImageSize = imageSize;
        Collection<PolyMesh3D> meshesInCameraCoords = this.shadowCam.toCameraCoords(shadowCastingMeshes);
        this.shadowViewport = viewport == null ? this.shadowCam.getProjectedBounds(meshesInCameraCoords) : viewport;
        List<PolyMesh3D> preparedMeshes = this.shadowCam.prepareForScanConversion(meshesInCameraCoords, this.shadowViewport, this.shadowImageSize, RenderQuality.FASTEST);
        this.shadowMap = new WritableDeepImage(imageSize.width, imageSize.height);
        ScanConverter.getDefaultInstance().scanConvert(preparedMeshes, null, this.shadowMap);
        if (SHADOW_MAP_LOGGER.isDebugEnabled()) {
            try {
                RenderResourceIO.getInstance().writeTemporaryImage(this.shadowMap.createDepthImage(), this.getId() + "_SHADOWMAP");
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Failed to write debug image.", e);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to write debug image.", e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", position=" + this.position + "]";
    }

    private double getAngle(double parallel, double perpendicular) {
        double theta = parallel == 0.0 ? (perpendicular > 0.0 ? 4.71238898038469 : 1.5707963267948966) : (parallel < 0.0 ? Math.PI - Math.atan(perpendicular / parallel) : (perpendicular > 0.0 ? Math.PI * 2 - Math.atan(perpendicular / parallel) : -Math.atan(perpendicular / parallel)));
        return theta;
    }

    private float getShadowFactor(int x, int y, double depth, double bias, int sampleRadius) {
        if (sampleRadius == 0) {
            return this.getShadowFactor(x, y, depth, bias);
        }
        float sum = 0.0f;
        int n = x + sampleRadius;
        for (int xSample = x - sampleRadius; xSample <= n; ++xSample) {
            int m = y + sampleRadius;
            for (int ySample = y - sampleRadius; ySample <= m; ++ySample) {
                sum += this.getShadowFactor(xSample, ySample, depth, bias);
            }
        }
        float sampleCount = (float)Math.pow(2 * sampleRadius + 1, 2.0);
        return sum / sampleCount;
    }

    private float getShadowFactor(int x, int y, double depth, double bias) {
        double mapDepth = this.shadowMap.getDepth(x, y);
        return depth - bias > mapDepth ? 0.0f : 1.0f;
    }
}

