/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.scenegraph.DoubleAnimator;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.render.scenegraph.Vector3dAnimator;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;

public class AnimatableTransform {
    public static Set<Channel> ROTATION_CHANNELS = EnumSet.of(Channel.X_ROTATION, Channel.Y_ROTATION, Channel.Z_ROTATION);
    private final Vector3d translation = new Vector3d();
    private final AxisAngle4d xRotation = new AxisAngle4d(1.0, 0.0, 0.0, 0.0);
    private final AxisAngle4d yRotation = new AxisAngle4d(0.0, 1.0, 0.0, 0.0);
    private final AxisAngle4d zRotation = new AxisAngle4d(0.0, 0.0, 1.0, 0.0);
    private final Vector3d scale = new Vector3d();
    private final Map<Channel, TransformAnimator<?>> animators = new EnumMap(Channel.class);
    private final NavigableSet<Double> keyframes = new TreeSet<Double>();

    public void setTranslation(Vector3d translation) {
        this.translation.set(translation);
    }

    public void setXRotation(AxisAngle4d rotation) {
        this.xRotation.set(rotation);
    }

    public void setXRotation(Double angle) {
        this.xRotation.set(new AxisAngle4d(1.0, 0.0, 0.0, angle));
    }

    public void setYRotation(AxisAngle4d rotation) {
        this.yRotation.set(rotation);
    }

    public void setYRotation(Double angle) {
        this.yRotation.set(new AxisAngle4d(0.0, 1.0, 0.0, angle));
    }

    public void setZRotation(AxisAngle4d rotation) {
        this.zRotation.set(rotation);
    }

    public void setZRotation(Double angle) {
        this.zRotation.set(new AxisAngle4d(0.0, 0.0, 1.0, angle));
    }

    public void setScale(Vector3d scale) {
        this.scale.set(scale);
    }

    public void setAnimator(Channel channel, DoubleAnimator animator) {
        assert (ROTATION_CHANNELS.contains((Object)channel)) : "Not a scalar channel";
        this.animators.put(channel, animator);
        this.updateKeyframes();
    }

    public void setAnimator(Channel channel, Vector3dAnimator animator) {
        assert (!ROTATION_CHANNELS.contains((Object)channel)) : "Not a vector channel";
        this.animators.put(channel, animator);
        this.updateKeyframes();
    }

    public TransformAnimator<?> getAnimator(Channel channel) {
        return this.animators.get((Object)channel);
    }

    public NavigableSet<Double> getKeyframes() {
        return this.keyframes;
    }

    public void setAnimationFraction(double fraction) {
        if (this.keyframes.size() == 0) {
            return;
        }
        if (this.keyframes.size() == 1) {
            this.setAnimationFrame((Double)this.keyframes.first());
        } else {
            this.setAnimationFrame(MathUtils.interpolate(fraction, (Double)this.keyframes.first(), (Double)this.keyframes.last()));
        }
    }

    public void setAnimationFrame(double frame) {
        for (Map.Entry<Channel, TransformAnimator<?>> entry : this.animators.entrySet()) {
            TransformAnimator<?> animator = entry.getValue();
            Object value = animator.getValueAt(frame);
            switch (entry.getKey()) {
                case TRANSLATION: {
                    this.setTranslation((Vector3d)value);
                    break;
                }
                case SCALE: {
                    this.setScale((Vector3d)value);
                    break;
                }
                case X_ROTATION: {
                    this.setXRotation((Double)value);
                    break;
                }
                case Y_ROTATION: {
                    this.setYRotation((Double)value);
                    break;
                }
                case Z_ROTATION: {
                    this.setZRotation((Double)value);
                }
            }
        }
    }

    public Transform3D getTransform3D() {
        Transform3D result = new Transform3D();
        Transform3D subXForm = new Transform3D();
        result.setTranslation(this.translation);
        subXForm.setIdentity();
        subXForm.setRotation(this.zRotation);
        result.mul(subXForm);
        subXForm.setIdentity();
        subXForm.setRotation(this.yRotation);
        result.mul(subXForm);
        subXForm.setIdentity();
        subXForm.setRotation(this.xRotation);
        result.mul(subXForm);
        subXForm.setIdentity();
        subXForm.setScale(this.scale);
        result.mul(subXForm);
        return result;
    }

    public void updateKeyframes() {
        this.keyframes.clear();
        for (TransformAnimator<?> animator : this.animators.values()) {
            this.keyframes.addAll(animator.getKeyframes());
        }
    }

    public static enum Channel {
        TRANSLATION,
        X_ROTATION,
        Y_ROTATION,
        Z_ROTATION,
        SCALE;

    }
}

