/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scenegraph;

import com.sodiumarc.patchwork.render.scenegraph.DoubleAnimator;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.MathUtils;
import java.util.Map;

public class AngleAnimator
extends DoubleAnimator {
    private final Range<Double> angleRange;

    public AngleAnimator(Map<Double, Double> rawKeyframes, boolean normalize, double min, double max) {
        super(rawKeyframes, normalize);
        this.angleRange = new Range<Double>(min, max);
    }

    @Override
    protected Double interpolate(Double from, Double to, double intervalFraction) {
        double result = 0.0;
        if (from < to) {
            double fromUnwrapped = from + 360.0;
            if (fromUnwrapped - to < to - from) {
                from = fromUnwrapped;
            }
        } else {
            double toUnwrapped = to + 360.0;
            if (toUnwrapped - from < from - to) {
                to = toUnwrapped;
            }
        }
        result = MathUtils.interpolate(intervalFraction, from, to);
        if (result > this.angleRange.getMax()) {
            result -= 360.0;
        } else if (result < this.angleRange.getMin()) {
            result += 360.0;
        }
        return result;
    }
}

