/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scanconverter;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.TextureMap;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scanconverter.InterpolatedTuple3f;
import com.sodiumarc.patchwork.render.scanconverter.SCFeature;
import com.sodiumarc.patchwork.render.scanconverter.SCPolygon;
import com.sodiumarc.patchwork.render.scanconverter.SCVertex;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class ScanConverter {
    private TextureMap _textureMap;
    private static final ScanConverter DEFAULT_INSTANCE = new ScanConverter();

    public static final ScanConverter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ScanConverter() {
        try {
            this._textureMap = new TextureMap("mw_card_cropped_w500.JPG");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this._textureMap = null;
        }
    }

    public void scanConvert(Collection<PolyMesh3D> meshes, Filter<Polygon3D> polyFilter, WritableDeepImage result) {
        this.scanConvert(meshes, EnumSet.noneOf(SCFeature.class), new ArrayList<PointLight>(), polyFilter, result);
    }

    public void scanConvert(Collection<PolyMesh3D> meshes, Set<SCFeature> features, Collection<PointLight> lights, Filter<Polygon3D> polyFilter, WritableDeepImage result) {
        Map<InterpolatedTuple3f, PointLight> lightTable = this.getLightTable(lights);
        boolean renderShadows = features.contains((Object)SCFeature.SHADOWS) && !lightTable.isEmpty();
        BoundingBox3D boundingBox = this.getBoundingBox(meshes);
        Range<Double> xRange = boundingBox.getRange(GeometricAxis.X);
        Range<Double> yRange = boundingBox.getRange(GeometricAxis.Y);
        int xMin = (int)Math.floor(xRange.getMin());
        int xMax = (int)Math.floor(xRange.getMax());
        int yMin = (int)Math.floor(yRange.getMin());
        int yMax = (int)Math.floor(yRange.getMax());
        MultiHashMap<Integer, SCPolygon> polysByYStart = this.getPolysByYStart(meshes, lightTable, polyFilter, features);
        ArrayList<SCPolygon> activeRowPolygons = new ArrayList<SCPolygon>();
        for (int y = yMin; y < yMax; ++y) {
            Iterator iter = activeRowPolygons.iterator();
            while (iter.hasNext()) {
                SCPolygon polygon = (SCPolygon)iter.next();
                if (polygon.getYEnd() < y) {
                    iter.remove();
                    continue;
                }
                polygon.toYNext();
            }
            for (SCPolygon polygon : polysByYStart.getAll(y)) {
                activeRowPolygons.add(polygon);
                polygon.toYStart();
            }
            for (int x = xMin; x < xMax; ++x) {
                SCPolygon nearestPolygon = null;
                double zNearest = Double.POSITIVE_INFINITY;
                for (SCPolygon polygon : activeRowPolygons) {
                    if (x < polygon.getSpanXStart() || x > polygon.getSpanXEnd()) continue;
                    SCVertex spanVertex = polygon.getSpanCurrentVertex();
                    double zDistance = spanVertex.displayCoords().z;
                    if (!(zDistance < zNearest)) continue;
                    zNearest = zDistance;
                    nearestPolygon = polygon;
                }
                if (nearestPolygon != null && result.containsPoint(x, y)) {
                    SCVertex spanVertex = nearestPolygon.getSpanCurrentVertex();
                    int pixelColor = this.getPixelColor(spanVertex, nearestPolygon.getPolygon3D(), lightTable, renderShadows);
                    result.compositeColor(x, y, zNearest, pixelColor, false, 0, true);
                }
                for (SCPolygon polygon : activeRowPolygons) {
                    if (x < polygon.getSpanXStart() || x > polygon.getSpanXEnd()) continue;
                    polygon.toXNext();
                }
            }
        }
    }

    private int getPixelColor(SCVertex spanVertex, Polygon3D polygon, Map<InterpolatedTuple3f, PointLight> lightTable, boolean renderShadows) {
        int result;
        if (renderShadows) {
            Point3d surfacePoint = new Point3d(spanVertex.getInterpolatedValue(InterpolatedTuple3f.CAMERA_COORDS));
            Color3f summedColor = new Color3f(0.0f, 0.0f, 0.0f);
            for (InterpolatedTuple3f colorKey : InterpolatedTuple3f.COLORS) {
                PointLight light = lightTable.get((Object)colorKey);
                Tuple3f color = spanVertex.getInterpolatedValue(colorKey);
                if (light == null || color == null || !light.isFacing(polygon, CoordinateSystem.CAMERA)) continue;
                float shadowFactor = light.getShadowFactor(surfacePoint);
                summedColor.scaleAdd(shadowFactor, color, summedColor);
            }
            result = ColorUtils.toIntARGB(summedColor);
        } else {
            if (spanVertex.hasInterpolatedValue(InterpolatedTuple3f.INVERSE_TEXTURE_COORDS)) {
                Point3f textureCoords = spanVertex.textureCoords();
                return this._textureMap.getColor(textureCoords.x, textureCoords.y);
            }
            Color3f color3f = spanVertex.emissiveColor();
            result = color3f == null ? -16777216 : ColorUtils.toIntARGB(color3f);
        }
        return result;
    }

    private BoundingBox3D getBoundingBox(Collection<PolyMesh3D> meshes) {
        BoundingBox3D boundingBox = null;
        for (PolyMesh3D mesh : meshes) {
            if (boundingBox == null) {
                boundingBox = mesh.getBoundingBox();
                continue;
            }
            boundingBox.combine(mesh.getBoundingBox());
        }
        return boundingBox;
    }

    private PolyMesh3D getTestMesh() {
        List<Point3d> verts = Arrays.asList(new Point3d(200.0, 100.0, 0.0), new Point3d(80.0, 200.4f, 0.0), new Point3d(200.3, 400.0, 0.0), new Point3d(250.0, 100.0, 0.0));
        List<Color3f> colors = Arrays.asList(new Color3f(0.1f, 0.1f, 0.1f), new Color3f(0.3f, 0.3f, 0.3f), new Color3f(0.7f, 0.7f, 0.7f));
        PolyMesh3D mesh = new PolyMesh3D("Test", verts, colors);
        mesh.addPolygonIndexed(Arrays.asList(0, 1, 2, 3), Arrays.asList(1, 0, 2, 1), null, new Vector3d(0.0, 0.0, 1.0), -1);
        return mesh;
    }

    private MultiHashMap<Integer, SCPolygon> getPolysByYStart(Collection<PolyMesh3D> meshes, Map<InterpolatedTuple3f, PointLight> lightTable, Filter<Polygon3D> polyFilter, Set<SCFeature> features) {
        Set<InterpolatedTuple3f> interpolationKeys = this.getInterpolationKeys(features, lightTable);
        MultiHashMap<Integer, SCPolygon> result = new MultiHashMap<Integer, SCPolygon>();
        for (PolyMesh3D mesh : meshes) {
            for (Polygon3D polygon : mesh.getPolygons()) {
                if (polyFilter != null && !polyFilter.accept(polygon)) continue;
                SCPolygon scPolygon = new SCPolygon(polygon, lightTable, interpolationKeys, features);
                result.putLast(scPolygon.getYStart(), scPolygon);
            }
        }
        return result;
    }

    private Set<InterpolatedTuple3f> getInterpolationKeys(Set<SCFeature> features, Map<InterpolatedTuple3f, PointLight> lightTable) {
        EnumSet<InterpolatedTuple3f> result = EnumSet.of(InterpolatedTuple3f.EMISSIVE_COLOR);
        if (features.contains((Object)SCFeature.SHADOWS)) {
            result.add(InterpolatedTuple3f.CAMERA_COORDS);
            result.addAll(lightTable.keySet());
        }
        if (features.contains((Object)SCFeature.TEXTURE_MAPPING)) {
            result.add(InterpolatedTuple3f.INVERSE_TEXTURE_COORDS);
        }
        return result;
    }

    private Map<InterpolatedTuple3f, PointLight> getLightTable(Collection<PointLight> lights) {
        EnumMap<InterpolatedTuple3f, PointLight> result = new EnumMap<InterpolatedTuple3f, PointLight>(InterpolatedTuple3f.class);
        List<InterpolatedTuple3f> lightKeys = Arrays.asList(InterpolatedTuple3f.LIGHT0_COLOR, InterpolatedTuple3f.LIGHT1_COLOR, InterpolatedTuple3f.LIGHT2_COLOR, InterpolatedTuple3f.LIGHT3_COLOR);
        int lightIndex = 0;
        for (PointLight light : lights) {
            if (lightIndex >= lightKeys.size()) break;
            result.put(lightKeys.get(lightIndex), light);
            ++lightIndex;
        }
        return result;
    }
}

