/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scanconverter;

import com.sodiumarc.patchwork.render.scanconverter.InterpolatedTuple3f;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.util.EnumMap;
import java.util.Map;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public class SCVertex {
    private final Point3f _displayCoords = new Point3f();
    private final Map<InterpolatedTuple3f, Tuple3f> _interpolatedValues = new EnumMap<InterpolatedTuple3f, Tuple3f>(InterpolatedTuple3f.class);

    public Point3f displayCoords() {
        return this._displayCoords;
    }

    public Map<InterpolatedTuple3f, Tuple3f> getInterpolatedValues() {
        return this._interpolatedValues;
    }

    public void setInterpolatedValues(Map<InterpolatedTuple3f, Tuple3f> values) {
        this._interpolatedValues.clear();
        for (Map.Entry<InterpolatedTuple3f, Tuple3f> entry : values.entrySet()) {
            InterpolatedTuple3f key = entry.getKey();
            this._interpolatedValues.put(key, key.newInstance(entry.getValue()));
        }
    }

    public Tuple3f getInterpolatedValue(InterpolatedTuple3f key) {
        return this._interpolatedValues.get((Object)key);
    }

    public boolean hasInterpolatedValue(InterpolatedTuple3f key) {
        return this._interpolatedValues.containsKey((Object)key);
    }

    public Color3f emissiveColor() {
        return (Color3f)this._interpolatedValues.get((Object)InterpolatedTuple3f.EMISSIVE_COLOR);
    }

    public Point3f textureCoords() {
        Point3f inverseTextureCoords = (Point3f)this.getInterpolatedValue(InterpolatedTuple3f.INVERSE_TEXTURE_COORDS);
        if (inverseTextureCoords == null) {
            return null;
        }
        return new Point3f(inverseTextureCoords.x / inverseTextureCoords.z, inverseTextureCoords.y / inverseTextureCoords.z, 0.0f);
    }

    public void set(SCVertex source) {
        this._displayCoords.set(source.displayCoords());
        this.setInterpolatedValues(source.getInterpolatedValues());
    }

    public void set(Point3d coords, Map<InterpolatedTuple3f, Tuple3f> interpolatedValues) {
        this._displayCoords.set(coords);
        this.setInterpolatedValues(interpolatedValues);
    }

    public void addDelta(SCVertex delta) {
        this.addDelta(delta, 1.0f);
    }

    public void addDelta(SCVertex delta, float scale) {
        this._displayCoords.scaleAdd(scale, delta.displayCoords(), this._displayCoords);
        Map<InterpolatedTuple3f, Tuple3f> deltaValues = delta.getInterpolatedValues();
        for (Map.Entry<InterpolatedTuple3f, Tuple3f> entry : this._interpolatedValues.entrySet()) {
            Tuple3f value = entry.getValue();
            Tuple3f deltaValue = deltaValues.get((Object)entry.getKey());
            if (deltaValue == null) continue;
            value.scaleAdd(scale, deltaValue, value);
        }
    }

    public void setStepDelta(SCVertex startVertex, SCVertex endVertex, GeometricAxis axis) {
        float del = 0.0f;
        switch (axis) {
            case X: {
                del = endVertex.displayCoords().x - startVertex.displayCoords().x;
                break;
            }
            case Y: {
                del = endVertex.displayCoords().y - startVertex.displayCoords().y;
                break;
            }
            case Z: {
                del = endVertex.displayCoords().z - startVertex.displayCoords().z;
            }
        }
        if (del == 0.0f) {
            return;
        }
        this._displayCoords.setX((endVertex.displayCoords().x - startVertex.displayCoords().x) / del);
        this._displayCoords.setZ((endVertex.displayCoords().z - startVertex.displayCoords().z) / del);
        this._interpolatedValues.clear();
        Map<InterpolatedTuple3f, Tuple3f> endValues = endVertex.getInterpolatedValues();
        for (Map.Entry<InterpolatedTuple3f, Tuple3f> startEntry : startVertex.getInterpolatedValues().entrySet()) {
            Tuple3f startValue = startEntry.getValue();
            Tuple3f endValue = endValues.get((Object)startEntry.getKey());
            if (endValue == null) continue;
            Tuple3f deltaValue = startEntry.getKey().newInstance();
            deltaValue.setX((endValue.x - startValue.x) / del);
            deltaValue.setY((endValue.y - startValue.y) / del);
            deltaValue.setZ((endValue.z - startValue.z) / del);
            this._interpolatedValues.put(startEntry.getKey(), deltaValue);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._displayCoords;
    }
}

