/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.scanconverter;

import com.sodiumarc.patchwork.render.scanconverter.InterpolatedTuple3f;
import com.sodiumarc.patchwork.render.scanconverter.SCVertex;
import com.sodiumarc.patchwork.util.GeometricAxis;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;

public class SCEdge {
    private final SCVertex _startVertex = new SCVertex();
    private final SCVertex _endVertex = new SCVertex();
    private final SCVertex _rowDelta = new SCVertex();
    private final SCVertex _rowEntryVertex = new SCVertex();
    private final SCVertex _rowExitVertex = new SCVertex();

    public SCEdge(Point3d vertex0, Map<InterpolatedTuple3f, Tuple3f> values0, Point3d vertex1, Map<InterpolatedTuple3f, Tuple3f> values1) {
        if (vertex0.y < vertex1.y) {
            this._startVertex.set(vertex0, values0);
            this._endVertex.set(vertex1, values1);
        } else {
            this._startVertex.set(vertex1, values1);
            this._endVertex.set(vertex0, values0);
        }
        this._rowDelta.setStepDelta(this._startVertex, this._endVertex, GeometricAxis.Y);
    }

    public void toYStart() {
        float delYInit = (float)this.getYStart() - this._startVertex.displayCoords().y;
        this._rowEntryVertex.set(this._startVertex);
        this._rowEntryVertex.addDelta(this._rowDelta, delYInit);
        this._rowExitVertex.set(this._rowEntryVertex);
        this._rowExitVertex.addDelta(this._rowDelta);
    }

    public void toYNext() {
        this._rowEntryVertex.set(this._rowExitVertex);
        this._rowExitVertex.set(this._rowEntryVertex);
        this._rowExitVertex.addDelta(this._rowDelta);
    }

    public int getXStart() {
        return (int)Math.ceil(this._startVertex.displayCoords().x);
    }

    public int getYStart() {
        return (int)Math.ceil(this._startVertex.displayCoords().y);
    }

    public int getXEnd() {
        return (int)Math.floor(this._endVertex.displayCoords().x);
    }

    public int getYEnd() {
        double yEndFloor = Math.floor(this._endVertex.displayCoords().y);
        return (double)this._endVertex.displayCoords().y == yEndFloor ? (int)yEndFloor - 1 : (int)yEndFloor;
    }

    public int getXCurrent() {
        return (int)Math.floor(this._rowEntryVertex.displayCoords().x);
    }

    public SCVertex getStartVertex() {
        return this._startVertex;
    }

    public SCVertex getEndVertex() {
        return this._endVertex;
    }

    public SCVertex getRowEntryVertex() {
        return this._rowEntryVertex;
    }

    public SCVertex getRowExitVertex() {
        return this._rowExitVertex;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._startVertex + " -> " + this._endVertex + "]";
    }
}

