/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.Path;
import com.sodiumarc.patchwork.render.mesh.Plane;
import com.sodiumarc.patchwork.render.mesh.PolyMaterial;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PolyMesh3D {
    public static final String PROJECTED_VERTICES = "projectedVertices";
    public static final String CAMERA_COORDS = "cameraCoords";
    public static final String GLOBAL_COORDS = "globalCoords";
    public static final String ID_SEPARATOR = ";";
    private String _identifier;
    private final List<Point3d> _vertices;
    private final BitSet _vertexUsageMap;
    private final Map<CoordinateSystem, List<Point3d>> _alternateVertices;
    private final List<Color3f> _colors;
    private final List<Polygon3D> _polygons;
    private final List<Point3d> _textureCoordinates;
    private final List<PolyMaterial> _materials;
    private final Map<String, String> _aliasByNamespaceID;
    private Collection<Edge> _allEdges;
    private MultiHashMap<Integer, Edge> _edgesByVertex;
    private BoundingBox3D _boundingBox;

    public PolyMesh3D(String identifier, List<Point3d> vertices) {
        this(identifier, vertices, null, null, null);
    }

    public PolyMesh3D(String identifier, List<Point3d> vertices, List<Color3f> colors) {
        this(identifier, vertices, colors, null, null);
    }

    public PolyMesh3D(String identifier, List<Point3d> vertices, List<Color3f> colors, List<Point3d> textureCoordinates, List<PolyMaterial> materials) {
        this._identifier = identifier;
        this._vertices = new ArrayList<Point3d>(vertices);
        this._vertexUsageMap = new BitSet(this._vertices.size());
        this._alternateVertices = new EnumMap<CoordinateSystem, List<Point3d>>(CoordinateSystem.class);
        this._colors = colors == null ? null : new ArrayList<Color3f>(colors);
        this._textureCoordinates = textureCoordinates == null ? null : new ArrayList<Point3d>(textureCoordinates);
        this._materials = materials == null ? null : new ArrayList<PolyMaterial>(materials);
        this._polygons = new ArrayList<Polygon3D>();
        this._aliasByNamespaceID = new HashMap<String, String>();
    }

    public PolyMesh3D(String id, PolyMesh3D source) {
        this._identifier = id;
        this._vertices = new ArrayList<Point3d>(source.getVertices());
        this._vertexUsageMap = new BitSet(this._vertices.size());
        this._alternateVertices = new EnumMap<CoordinateSystem, List<Point3d>>(CoordinateSystem.class);
        this._colors = CollectionUtils.copyList(source.getColors());
        this._textureCoordinates = CollectionUtils.copyList(source.getTextureCoordinates());
        this._materials = CollectionUtils.copyList(source.getMaterials());
        this._polygons = new ArrayList<Polygon3D>();
        this._aliasByNamespaceID = new HashMap<String, String>();
        this.setAliases(source.getAliases());
        this.setAlternateVertices(source.getAlternateVertices());
        for (Polygon3D sourcePolygon : source.getPolygons()) {
            this.addPolygonIndexed(CollectionUtils.copyList(sourcePolygon.getVertexIndices()), CollectionUtils.copyList(sourcePolygon.getVertexColorIndices()), CollectionUtils.copyList(sourcePolygon.getTextureCoordIndices()), new Vector3d(sourcePolygon.getNormal()), sourcePolygon.getMaterialIndex());
        }
    }

    public PolyMesh3D(PolyMesh3D source) {
        this(source.getIdentifier(), source);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String getAlias(String namespaceID) {
        return this._aliasByNamespaceID.get(namespaceID);
    }

    public void setAlias(String namespaceID, String alias) {
        this._aliasByNamespaceID.put(namespaceID, alias);
    }

    public Map<String, String> getAliases() {
        return Collections.unmodifiableMap(this._aliasByNamespaceID);
    }

    public void setAliases(Map<String, String> aliasByNamespaceID) {
        this._aliasByNamespaceID.clear();
        this._aliasByNamespaceID.putAll(aliasByNamespaceID);
    }

    public List<Point3d> getVertices() {
        return this._vertices;
    }

    public BitSet getVertexUsageMap() {
        return this._vertexUsageMap;
    }

    public boolean isVertexUsed(int index) {
        return this._vertexUsageMap.get(index);
    }

    public void setAlternateVertices(CoordinateSystem coordinateSystem, List<Point3d> vertices) {
        assert (coordinateSystem != null);
        assert (vertices.size() == this._vertices.size());
        this._alternateVertices.put(coordinateSystem, vertices);
    }

    public void setAlternateVertices(Map<CoordinateSystem, List<Point3d>> alternativeVertices) {
        this._alternateVertices.clear();
        this._alternateVertices.putAll(alternativeVertices);
    }

    public List<Point3d> getAlternateVertices(CoordinateSystem coordinateSystem) {
        return this._alternateVertices.get((Object)coordinateSystem);
    }

    public Map<CoordinateSystem, List<Point3d>> getAlternateVertices() {
        return Collections.unmodifiableMap(this._alternateVertices);
    }

    public List<Color3f> getColors() {
        return this._colors;
    }

    public List<Point3d> getTextureCoordinates() {
        return this._textureCoordinates;
    }

    public List<PolyMaterial> getMaterials() {
        return this._materials;
    }

    public List<Polygon3D> getPolygons() {
        return this._polygons;
    }

    public void setPolygonGroupdentifier(String identifier) {
        for (Polygon3D poly : this._polygons) {
            poly.setGroupIdentifier(identifier);
        }
    }

    public Set<String> getPolygonGroupIdentifiers() {
        HashSet<String> result = new HashSet<String>();
        for (Polygon3D polygon : this._polygons) {
            String groupId = polygon.getGroupIdentifier();
            if (groupId == null) continue;
            result.add(groupId);
        }
        return result;
    }

    public Polygon3D addPolygonIndexed(List<Integer> indices, List<Integer> vertexColorIndices, List<Integer> textureCoordIndices, Vector3d normal, int materialIndex) {
        Polygon3D poly = new Polygon3D(this, this._polygons.size(), indices, vertexColorIndices, textureCoordIndices, normal, materialIndex);
        this._polygons.add(poly);
        for (Integer index : indices) {
            this._vertexUsageMap.set(index);
        }
        return poly;
    }

    public Polygon3D addPolygon(List<Point3d> vertices, List<Color3f> vertexColors, List<Point3d> textureCoords, Vector3d normal, PolyMaterial material) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Point3d vertex : vertices) {
            indices.add(this._vertices.size());
            this._vertices.add(vertex);
        }
        ArrayList<Integer> vertexColorIndices = null;
        if (vertexColors != null) {
            vertexColorIndices = new ArrayList<Integer>();
            for (Color3f color : vertexColors) {
                vertexColorIndices.add(this._colors.size());
                this._colors.add(color);
            }
        }
        ArrayList<Integer> textureCoordIndices = null;
        if (textureCoords != null) {
            textureCoordIndices = new ArrayList<Integer>();
            for (Point3d coord : textureCoords) {
                textureCoordIndices.add(this._textureCoordinates.size());
                this._textureCoordinates.add(coord);
            }
        }
        int materialIndex = -1;
        if (material != null) {
            materialIndex = this._materials.size();
            this._materials.add(material);
        }
        return this.addPolygonIndexed(indices, vertexColorIndices, textureCoordIndices, normal, materialIndex);
    }

    public Collection<Edge> getEdges() {
        this.updateEdges();
        return this._allEdges;
    }

    public Edge getEdge(int vertex0Index, int vertex1Index) {
        this.updateEdges();
        for (Edge edge : this._edgesByVertex.getAll(vertex0Index)) {
            if (edge.getVertex0Index() == vertex0Index && edge.getVertex1Index() == vertex1Index) {
                return edge;
            }
            if (edge.getVertex0Index() != vertex1Index || edge.getVertex1Index() != vertex0Index) continue;
            return edge;
        }
        return null;
    }

    public List<Path> getPaths(Filter<Edge> edgeFilter) {
        Collection<Edge> edges = CollectionUtils.filter(this.getEdges(), edgeFilter, new ArrayList());
        return MeshUtils.getPaths(this._vertices, edges, new ArrayList<Path>());
    }

    public void consolidateVertices(double weldThreshold) {
        Map<Integer, Integer> substitutionMap = MeshUtils.consolidateVertices(this._vertices, weldThreshold, EnumSet.allOf(GeometricAxis.class));
        for (Polygon3D polygon : this._polygons) {
            List<Integer> vertIndices = polygon.getVertexIndices();
            for (int i = 0; i < vertIndices.size(); ++i) {
                int vertexIndex = vertIndices.get(i);
                Integer substitution = substitutionMap.get(vertexIndex);
                if (substitution == null) continue;
                vertIndices.set(i, substitution);
            }
        }
        for (Integer index : substitutionMap.keySet()) {
            this._vertexUsageMap.clear(index);
        }
        this.invalidateEdges();
    }

    public void eliminateOverlappingEdges() {
        this.getEdges();
        boolean edgesChanged = false;
        for (int i = 0; i < this._vertices.size(); ++i) {
            List<Edge> edges = this._edgesByVertex.getAll(i);
            HashMap<Edge, Edge> parallelEdgeMap = new HashMap<Edge, Edge>();
            for (Edge edge : edges) {
                Edge parallelEdge;
                if (edge.getVertex0Index() != i || (parallelEdge = this.findParallelEdge(i, edge, false, false)) == null || !(edge.getLength() > parallelEdge.getLength())) continue;
                parallelEdgeMap.put(edge, parallelEdge);
            }
            Edge longestEdge = null;
            Edge parallelEdge = null;
            for (Map.Entry entry : parallelEdgeMap.entrySet()) {
                int ci;
                longestEdge = (Edge)entry.getKey();
                parallelEdge = (Edge)entry.getValue();
                ArrayList<Integer> chainIndices = new ArrayList<Integer>();
                chainIndices.add(parallelEdge.getVertex1Index());
                chainIndices.add(parallelEdge.getVertex0Index());
                Edge currentEdge = parallelEdge;
                Edge nextEdge = null;
                while ((ci = ((Integer)chainIndices.get(chainIndices.size() - 1)).intValue()) != longestEdge.getVertex1Index()) {
                    nextEdge = this.findParallelEdge(ci, currentEdge, false, true);
                    if (nextEdge != null) {
                        chainIndices.add(nextEdge.getVertex0Index());
                    }
                    currentEdge = nextEdge;
                    if (nextEdge != null) continue;
                }
                if (ci != longestEdge.getVertex1Index()) continue;
                edgesChanged = true;
                assert (chainIndices.size() > 2) : "double edge?";
                Polygon3D polygon = longestEdge.getPoly0To1();
                if (longestEdge.getPoly1To0() != null) continue;
                ArrayList<Integer> newVertexIndices = new ArrayList<Integer>(polygon.getVertexIndices());
                ArrayList<Integer> newVertexColorIndices = polygon.hasVertexColors() ? new ArrayList<Integer>(polygon.getVertexColorIndices()) : null;
                ArrayList<Integer> newTextureCoordIndices = polygon.hasTextureCoords() ? new ArrayList<Integer>(polygon.getTextureCoordIndices()) : null;
                int startPolyIndex = newVertexIndices.indexOf(longestEdge.getVertex0Index());
                int endPolyIndex = newVertexIndices.indexOf(longestEdge.getVertex1Index());
                int insertionPolyIndex = startPolyIndex + 1;
                assert (((Integer)newVertexIndices.get(insertionPolyIndex % newVertexIndices.size())).intValue() == longestEdge.getVertex1Index());
                Vector3d chainVector = new Vector3d();
                for (int j = 1; j < chainIndices.size() - 1; ++j) {
                    int chainVertexIndex = (Integer)chainIndices.get(j);
                    chainVector.sub(this._vertices.get(chainVertexIndex), longestEdge.getVertex0());
                    double chainFraction = chainVector.length() / longestEdge.getLength();
                    newVertexIndices.add(insertionPolyIndex, chainVertexIndex);
                    if (newVertexColorIndices != null) {
                        Color3f clipColor = new Color3f();
                        clipColor.interpolate(polygon.getVertexColor(startPolyIndex), polygon.getVertexColor(endPolyIndex), (float)chainFraction);
                        newVertexColorIndices.add(insertionPolyIndex, this._colors.size());
                        this._colors.add(clipColor);
                    }
                    if (newTextureCoordIndices != null) {
                        Point3d clipTextureCoords = new Point3d();
                        clipTextureCoords.interpolate((Tuple3d)polygon.getTextureCoords(startPolyIndex), (Tuple3d)polygon.getTextureCoords(endPolyIndex), chainFraction);
                        newTextureCoordIndices.add(insertionPolyIndex, this._textureCoordinates.size());
                        this._textureCoordinates.add(clipTextureCoords);
                    }
                    ++insertionPolyIndex;
                }
                polygon.setVertexIndices(newVertexIndices);
                polygon.setVertexColorIndices(newVertexColorIndices);
                polygon.setTextureCoordIndices(newTextureCoordIndices);
            }
        }
        if (edgesChanged) {
            this.invalidateEdges();
        }
    }

    public int compareBoundsToPlane(Plane plane) {
        boolean inside = false;
        boolean outside = false;
        for (Point3d corner : this.getBoundingBox().getAllCornerPoints()) {
            if (plane.pointDistance(corner) >= 0.0) {
                inside = true;
                continue;
            }
            outside = true;
        }
        if (inside && outside) {
            return 0;
        }
        return inside ? 1 : -1;
    }

    public boolean clipToPlane(Plane plane) {
        int compare = this.compareBoundsToPlane(plane);
        if (compare == 1) {
            return false;
        }
        if (compare == -1) {
            this._polygons.clear();
            this._boundingBox = null;
        } else {
            Iterator<Polygon3D> iter = this._polygons.iterator();
            while (iter.hasNext()) {
                Polygon3D polygon = iter.next();
                if (this.clipToPlane(plane, polygon)) continue;
                iter.remove();
            }
            this._boundingBox = null;
        }
        return true;
    }

    public BoundingBox3D getBoundingBox() {
        if (this._boundingBox == null) {
            this._boundingBox = this.computeBoundingBox();
        }
        return this._boundingBox;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this._identifier + "\") ";
    }

    private BoundingBox3D computeBoundingBox() {
        Point3d minCorner = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point3d maxCorner = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < this._vertices.size(); ++i) {
            if (!this._vertexUsageMap.get(i)) continue;
            Point3d vertex = this._vertices.get(i);
            for (GeometricAxis axis : GeometricAxis.values()) {
                double value = VectorUtils.getComponent(vertex, axis);
                if (value < VectorUtils.getComponent(minCorner, axis)) {
                    VectorUtils.setComponent(minCorner, axis, value);
                }
                if (!(value > VectorUtils.getComponent(maxCorner, axis))) continue;
                VectorUtils.setComponent(maxCorner, axis, value);
            }
        }
        return new BoundingBox3D(minCorner, maxCorner);
    }

    private boolean clipToPlane(Plane plane, Polygon3D polygon) {
        int oldVertexCount = polygon.getVertexCount();
        BitSet remainingVertices = new BitSet(oldVertexCount);
        for (int i = 0; i < oldVertexCount; ++i) {
            boolean inside = plane.pointDistance(polygon.getVertex(i)) >= 0.0;
            remainingVertices.set(i, inside);
            if (inside) continue;
            this._vertexUsageMap.clear(polygon.getVertexIndices().get(i));
        }
        if (remainingVertices.isEmpty()) {
            return false;
        }
        if (remainingVertices.cardinality() == oldVertexCount) {
            return true;
        }
        ArrayList<Integer> newVertexIndices = new ArrayList<Integer>();
        ArrayList<Integer> newVertexColorIndices = polygon.hasVertexColors() ? new ArrayList<Integer>() : null;
        ArrayList<Integer> newTextureCoordIndices = polygon.hasTextureCoords() ? new ArrayList<Integer>() : null;
        for (int i = 0; i < oldVertexCount; ++i) {
            int iNext = (i + 1) % oldVertexCount;
            boolean keepThis = remainingVertices.get(i);
            boolean keepNext = remainingVertices.get(iNext);
            if (keepThis) {
                newVertexIndices.add(polygon.getVertexIndices().get(i));
                if (newVertexColorIndices != null) {
                    newVertexColorIndices.add(polygon.getVertexColorIndices().get(i));
                }
                if (newTextureCoordIndices != null) {
                    newTextureCoordIndices.add(polygon.getTextureCoordIndices().get(i));
                }
            }
            if (keepThis == keepNext) continue;
            Point3d v0 = polygon.getVertex(i);
            Point3d v1 = polygon.getVertex(iNext);
            double t = plane.parametricLineIntersection(v0, v1);
            Point3d clipVertex = new Point3d();
            clipVertex.interpolate((Tuple3d)v0, (Tuple3d)v1, t);
            newVertexIndices.add(this._vertices.size());
            this._vertices.add(clipVertex);
            if (newVertexColorIndices != null) {
                Color3f clipColor = new Color3f();
                clipColor.interpolate(polygon.getVertexColor(i), polygon.getVertexColor(iNext), (float)t);
                newVertexColorIndices.add(this._colors.size());
                this._colors.add(clipColor);
            }
            if (newTextureCoordIndices == null) continue;
            Point3d clipTextureCoords = new Point3d();
            clipTextureCoords.interpolate((Tuple3d)polygon.getTextureCoords(i), (Tuple3d)polygon.getTextureCoords(iNext), t);
            newTextureCoordIndices.add(this._textureCoordinates.size());
            this._textureCoordinates.add(clipTextureCoords);
        }
        polygon.setVertexIndices(newVertexIndices);
        polygon.setVertexColorIndices(newVertexColorIndices);
        polygon.setTextureCoordIndices(newTextureCoordIndices);
        return true;
    }

    private Edge findParallelEdge(int vertexIndex, Edge edge, boolean outgoing, boolean sameDirection) {
        Vector3d directionVector = edge.getEdgeVector(new Vector3d());
        directionVector.normalize();
        Vector3d edgeVector = new Vector3d();
        for (Edge otherEdge : this._edgesByVertex.getAll(vertexIndex)) {
            boolean otherEdgeIsOutgoing;
            boolean bl = otherEdgeIsOutgoing = otherEdge.getVertex0Index() == vertexIndex;
            if (otherEdge == edge || otherEdgeIsOutgoing != outgoing) continue;
            otherEdge.getEdgeVector(edgeVector);
            edgeVector.normalize();
            if (!MathUtils.epsilonEquals(edgeVector.dot(directionVector), sameDirection ? 1.0 : -1.0, 0.001)) continue;
            return otherEdge;
        }
        return null;
    }

    private void invalidateEdges() {
        this._allEdges = null;
    }

    private void updateEdges() {
        if (this._allEdges == null) {
            this._allEdges = new ArrayList<Edge>();
            this._edgesByVertex = new MultiHashMap();
            for (Polygon3D polygon : this._polygons) {
                List<Integer> indices = polygon.getVertexIndices();
                for (int i = 1; i < indices.size(); ++i) {
                    int vertex0Index = indices.get(i - 1);
                    int vertex1Index = indices.get(i);
                    this.addEdge(polygon, vertex0Index, vertex1Index);
                }
                this.addEdge(polygon, indices.get(indices.size() - 1), indices.get(0));
            }
        }
    }

    private void addEdge(Polygon3D polygon, int vertex0Index, int vertex1Index) {
        Edge edge = this.getEdge(vertex0Index, vertex1Index);
        if (edge == null) {
            edge = new Edge(this._vertices, vertex0Index, vertex1Index);
            this._edgesByVertex.putLast(vertex0Index, edge);
            this._edgesByVertex.putLast(vertex1Index, edge);
            this._allEdges.add(edge);
        }
        if (edge.getVertex0Index() == vertex0Index) {
            edge.setPoly0To1(polygon);
        }
        if (edge.getVertex1Index() == vertex0Index) {
            edge.setPoly1To0(polygon);
        }
    }
}

