/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.render.mesh.Path;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.MultiHashMap;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.VectorUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class MeshUtils {
    public static Filter<Edge> ACCEPT_ANY_EDGE = new Filter<Edge>(){

        @Override
        public boolean accept(Edge value) {
            return true;
        }
    };

    public static PolyMesh3D getTransformedMesh(PolyMesh3D inputMesh, Transform3D transform) {
        ArrayList<Point3d> outputVertices = new ArrayList<Point3d>(inputMesh.getVertices().size());
        for (Point3d inputVertex : inputMesh.getVertices()) {
            Point3d outputVertex = new Point3d(inputVertex);
            transform.transform(outputVertex);
            outputVertices.add(outputVertex);
        }
        PolyMesh3D outputMesh = new PolyMesh3D(inputMesh.getIdentifier(), outputVertices, CollectionUtils.copyList(inputMesh.getColors()), CollectionUtils.copyList(inputMesh.getTextureCoordinates()), CollectionUtils.copyList(inputMesh.getMaterials()));
        outputMesh.setAliases(inputMesh.getAliases());
        for (Polygon3D inputPolygon : inputMesh.getPolygons()) {
            Vector3d outputNormal = new Vector3d(inputPolygon.getNormal());
            transform.transform(outputNormal);
            outputNormal.normalize();
            outputMesh.addPolygonIndexed(CollectionUtils.copyList(inputPolygon.getVertexIndices()), CollectionUtils.copyList(inputPolygon.getVertexColorIndices()), CollectionUtils.copyList(inputPolygon.getTextureCoordIndices()), outputNormal, inputPolygon.getMaterialIndex());
        }
        return outputMesh;
    }

    public static List<PolyMesh3D> getTransformedMeshes(Collection<PolyMesh3D> inputMeshes, Transform3D transform) {
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>(inputMeshes.size());
        for (PolyMesh3D inputMesh : inputMeshes) {
            result.add(MeshUtils.getTransformedMesh(inputMesh, transform));
        }
        return result;
    }

    public static List<Path> getPaths(List<Point3d> vertices, Collection<Edge> edges, List<Path> result) {
        MultiHashMap<Integer, Edge> edgesByVertIndex = new MultiHashMap<Integer, Edge>();
        for (Edge edge : edges) {
            edgesByVertIndex.putLast(edge.getVertex0Index(), edge);
            edgesByVertIndex.putLast(edge.getVertex1Index(), edge);
        }
        while (!edgesByVertIndex.isEmpty()) {
            boolean extended;
            Edge edge;
            int index = (Integer)edgesByVertIndex.keySet().iterator().next();
            edge = (Edge)edgesByVertIndex.removeFirst(index);
            edgesByVertIndex.remove(edge.getVertex0Index(), edge);
            edgesByVertIndex.remove(edge.getVertex1Index(), edge);
            Path path = new Path(vertices);
            path.append(edge, true);
            do {
                Edge endEdge;
                extended = false;
                Edge startEdge = (Edge)edgesByVertIndex.getFirst(path.getFirstVertexIndex());
                if (startEdge != null) {
                    edgesByVertIndex.remove(startEdge.getVertex0Index(), startEdge);
                    edgesByVertIndex.remove(startEdge.getVertex1Index(), startEdge);
                    path.prepend(startEdge, true);
                    extended = true;
                }
                if ((endEdge = (Edge)edgesByVertIndex.getFirst(path.getLastVertexIndex())) == null) continue;
                edgesByVertIndex.remove(endEdge.getVertex0Index(), endEdge);
                edgesByVertIndex.remove(endEdge.getVertex1Index(), endEdge);
                path.append(endEdge, true);
                extended = true;
            } while (extended);
            path.shrinkLoop();
            result.add(path);
        }
        return result;
    }

    public static Map<Integer, Integer> consolidateVertices(List<Point3d> vertices, double weldThreshold, Set<GeometricAxis> axes) {
        MultiHashMap<Double, Integer> verticesByXValue = new MultiHashMap<Double, Integer>();
        HashMap<Integer, Integer> substitutionMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < vertices.size(); ++i) {
            Point3d vertex = vertices.get(i);
            double xFloor = Math.floor(vertex.x);
            boolean matchFound = false;
            for (Integer possibleMatchIndex : verticesByXValue.getAll(xFloor)) {
                Point3d possibleMatch = vertices.get(possibleMatchIndex);
                if (!VectorUtils.epsilonEquals(possibleMatch, vertex, weldThreshold, axes)) continue;
                substitutionMap.put(i, possibleMatchIndex);
                matchFound = true;
            }
            if (matchFound) continue;
            verticesByXValue.putLast(xFloor, i);
        }
        return substitutionMap;
    }

    public static List<PolyMesh3D> splitMesh(PolyMesh3D mesh, Filter<Edge> internalEdgeFilter, String idSeparator, List<PolyMesh3D> result) {
        if (idSeparator == null) {
            idSeparator = "";
        }
        ArrayList<Set<Polygon3D>> polyGroups = new ArrayList<Set<Polygon3D>>();
        MeshUtils.groupPolygons(mesh, internalEdgeFilter, polyGroups);
        int submeshIndex = 0;
        for (Set set : polyGroups) {
            String submeshId = submeshIndex == 0 ? mesh.getIdentifier() : mesh.getIdentifier() + idSeparator + submeshIndex;
            PolyMesh3D submesh = new PolyMesh3D(submeshId, mesh.getVertices(), mesh.getColors(), mesh.getTextureCoordinates(), mesh.getMaterials());
            for (Polygon3D submeshPolygon : set) {
                Polygon3D newPoly = submesh.addPolygonIndexed(submeshPolygon.getVertexIndices(), submeshPolygon.getVertexColorIndices(), submeshPolygon.getTextureCoordIndices(), submeshPolygon.getNormal(), submeshPolygon.getMaterialIndex());
                newPoly.setGroupIdentifier(submeshPolygon.getGroupIdentifier());
            }
            submesh.setAlternateVertices(mesh.getAlternateVertices());
            result.add(submesh);
            ++submeshIndex;
        }
        return result;
    }

    public static Collection<PolyMesh3D> splitMeshes(Collection<PolyMesh3D> meshes, Filter<Edge> internalEdgeFilter, String idSeparator, Collection<PolyMesh3D> result) {
        for (PolyMesh3D polyMesh3D : meshes) {
            result.addAll(MeshUtils.splitMesh(polyMesh3D, internalEdgeFilter, idSeparator, new ArrayList<PolyMesh3D>()));
        }
        return result;
    }

    public static void markPolygonGroups(PolyMesh3D mesh, Filter<Edge> internalEdgeFilter, String idPrefix) {
        ArrayList<Set<Polygon3D>> polyGroups = new ArrayList<Set<Polygon3D>>();
        MeshUtils.groupPolygons(mesh, internalEdgeFilter, polyGroups);
        int idNum = 0;
        for (Set set : polyGroups) {
            String id = Integer.toString(idNum++);
            for (Polygon3D polygon : set) {
                polygon.setGroupIdentifier(idPrefix == null ? id : idPrefix + id);
            }
        }
    }

    public static Collection<Set<Polygon3D>> groupPolygons(PolyMesh3D mesh, Filter<Edge> internalEdgeFilter, Collection<Set<Polygon3D>> result) {
        assert (mesh != null);
        assert (internalEdgeFilter != null);
        HashMap<Polygon3D, Set<Polygon3D>> adjacencyMap = new HashMap<Polygon3D, Set<Polygon3D>>();
        for (Polygon3D polygon : mesh.getPolygons()) {
            adjacencyMap.put(polygon, new HashSet());
        }
        for (Edge edge : mesh.getEdges()) {
            if (!internalEdgeFilter.accept(edge)) continue;
            Polygon3D poly0 = edge.getPoly0To1();
            Polygon3D poly1 = edge.getPoly1To0();
            if (poly0 == null || poly1 == null) continue;
            ((Set)adjacencyMap.get(poly0)).add(poly1);
            ((Set)adjacencyMap.get(poly1)).add(poly0);
        }
        class PolygonAssembler {
            PolygonAssembler() {
            }

            void assemble(Polygon3D startPolygon, Set<Polygon3D> polygons, Map<Polygon3D, Set<Polygon3D>> adjacencyMap) {
                polygons.add(startPolygon);
                Set<Polygon3D> adjacentPolys = adjacencyMap.remove(startPolygon);
                if (adjacentPolys != null) {
                    for (Polygon3D adjacentPoly : adjacentPolys) {
                        this.assemble(adjacentPoly, polygons, adjacencyMap);
                    }
                }
            }
        }
        PolygonAssembler assembler = new PolygonAssembler();
        while (!adjacencyMap.isEmpty()) {
            HashSet<Polygon3D> polygons = new HashSet<Polygon3D>();
            Polygon3D polygon = (Polygon3D)adjacencyMap.keySet().iterator().next();
            assembler.assemble(polygon, polygons, adjacencyMap);
            result.add(polygons);
        }
        return result;
    }

    public static BoundingBox3D getCombinedBounds(Collection<PolyMesh3D> meshes) {
        BoundingBox3D combinedBounds = null;
        for (PolyMesh3D polyMesh3D : meshes) {
            BoundingBox3D meshBounds = polyMesh3D.getBoundingBox();
            if (combinedBounds == null) {
                combinedBounds = meshBounds;
                continue;
            }
            combinedBounds.combine(meshBounds);
        }
        return combinedBounds;
    }

    public static void drawNumberedVertices(Graphics2D graphics, List<Point3d> vertices, Color color) {
        int index = 0;
        for (Point3d vertex : vertices) {
            MeshUtils.drawVertex(graphics, vertex, color, 3, "" + index);
            ++index;
        }
    }

    public static void drawNumberedVertices(Graphics2D graphics, PolyMesh3D mesh, Color color, Integer ... indices) {
        List<Integer> indicesList = indices == null ? null : Arrays.asList(indices);
        int index = 0;
        for (Point3d vertex : mesh.getVertices()) {
            if (mesh.isVertexUsed(index) && (indicesList == null || indicesList.contains(index))) {
                MeshUtils.drawVertex(graphics, vertex, color, 3, "" + index);
            }
            ++index;
        }
    }

    public static void drawNumberedVertices(Graphics2D graphics, PolyMesh3D mesh, Color color) {
        MeshUtils.drawNumberedVertices(graphics, mesh, color, null);
    }

    public static void drawVertex(Graphics2D graphics, Point3d vertex, Color color, int size, String label) {
        ImageUtils.drawVertex(graphics, new Point((int)vertex.getX(), (int)vertex.getY()), color, size, label);
    }

    private MeshUtils() {
    }
}

