/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.mesh;

import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Edge {
    private final List<Point3d> _vertices;
    private final int _vertex0Index;
    private final int _vertex1Index;
    private Polygon3D _poly0To1;
    private Polygon3D _poly1To0;
    private final double _length;

    public Edge(List<Point3d> vertices, int vertex0, int vertex1) {
        this._vertices = vertices;
        this._vertex0Index = vertex0;
        this._vertex1Index = vertex1;
        this._length = this.getEdgeVector(new Vector3d()).length();
    }

    public Point3d getVertex0() {
        return this._vertices.get(this._vertex0Index);
    }

    public Point3d getVertex1() {
        return this._vertices.get(this._vertex1Index);
    }

    public int getVertex0Index() {
        return this._vertex0Index;
    }

    public int getVertex1Index() {
        return this._vertex1Index;
    }

    public List<Point3d> getVertices() {
        return this._vertices;
    }

    public double getCreaseAngle() {
        if (this.getPoly0To1() == null || this.getPoly1To0() == null) {
            return 0.0;
        }
        Vector3d normal0 = this.getPoly0To1().getNormal();
        Vector3d normal1 = this.getPoly1To0().getNormal();
        double dotProduct = normal0.dot(normal1);
        double theta = Math.acos(MathUtils.clamp(dotProduct, -1.0, 1.0));
        return theta;
    }

    public Range<Double> getBoundingRange(GeometricAxis axis) {
        double v1;
        double v0 = VectorUtils.getComponent(this.getVertex0(), axis);
        return v0 < (v1 = VectorUtils.getComponent(this.getVertex1(), axis)) ? new Range<Double>(v0, v1) : new Range<Double>(v1, v0);
    }

    public boolean isPhysicalBoundaryEdge() {
        return this.getPoly1To0() == null != (this.getPoly0To1() == null);
    }

    public boolean isGroupBoundaryEdge() {
        if (this.getPoly1To0GroupId() == null) {
            return this.getPoly0To1GroupId() != null;
        }
        return !this.getPoly1To0GroupId().equals(this.getPoly0To1GroupId());
    }

    public Polygon3D getPoly0To1() {
        return this._poly0To1;
    }

    public Polygon3D getPoly1To0() {
        return this._poly1To0;
    }

    public String getPoly0To1GroupId() {
        return this._poly0To1 == null ? null : this._poly0To1.getGroupIdentifier();
    }

    public String getPoly1To0GroupId() {
        return this._poly1To0 == null ? null : this._poly1To0.getGroupIdentifier();
    }

    public boolean samePolygon(Edge other) {
        if (this.getPoly0To1() != null && (this.getPoly0To1() == other.getPoly0To1() || this.getPoly0To1() == other.getPoly1To0())) {
            return true;
        }
        return this.getPoly1To0() != null && (this.getPoly1To0() == other.getPoly0To1() || this.getPoly1To0() == other.getPoly1To0());
    }

    public boolean connectsTo(Edge other) {
        return this.getVertex0Index() == other.getVertex0Index() || this.getVertex0Index() == other.getVertex1Index() || this.getVertex1Index() == other.getVertex0Index() || this.getVertex1Index() == other.getVertex1Index();
    }

    public void setPoly0To1(Polygon3D poly0To1) {
        this._poly0To1 = poly0To1;
    }

    public void setPoly1To0(Polygon3D poly1To0) {
        this._poly1To0 = poly1To0;
    }

    public double getLength() {
        return this._length;
    }

    public Vector3d getEdgeVector(Vector3d result) {
        result.sub(this.getVertex1(), this.getVertex0());
        return result;
    }

    public Vector3d getReverseEdgeVector(Vector3d result) {
        result.sub(this.getVertex0(), this.getVertex1());
        return result;
    }

    public int getOtherVertexIndex(int vertexIndex) {
        return vertexIndex == this._vertex0Index ? this._vertex1Index : this._vertex0Index;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._vertex0Index + "->" + this._vertex1Index + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._vertex0Index;
        result = 31 * result + this._vertex1Index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this._vertex0Index != other._vertex0Index) {
            return false;
        }
        if (this._vertex1Index != other._vertex1Index) {
            return false;
        }
        return this._vertices == other._vertices;
    }
}

