/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.MatchPattern;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class SceneLayer {
    public static String ELEMENT_NAME = "layer";
    public static String ID_ATTR_NAME = "id";
    public static String REF_MESH_ID_ATTR_NAME = "reference_mesh_id";
    public static DocumentNodeDecoder<SceneLayer> DECODER = new DocumentNodeDecoder<SceneLayer>(){

        @Override
        public SceneLayer decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            List<MatchPattern> matchPatterns = XMLUtils.decodeChildren(node, MatchPattern.DECODER);
            return new SceneLayer(attributes.get(ID_ATTR_NAME), attributes.get(REF_MESH_ID_ATTR_NAME), matchPatterns);
        }
    };
    private final String id;
    private final String referenceMeshID;
    private final List<MatchPattern> matchPatterns;

    public SceneLayer(String id, String referenceMeshID, List<MatchPattern> matchPatterns) {
        this.id = id;
        this.referenceMeshID = referenceMeshID;
        this.matchPatterns = matchPatterns;
    }

    public String getID() {
        return this.id;
    }

    public String getReferenceMeshId() {
        if (this.referenceMeshID == null) {
            return "REF" + this.id;
        }
        return this.referenceMeshID;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }

    public Filter<String> getMeshFilter(Map<String, String> substitutionTable) {
        return MatchPattern.createMeshFilter(this.matchPatterns, substitutionTable);
    }
}

