/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Point3d;

public class RenderImageProperty
extends Enum<RenderImageProperty> {
    public static final /* enum */ RenderImageProperty LAYER_IDS = new RenderImageProperty("output.layerIDs", (Class)List.class, (Object)new ArrayList()){

        @Override
        public Object decodeNonNullValue(String encoded) {
            return Arrays.asList(encoded.split(","));
        }

        @Override
        public String encodeNonNullValue(Object value) {
            return StringUtils.toDelimitedList((Iterable)value, ",");
        }
    };
    public static final /* enum */ RenderImageProperty PROJECTED_BOUNDS = new RenderImageProperty("output.projectedBounds", (Class)Rectangle4d.class, (Object)RenderControl.CAMERA_VIEWPORT){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty REFERENCE_RECTANGLE = new RenderImageProperty("output.referenceRectangle", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty REFERENCE_BOUNDS = new RenderImageProperty("output.referenceBounds3D", (Class)BoundingBox3D.class, (Object)null){

        @Override
        public Object decodeNonNullValue(String encoded) {
            double[] values = StringUtils.decodeDoubleArray(encoded, ",");
            assert (values.length == 6) : "Wrong number of values: " + values.length;
            return new BoundingBox3D(new Point3d(values[0], values[1], values[2]), new Point3d(values[3], values[4], values[5]));
        }

        @Override
        public String encodeNonNullValue(Object value) {
            BoundingBox3D box = (BoundingBox3D)value;
            Point3d upper = new Point3d();
            Point3d lower = new Point3d();
            box.getUpper(upper);
            box.getLower(lower);
            double[] values = new double[]{lower.x, lower.y, lower.z, upper.x, upper.y, upper.z};
            return StringUtils.toDelimitedList(values, ",");
        }
    };
    public static final /* enum */ RenderImageProperty IMAGE_OFFSET = new RenderImageProperty("output.imageOffset", (Class)Point.class, (Object)new Point(0, 0)){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return StringUtils.decodePoint(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return StringUtils.encodePoint((Point)value);
        }
    };
    public static final /* enum */ RenderImageProperty IMAGE_RECT = new RenderImageProperty("output.imageRect", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty SOLID_IMAGE_RECT = new RenderImageProperty("output.solidImageRect", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty CAMERA_TRANSFORM = new RenderImageProperty("output.cameraTransform", (Class)Transform3D.class, (Object)null){

        @Override
        public Object decodeNonNullValue(String encoded) {
            double[] values = StringUtils.decodeDoubleArray(encoded, ",");
            return new Transform3D(values);
        }

        @Override
        public String encodeNonNullValue(Object value) {
            double[] values = new double[16];
            ((Transform3D)value).get(values);
            return StringUtils.toDelimitedList(values, ",");
        }
    };
    public static final /* enum */ RenderImageProperty NEAR_CLIP_DISTANCE = new RenderImageProperty("output.nearClipDistance", (Class)Double.class, (Object)1.0){

        @Override
        public Object decodeNonNullValue(String encoded) {
            return Double.valueOf(encoded);
        }

        @Override
        public String encodeNonNullValue(Object value) {
            return Double.toString((Double)value);
        }
    };
    public static final /* enum */ RenderImageProperty HOTSPOT_0_ID = new RenderImageProperty("output.hotspot0ID", String.class, null);
    public static final /* enum */ RenderImageProperty HOTSPOT_0_BOUNDS = new RenderImageProperty("output.hotspot0Bounds", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty HOTSPOT_1_ID = new RenderImageProperty("output.hotspot1ID", String.class, null);
    public static final /* enum */ RenderImageProperty HOTSPOT_1_BOUNDS = new RenderImageProperty("output.hotspot1Bounds", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty HOTSPOT_2_ID = new RenderImageProperty("output.hotspot2ID", String.class, null);
    public static final /* enum */ RenderImageProperty HOTSPOT_2_BOUNDS = new RenderImageProperty("output.hotspot2Bounds", (Class)Rectangle4d.class, (Object)null){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return new Rectangle4d(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Rectangle4d)value).encode();
        }
    };
    public static final /* enum */ RenderImageProperty SUBSTITUTED = new RenderImageProperty("output.substituted", (Class)Boolean.class, (Object)false){

        @Override
        protected Object decodeNonNullValue(String encoded) {
            return Boolean.valueOf(encoded);
        }

        @Override
        protected String encodeNonNullValue(Object value) {
            return ((Boolean)value).toString();
        }
    };
    public static RenderImageProperty[] HOTSPOT_ID_PROPERTIES;
    public static RenderImageProperty[] HOTSPOT_BOUNDS_PROPERTIES;
    private final String propertyName;
    private final Class<?> propertyType;
    private final Object defaultValue;
    private static final /* synthetic */ RenderImageProperty[] $VALUES;

    public static RenderImageProperty[] values() {
        return (RenderImageProperty[])$VALUES.clone();
    }

    public static RenderImageProperty valueOf(String name) {
        return Enum.valueOf(RenderImageProperty.class, name);
    }

    public static Properties toProperties(Map<RenderImageProperty, String> enumMap) {
        Properties result = new Properties();
        for (Map.Entry<RenderImageProperty, String> entry : enumMap.entrySet()) {
            if (entry.getValue() == null) continue;
            result.setProperty(entry.getKey().getPropertyName(), entry.getValue());
        }
        return result;
    }

    public static Map<RenderImageProperty, String> fromProperties(Properties properties) {
        EnumMap<RenderImageProperty, String> result = new EnumMap<RenderImageProperty, String>(RenderImageProperty.class);
        for (RenderImageProperty property : RenderImageProperty.values()) {
            String key = property.getPropertyName();
            if (!properties.containsKey(key)) continue;
            result.put(property, properties.getProperty(key));
        }
        return result;
    }

    public String encodeValue(Object value) {
        assert (value == null || this.getPropertyType().isAssignableFrom(value.getClass())) : "Wrong value type";
        return value == null ? null : this.encodeNonNullValue(value);
    }

    public <T> T decodeValue(String encoded, Class<T> valueType) {
        assert (valueType.equals(this.getPropertyType())) : "Wrong value type";
        if (encoded == null) {
            return null;
        }
        Object decoded = this.decodeNonNullValue(encoded);
        return valueType.cast(decoded);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private RenderImageProperty(String localPropertyName, Class<?> type, Object defaultValue) {
        assert (localPropertyName != null);
        this.propertyName = ((Object)((Object)this)).getClass().getPackage().getName() + "." + localPropertyName;
        this.propertyType = type;
        this.defaultValue = defaultValue;
    }

    protected String encodeNonNullValue(Object value) {
        return value.toString();
    }

    protected Object decodeNonNullValue(String encoded) {
        return encoded;
    }

    static {
        $VALUES = new RenderImageProperty[]{LAYER_IDS, PROJECTED_BOUNDS, REFERENCE_RECTANGLE, REFERENCE_BOUNDS, IMAGE_OFFSET, IMAGE_RECT, SOLID_IMAGE_RECT, CAMERA_TRANSFORM, NEAR_CLIP_DISTANCE, HOTSPOT_0_ID, HOTSPOT_0_BOUNDS, HOTSPOT_1_ID, HOTSPOT_1_BOUNDS, HOTSPOT_2_ID, HOTSPOT_2_BOUNDS, SUBSTITUTED};
        HOTSPOT_ID_PROPERTIES = new RenderImageProperty[]{HOTSPOT_0_ID, HOTSPOT_1_ID, HOTSPOT_2_ID};
        HOTSPOT_BOUNDS_PROPERTIES = new RenderImageProperty[]{HOTSPOT_0_BOUNDS, HOTSPOT_1_BOUNDS, HOTSPOT_2_BOUNDS};
    }
}

