/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class MatchPattern {
    public static String ELEMENT_NAME = "match_pattern";
    public static String REGEX_ATTR_NAME = "regex";
    public static String NEGATE_ATTR_NAME = "negate";
    public static String SUBSTITUTE_ATTR_NAME = "substitute";
    public static DocumentNodeDecoder<MatchPattern> DECODER = new DocumentNodeDecoder<MatchPattern>(){

        @Override
        public MatchPattern decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String regex = attributes.get(REGEX_ATTR_NAME);
            boolean negate = Boolean.valueOf(attributes.get(NEGATE_ATTR_NAME));
            boolean substitute = Boolean.valueOf(attributes.get(SUBSTITUTE_ATTR_NAME));
            return new MatchPattern(regex, negate, substitute);
        }
    };
    public static MatchPattern MATCH_ANY = new MatchPattern(".*", false, false);
    private final Pattern pattern;
    private final boolean isNegated;
    private final boolean substitute;

    public static Filter<String> createMeshFilter(final Iterable<MatchPattern> patterns, final Map<String, String> substitutionTable) {
        return new Filter<String>(){

            @Override
            public boolean accept(String value) {
                for (MatchPattern matchPattern : patterns) {
                    if (matchPattern.matches(value, substitutionTable)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public MatchPattern(String regex, boolean isNegated, boolean substitute) {
        this.pattern = Pattern.compile(regex);
        this.isNegated = isNegated;
        this.substitute = substitute;
    }

    public boolean matches(String str, Map<String, String> substitutionTable) {
        String matchStr = this.substitute && substitutionTable != null ? substitutionTable.get(str) : str;
        if (matchStr == null) {
            return false;
        }
        return this.pattern.matcher(matchStr).matches() != this.isNegated;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.pattern + "]";
    }
}

