/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.RenderImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LayeredRenderImage {
    public static final String FILE_EXTENSION = "zip";
    private final String name;
    private RenderImage masterImage;
    private final Map<String, RenderImage> layerImages;

    public LayeredRenderImage(String name, Map<String, RenderImage> layerImages) {
        this.name = name;
        this.layerImages = layerImages;
    }

    public RenderImage getMasterImage() {
        return this.masterImage;
    }

    public RenderImage getLayerImage(String layerID) {
        return this.layerImages.get(layerID);
    }

    public void store() throws IOException {
        String filename = FileUtils.addExtension(this.name, FILE_EXTENSION);
        FileOutputStream ostream = new FileOutputStream(new File(RenderResourceIO.getInstance().getImageOutputDir(), filename));
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(ostream));
        for (Map.Entry<String, RenderImage> entry : this.layerImages.entrySet()) {
            String subFilename = FileUtils.addExtension(entry.getKey(), FILE_EXTENSION);
            zipOut.putNextEntry(new ZipEntry(subFilename));
            RenderImage renderImage = entry.getValue();
            renderImage.store(zipOut);
            zipOut.closeEntry();
        }
        zipOut.close();
    }
}

