/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.CameraImporter;
import com.sodiumarc.patchwork.render.control.CameraInterpolator;
import com.sodiumarc.patchwork.render.control.EdgeAppearance;
import com.sodiumarc.patchwork.render.control.FillAppearance;
import com.sodiumarc.patchwork.render.control.ImageOutput;
import com.sodiumarc.patchwork.render.control.ImageOutputProperties;
import com.sodiumarc.patchwork.render.control.MatchPattern;
import com.sodiumarc.patchwork.render.control.MeshSubstitution;
import com.sodiumarc.patchwork.render.control.SceneLayer;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InputScene {
    public static String DEFAULT_ID = "default";
    public static String ELEMENT_NAME = "scene";
    public static String ID_ATTR_NAME = "id";
    public static String FILE_ATTR_NAME = "file";
    public static String AUTO_IMAGES_ATTR_NAME = "auto_images";
    public static final String RENDER_NAMESPACE = "render";
    public static final String LOGICAL_NAMESPACE = "logical";
    public static final String REFERENCE_MESH_PREFIX = "REF";
    public static final String HOTSPOT_MESH_PREFIX = "HOTSPOT";
    public static final String CAMERA_PREFIX = "CAM";
    public static final String FRAME_PREFIX = "FRAME";
    public static DocumentNodeDecoder<InputScene> DECODER = new DocumentNodeDecoder<InputScene>(){

        @Override
        public InputScene decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String id = attributes.get(ID_ATTR_NAME);
            String fileName = attributes.get(FILE_ATTR_NAME);
            List<FillAppearance> fillAppearances = XMLUtils.decodeChildren(node, FillAppearance.DECODER);
            List<EdgeAppearance> edgeAppearances = XMLUtils.decodeChildren(node, EdgeAppearance.DECODER);
            List<ImageOutput> viewports = XMLUtils.decodeChildren(node, ImageOutput.DECODER);
            List<SceneLayer> layers = XMLUtils.decodeChildren(node, SceneLayer.DECODER);
            List<MeshSubstitution> substitutions = XMLUtils.decodeChildren(node, MeshSubstitution.DECODER);
            List<MatchPattern> matchPatterns = XMLUtils.decodeChildren(node, MatchPattern.DECODER);
            MeshSubstitution substitution = substitutions.isEmpty() ? null : substitutions.get(0);
            InputScene result = new InputScene(id, fileName, substitution, matchPatterns, fillAppearances, edgeAppearances, viewports, layers);
            result.setAutoCreateImages(Boolean.valueOf(attributes.get(AUTO_IMAGES_ATTR_NAME)));
            result.setCameraInterpolators(XMLUtils.decodeChildren(node, CameraInterpolator.DECODER));
            result.setCameraImporters(XMLUtils.decodeChildren(node, CameraImporter.DECODER));
            result.setImageOutputProperties(XMLUtils.decodeChildren(node, ImageOutputProperties.DECODER));
            return result;
        }
    };
    private final String id;
    private final String filename;
    private final List<FillAppearance> fillAppearances;
    private final List<EdgeAppearance> edgeAppearances;
    private final Map<String, ImageOutput> imageOutputsByID;
    private final MeshSubstitution meshSubstitution;
    private final List<MatchPattern> matchPatterns;
    private final Map<String, SceneLayer> layersByID;
    private boolean autoCreateImages;
    private final List<CameraInterpolator> cameraInterpolators;
    private final List<CameraImporter> cameraImporters;
    private final List<ImageOutputProperties> imageOutputProperties;
    private SceneGraph sceneGraph;
    private boolean loaded;

    public static Set<String> getLocalSceneIDs(Document document) {
        Element docNode = document.getDocumentElement();
        List<String> sceneLocalIDs = XMLUtils.decodeChildren((Node)docNode, new DocumentNodeDecoder<String>(){

            @Override
            public String decode(Node node) {
                if (!node.getLocalName().equals(ELEMENT_NAME)) {
                    return null;
                }
                return XMLUtils.getAttributes(node).get(ID_ATTR_NAME);
            }
        });
        return new HashSet<String>(sceneLocalIDs);
    }

    public static String getInputFilename(Document document, String sceneLocalID) {
        Element docNode = document.getDocumentElement();
        final String fixedLocalID = sceneLocalID == null ? DEFAULT_ID : sceneLocalID;
        List<String> inputFilenames = XMLUtils.decodeChildren((Node)docNode, new DocumentNodeDecoder<String>(){

            @Override
            public String decode(Node node) {
                if (!node.getLocalName().equals(ELEMENT_NAME)) {
                    return null;
                }
                String id = XMLUtils.getAttributes(node).get(ID_ATTR_NAME);
                if (!id.equals(fixedLocalID)) {
                    return null;
                }
                return XMLUtils.getAttributes(node).get(FILE_ATTR_NAME);
            }
        });
        return CollectionUtils.first(inputFilenames);
    }

    public static Map<String, InputScene> loadFromFile(String filename) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, InputScene> result = new HashMap<String, InputScene>();
        Document document = RenderResourceIO.getInstance().getXMLDocument(filename);
        Element docNode = document.getDocumentElement();
        for (InputScene input : XMLUtils.decodeChildren((Node)docNode, DECODER)) {
            result.put(input.getID(), input);
        }
        return result;
    }

    public void loadData() throws SAXException, IOException, ParserConfigurationException {
        if (this.loaded) {
            return;
        }
        COLLADA inputRoot = RenderResourceIO.getInstance().getCOLLADA(this.filename);
        this.sceneGraph = new COLLADALoader().load(inputRoot);
        this.sceneGraph.setAnimationFraction(0.0);
        this.sceneGraph.cleanMeshes(0.001);
        this.sceneGraph.splitNoncontiguousMeshes();
        Collection<PolyMesh3D> meshesInGlobalCoords = this.sceneGraph.getMeshesInGlobalCoords().values();
        if (this.meshSubstitution != null) {
            this.meshSubstitution.initSubstitutionTable(meshesInGlobalCoords, 0.5);
        }
        for (CameraImporter importer : this.cameraImporters) {
            importer.addCameras(this.sceneGraph);
        }
        for (CameraInterpolator interpolator : this.cameraInterpolators) {
            interpolator.addCameras(this.sceneGraph);
        }
        if (this.layersByID.isEmpty()) {
            this.autoCreateLayers();
        }
        if (this.autoCreateImages) {
            this.autoCreateImages();
        }
        this.loaded = true;
    }

    public String getID() {
        return this.id;
    }

    public SceneGraph getSceneGraph() {
        this.verifyLoaded();
        return this.sceneGraph;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<SceneLayer> getLayers(ImageOutput output) {
        ArrayList<SceneLayer> result = new ArrayList<SceneLayer>();
        Set<String> layerIDs = output.getProperties().getLayerIDs();
        for (SceneLayer layer : this.layersByID.values()) {
            if (layerIDs != null && !layerIDs.contains(layer.getID())) continue;
            result.add(layer);
        }
        this.sortLayersByDistance(output, result);
        return result;
    }

    public SceneLayer getLayer(ImageOutput output, String layerID) {
        for (SceneLayer layer : this.getLayers(output)) {
            if (!layer.getID().equals(layerID)) continue;
            return layer;
        }
        return null;
    }

    public List<ImageOutput> getImageOutputs() {
        if (this.autoCreateImages) {
            this.verifyLoaded();
        }
        return new ArrayList<ImageOutput>(this.imageOutputsByID.values());
    }

    public ImageOutput getImageOutput(String id) {
        if (this.autoCreateImages) {
            this.verifyLoaded();
        }
        return this.imageOutputsByID.get(id);
    }

    public boolean isAutoCreateImages() {
        return this.autoCreateImages;
    }

    public Set<String> getMeshIDs() {
        this.verifyLoaded();
        Set<String> unfiltered = this.meshSubstitution.isHideUnmatched() ? this.meshSubstitution.getMatchedIDs() : this.sceneGraph.getMeshIDs();
        Filter<String> filter = MatchPattern.createMeshFilter(this.matchPatterns, this.meshSubstitution.getSubstitutionTable());
        return (Set)CollectionUtils.filter(unfiltered, filter, new HashSet());
    }

    public Collection<PolyMesh3D> getMeshes(ImageOutput output, SceneLayer layer) {
        this.verifyLoaded();
        if (output == null || layer == null) {
            return Collections.emptySet();
        }
        Set<String> layerIDs = output.getProperties().getLayerIDs();
        if (layerIDs != null && !layerIDs.contains(layer.getID())) {
            return Collections.emptySet();
        }
        Map<String, String> substitutionTable = this.meshSubstitution.getSubstitutionTable();
        Set<String> meshIDs = this.getMeshIDs();
        meshIDs = (Set<String>)CollectionUtils.filter(meshIDs, layer.getMeshFilter(substitutionTable), new HashSet(meshIDs.size()));
        meshIDs = (Set)CollectionUtils.filter(meshIDs, output.getProperties().getMeshFilter(substitutionTable), new HashSet(meshIDs.size()));
        if (this.meshSubstitution != null) {
            meshIDs = this.meshSubstitution.substitute(meshIDs);
        }
        ArrayList<PolyMesh3D> result = new ArrayList<PolyMesh3D>(meshIDs.size());
        for (String meshID : meshIDs) {
            PolyMesh3D meshInCameraCoords = this.sceneGraph.getMeshInCameraCoords(meshID, output.getCameraID());
            if (meshInCameraCoords == null) continue;
            result.add(meshInCameraCoords);
        }
        return result;
    }

    public PolyMesh3D getReferenceMesh(ImageOutput output) {
        this.verifyLoaded();
        if (output == null) {
            return null;
        }
        String referenceMeshID = output.getReferenceMeshId();
        if (referenceMeshID == null) {
            for (SceneLayer layer : this.getLayers(output)) {
                if (layer.getReferenceMeshId() == null) continue;
                referenceMeshID = layer.getReferenceMeshId();
            }
        }
        if (referenceMeshID == null) {
            return null;
        }
        return this.sceneGraph.getMeshInCameraCoords(referenceMeshID, output.getCameraID());
    }

    public PolyMesh3D getReferenceMesh(ImageOutput output, String layerID) {
        this.verifyLoaded();
        SceneLayer layer = this.layersByID.get(layerID);
        if (layer == null) {
            return null;
        }
        PolyMesh3D result = this.sceneGraph.getMeshInCameraCoords(layer.getReferenceMeshId(), output.getCameraID());
        if (result == null) {
            Logger.getLogger(this.getClass()).warn("Reference mesh not found: " + layer.getReferenceMeshId());
        }
        return result;
    }

    public PolyMesh3D getFrameMesh(ImageOutput output) {
        this.verifyLoaded();
        String frameMeshID = null;
        String patternStr = output.getFrameMeshPattern();
        Camera camera = this.sceneGraph.getCamera(output.getCameraID());
        if (patternStr != null && camera != null) {
            Set<PolyMesh3D> frameMeshes = camera.getDescendantMeshesMatching(patternStr);
            if (frameMeshes.size() == 0) {
                Logger.getLogger(this.getClass()).warn("Frame mesh not found for output " + output.getID());
            } else {
                if (frameMeshes.size() > 1) {
                    Logger.getLogger(this.getClass()).warn("Multiple matching frame meshes found for output " + output.getID());
                }
                frameMeshID = CollectionUtils.first(frameMeshes).getIdentifier();
            }
        }
        return this.sceneGraph.getMeshInCameraCoords(frameMeshID, output.getCameraID());
    }

    public Map<String, PolyMesh3D> getHotspotMeshes(ImageOutput output) {
        HashMap<String, PolyMesh3D> result = new HashMap<String, PolyMesh3D>();
        Camera camera = this.sceneGraph.getCamera(output.getCameraID());
        if (camera == null) {
            return result;
        }
        String idPrefix = camera.getId() + ";" + HOTSPOT_MESH_PREFIX;
        for (PolyMesh3D hotspotMesh : camera.getDescendantMeshesMatching(idPrefix + ".*")) {
            String hotspotID = hotspotMesh.getIdentifier().substring(idPrefix.length());
            PolyMesh3D meshGlobal = this.sceneGraph.getMeshInGlobalCoords(hotspotMesh.getIdentifier());
            result.put(hotspotID, camera.toCameraCoords(meshGlobal));
        }
        return result;
    }

    public Map<String, FillAppearance> getFillAppearanceByMeshID(ImageOutput output) {
        this.verifyLoaded();
        ArrayList<FillAppearance> allApps = new ArrayList<FillAppearance>(output.getProperties().getFillAppearances());
        allApps.addAll(this.fillAppearances);
        HashMap<String, FillAppearance> result = new HashMap<String, FillAppearance>();
        Map<String, String> substitutionTable = this.meshSubstitution.getSubstitutionTable();
        block0: for (String meshID : this.getMeshIDs()) {
            for (FillAppearance appearance : allApps) {
                if (!appearance.getMeshFilter(substitutionTable).accept(meshID)) continue;
                result.put(this.meshSubstitution.substitute(meshID), appearance);
                continue block0;
            }
        }
        return result;
    }

    public Map<String, EdgeAppearance> getEdgeAppearanceByMeshID(ImageOutput output) {
        this.verifyLoaded();
        ArrayList<EdgeAppearance> allApps = new ArrayList<EdgeAppearance>(output.getProperties().getEdgeAppearances());
        allApps.addAll(this.edgeAppearances);
        HashMap<String, EdgeAppearance> result = new HashMap<String, EdgeAppearance>();
        Map<String, String> substitutionTable = this.meshSubstitution.getSubstitutionTable();
        block0: for (String meshID : this.getMeshIDs()) {
            for (EdgeAppearance appearance : allApps) {
                if (!appearance.getMeshFilter(substitutionTable).accept(meshID)) continue;
                result.put(this.meshSubstitution.substitute(meshID), appearance);
                continue block0;
            }
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    private InputScene(String id, String fileName, MeshSubstitution meshSubstitution, List<MatchPattern> matchPatterns, List<FillAppearance> fillAppearances, List<EdgeAppearance> edgeAppearances, List<ImageOutput> imageOutputs, List<SceneLayer> layers) {
        this.id = id;
        this.filename = fileName;
        this.meshSubstitution = meshSubstitution == null ? new MeshSubstitution("", "", false) : meshSubstitution;
        this.matchPatterns = matchPatterns;
        this.fillAppearances = fillAppearances;
        this.edgeAppearances = edgeAppearances;
        this.cameraInterpolators = new ArrayList<CameraInterpolator>();
        this.cameraImporters = new ArrayList<CameraImporter>();
        this.imageOutputProperties = new ArrayList<ImageOutputProperties>();
        this.layersByID = new LinkedHashMap<String, SceneLayer>();
        for (SceneLayer layer : layers) {
            this.layersByID.put(layer.getID(), layer);
        }
        this.imageOutputsByID = new LinkedHashMap<String, ImageOutput>();
        for (ImageOutput image : imageOutputs) {
            image.setScene(this);
            this.imageOutputsByID.put(image.getID(), image);
        }
    }

    private void setAutoCreateImages(boolean autoGenerateImages) {
        this.autoCreateImages = autoGenerateImages;
    }

    private void setCameraInterpolators(List<CameraInterpolator> cameraInterpolators) {
        this.cameraInterpolators.clear();
        this.cameraInterpolators.addAll(cameraInterpolators);
    }

    private void setCameraImporters(List<CameraImporter> cameraImporters) {
        this.cameraImporters.clear();
        this.cameraImporters.addAll(cameraImporters);
    }

    private void setImageOutputProperties(List<ImageOutputProperties> imageOutputProperties) {
        this.imageOutputProperties.clear();
        this.imageOutputProperties.addAll(imageOutputProperties);
        this.updateImageOutputProperties();
    }

    private void verifyLoaded() {
        assert (this.loaded) : "Data not loaded for " + this.getID();
    }

    private void autoCreateLayers() {
        Pattern idPattern = Pattern.compile("REF[^;]*");
        TreeSet<String> refMeshIDs = new TreeSet<String>();
        for (String id : this.sceneGraph.getMeshIDs()) {
            if (!idPattern.matcher(id).matches()) continue;
            refMeshIDs.add(id);
        }
        for (String meshID : refMeshIDs) {
            String layerID = meshID.substring(REFERENCE_MESH_PREFIX.length());
            MatchPattern matchPattern = new MatchPattern(meshID + ";.*", false, false);
            SceneLayer layer = new SceneLayer(layerID, meshID, Collections.singletonList(matchPattern));
            this.layersByID.put(layerID, layer);
        }
    }

    private void autoCreateImages() {
        Pattern cameraPattern = Pattern.compile("CAM[^;]*");
        for (Map.Entry<String, Camera> entry : this.sceneGraph.getCameras().entrySet()) {
            String framePrefix;
            String cameraID = entry.getKey();
            if (!cameraPattern.matcher(cameraID).matches()) continue;
            Camera camera = entry.getValue();
            Set<PolyMesh3D> frameMeshes = camera.getDescendantMeshesMatching((framePrefix = cameraID + ";" + FRAME_PREFIX) + "[^;]*");
            boolean addFrameSuffix = frameMeshes.size() > 1;
            for (PolyMesh3D frameMesh : frameMeshes) {
                String meshID = frameMesh.getIdentifier();
                String imageID = cameraID.substring(CAMERA_PREFIX.length());
                if (addFrameSuffix) {
                    imageID = imageID + "_" + meshID.substring(framePrefix.length());
                }
                if (this.imageOutputsByID.containsKey(imageID)) continue;
                ImageOutput output = new ImageOutput(imageID, cameraID, meshID);
                output.setScene(this);
                this.imageOutputsByID.put(imageID, output);
            }
        }
        this.updateImageOutputProperties();
    }

    private void updateImageOutputProperties() {
        block0: for (ImageOutput imageOutput : this.imageOutputsByID.values()) {
            for (ImageOutputProperties properties : this.imageOutputProperties) {
                if (imageOutput.hasExplicitProperties() || !properties.matches(imageOutput)) continue;
                imageOutput.setProperties(properties);
                continue block0;
            }
        }
    }

    private void sortLayersByDistance(final ImageOutput output, List<SceneLayer> layers) {
        Comparator<SceneLayer> comparator = new Comparator<SceneLayer>(){

            @Override
            public int compare(SceneLayer o1, SceneLayer o2) {
                PolyMesh3D mesh1 = InputScene.this.getReferenceMesh(output, o1.getID());
                double distance1 = mesh1.getBoundingBox().getRange(GeometricAxis.Z).getMax();
                PolyMesh3D mesh2 = InputScene.this.getReferenceMesh(output, o2.getID());
                double distance2 = mesh2.getBoundingBox().getRange(GeometricAxis.Z).getMax();
                return Double.compare(distance1, distance2);
            }
        };
        Collections.sort(layers, comparator);
    }
}

