/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.control.Background;
import com.sodiumarc.patchwork.render.control.EdgeAppearance;
import com.sodiumarc.patchwork.render.control.FillAppearance;
import com.sodiumarc.patchwork.render.control.ImageOutput;
import com.sodiumarc.patchwork.render.control.MatchPattern;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class ImageOutputProperties {
    public static String ELEMENT_NAME = "image_properties";
    public static String IMAGE_PATTERN_ATTR_NAME = "image_pattern";
    public static String LAYERS_ATTR_NAME = "layers";
    public static String SOLID_REGION_ATTR_NAME = "solid_region";
    public static String FADE_MARGIN_ATTR_NAME = "fade_margin";
    public static String RENDERED_ATTR_NAME = "rendered";
    public static String SIZE_ATTR_NAME = "size";
    public static String SUBSTITUTE_NAME = "substitute";
    public static String ORIGIN_NODE_ID_ATTR_NAME = "origin_node_id";
    public static DocumentNodeDecoder<ImageOutputProperties> DECODER = new DocumentNodeDecoder<ImageOutputProperties>(){

        @Override
        public ImageOutputProperties decode(Node node) {
            String sizeStr;
            String fadeMarginStr;
            String layersStr;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            ImageOutputProperties result = new ImageOutputProperties();
            String patternStr = attributes.get(IMAGE_PATTERN_ATTR_NAME);
            if (patternStr != null) {
                result.setImagePattern(Pattern.compile(patternStr));
            }
            if ((layersStr = attributes.get(LAYERS_ATTR_NAME)) != null) {
                HashSet<String> layerIDs = new HashSet<String>(Arrays.asList(layersStr.split(",")));
                result.setLayerIDs(layerIDs);
            }
            result.setMatchPatterns(XMLUtils.decodeChildren(node, MatchPattern.DECODER));
            result.setRendered(Boolean.valueOf(attributes.get(RENDERED_ATTR_NAME)));
            String solidRegionStr = attributes.get(SOLID_REGION_ATTR_NAME);
            if (solidRegionStr != null) {
                result.setSolidRegion(new Rectangle4d(solidRegionStr));
            }
            if ((fadeMarginStr = attributes.get(FADE_MARGIN_ATTR_NAME)) != null) {
                result.setFadeMargin(new Rectangle4d(fadeMarginStr));
            }
            if ((sizeStr = attributes.get(SIZE_ATTR_NAME)) != null) {
                String[] sizeParts = sizeStr.split(":");
                assert (sizeParts.length == 2) : "Wrong number of parts for " + SIZE_ATTR_NAME;
                result.setSize(StringUtils.decodeDimension(sizeParts[1]), SizeUnits.valueOf(sizeParts[0].toUpperCase()));
            }
            result.setBackground(CollectionUtils.first(XMLUtils.decodeChildren(node, Background.DECODER)));
            result.setFillAppearances(XMLUtils.decodeChildren(node, FillAppearance.DECODER));
            result.setEdgeAppearances(XMLUtils.decodeChildren(node, EdgeAppearance.DECODER));
            result.setSubstituted(Boolean.valueOf(attributes.get(SUBSTITUTE_NAME)));
            result.setOriginNodeID(attributes.get(ORIGIN_NODE_ID_ATTR_NAME));
            return result;
        }
    };
    private Pattern imagePattern = null;
    private boolean isRendered = true;
    private Dimension size = null;
    private SizeUnits sizeUnits = SizeUnits.PIXELS;
    private Rectangle4d solidRegion = null;
    private Rectangle4d fadeMargin = null;
    private final List<MatchPattern> matchPatterns = new ArrayList<MatchPattern>();
    private Set<String> layerIDs = null;
    private Background background = null;
    private List<FillAppearance> fillAppearances;
    private List<EdgeAppearance> edgeAppearances;
    private boolean substituted;
    private String originNodeId;

    public boolean matches(ImageOutput imageOutput) {
        if (this.imagePattern == null) {
            return false;
        }
        return this.imagePattern.matcher(imageOutput.getID()).matches();
    }

    public Set<String> getLayerIDs() {
        return this.layerIDs;
    }

    public List<MatchPattern> getMatchPatterns() {
        return this.matchPatterns;
    }

    public Dimension getSizeInPixels() {
        if (this.size == null) {
            return Card.CARD_DIMENSION;
        }
        if (this.sizeUnits == SizeUnits.CELLS) {
            return new Dimension(this.size.width * Card.CARD_SIZE, this.size.height * Card.CARD_SIZE);
        }
        return this.size;
    }

    public SizeUnits getSizeUnits() {
        return this.sizeUnits;
    }

    public Filter<String> getMeshFilter(Map<String, String> substitutionTable) {
        return MatchPattern.createMeshFilter(this.matchPatterns, substitutionTable);
    }

    public Background getBackground() {
        return this.background;
    }

    public Rectangle4d getSolidRegion() {
        return this.solidRegion;
    }

    public Rectangle4d getFadeMargin() {
        return this.fadeMargin;
    }

    public boolean isRendered() {
        return this.isRendered;
    }

    public List<FillAppearance> getFillAppearances() {
        if (this.fillAppearances == null) {
            return Collections.emptyList();
        }
        return this.fillAppearances;
    }

    public List<EdgeAppearance> getEdgeAppearances() {
        if (this.edgeAppearances == null) {
            return Collections.emptyList();
        }
        return this.edgeAppearances;
    }

    public boolean isSubstituted() {
        return this.substituted;
    }

    public String getOriginNodeID() {
        return this.originNodeId;
    }

    private void setImagePattern(Pattern imagePattern) {
        this.imagePattern = imagePattern;
    }

    private void setSolidRegion(Rectangle4d solidRegion) {
        this.solidRegion = solidRegion;
    }

    private void setFadeMargin(Rectangle4d fadeMargin) {
        this.fadeMargin = fadeMargin;
    }

    private void setSize(Dimension size, SizeUnits units) {
        this.size = size;
        this.sizeUnits = units;
    }

    private void setRendered(boolean isRendered) {
        this.isRendered = isRendered;
    }

    private void setBackground(Background background) {
        this.background = background;
    }

    private void setMatchPatterns(List<MatchPattern> matchPatterns) {
        this.matchPatterns.clear();
        if (matchPatterns != null) {
            this.matchPatterns.addAll(matchPatterns);
        }
    }

    private void setLayerIDs(Set<String> layerIDs) {
        this.layerIDs = layerIDs;
    }

    private void setFillAppearances(List<FillAppearance> fillAppearances) {
        this.fillAppearances = fillAppearances;
    }

    private void setEdgeAppearances(List<EdgeAppearance> edgeAppearances) {
        this.edgeAppearances = edgeAppearances;
    }

    private void setSubstituted(boolean substituted) {
        this.substituted = substituted;
    }

    private void setOriginNodeID(String originMeshId) {
        this.originNodeId = originMeshId;
    }

    public static enum SizeUnits {
        PIXELS,
        CELLS;

    }
}

