/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.InputSceneID;
import com.sodiumarc.patchwork.util.StringUtils;

public class ImageOutputID
implements Comparable<ImageOutputID> {
    private final InputSceneID sceneID;
    private final String imageLocalID;

    public static boolean isWellFormedID(String stringForm) {
        return StringUtils.isNonEmpty(stringForm);
    }

    public ImageOutputID(InputSceneID sceneID, String imageLocalID) {
        this.sceneID = sceneID;
        this.imageLocalID = imageLocalID;
    }

    public ImageOutputID(String stringForm) {
        int index = stringForm.lastIndexOf(".");
        assert (index != -1) : "malformed image output id: " + stringForm;
        this.sceneID = new InputSceneID(stringForm.substring(0, index));
        this.imageLocalID = stringForm.substring(index + 1);
    }

    public InputSceneID getSceneID() {
        return this.sceneID;
    }

    public String getImageLocalID() {
        return this.imageLocalID;
    }

    public String getStringForm() {
        return this.sceneID.getStringForm() + "." + this.imageLocalID;
    }

    public String toString() {
        return this.getStringForm();
    }

    @Override
    public int compareTo(ImageOutputID o) {
        return this.getStringForm().compareTo(o.getStringForm());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imageLocalID == null ? 0 : this.imageLocalID.hashCode());
        result = 31 * result + (this.sceneID == null ? 0 : this.sceneID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageOutputID other = (ImageOutputID)obj;
        if (this.imageLocalID == null ? other.imageLocalID != null : !this.imageLocalID.equals(other.imageLocalID)) {
            return false;
        }
        return !(this.sceneID == null ? other.sceneID != null : !this.sceneID.equals(other.sceneID));
    }
}

