/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.ImageOutputProperties;
import com.sodiumarc.patchwork.render.control.InputScene;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.Map;
import org.w3c.dom.Node;

public class ImageOutput {
    public static String ELEMENT_NAME = "image";
    public static String ID_ATTR_NAME = "id";
    public static String CAMERA_ID_ATTR_NAME = "camera_id";
    public static String FRAME_PATTERN_ATTR_NAME = "frame_pattern";
    public static String REF_MESH_ID_ATTR_NAME = "reference_mesh_id";
    public static String FILE_ATTR_NAME = "file";
    public static String BLOWUP_OF_ATTR_NAME = "blowup_of";
    public static DocumentNodeDecoder<ImageOutput> DECODER = new DocumentNodeDecoder<ImageOutput>(){

        @Override
        public ImageOutput decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            ImageOutputProperties properties = CollectionUtils.first(XMLUtils.decodeChildren(node, ImageOutputProperties.DECODER));
            return new ImageOutput(attributes.get(ID_ATTR_NAME), attributes.get(CAMERA_ID_ATTR_NAME), attributes.get(FRAME_PATTERN_ATTR_NAME), attributes.get(REF_MESH_ID_ATTR_NAME), attributes.get(BLOWUP_OF_ATTR_NAME), properties);
        }
    };
    private final String id;
    private final String cameraID;
    private final String frameMeshPattern;
    private final String referenceMeshID;
    private final String filename;
    private final String blowupOfImageID;
    private ImageOutputProperties properties;
    private InputScene scene;

    ImageOutput(String id, String cameraID, String frameMeshID) {
        this(id, cameraID, frameMeshID, null, null, null);
    }

    ImageOutput(String id, String cameraID, String frameMeshID, String referenceMeshID, String blowupOfImageID, ImageOutputProperties properties) {
        this.id = id;
        this.cameraID = cameraID;
        this.frameMeshPattern = frameMeshID;
        this.referenceMeshID = referenceMeshID;
        this.filename = null;
        this.properties = properties;
        this.blowupOfImageID = blowupOfImageID;
    }

    public String getID() {
        return this.id;
    }

    public String getCameraID() {
        if (this.cameraID == null) {
            return this.getDefaultCameraID();
        }
        return this.cameraID;
    }

    public String getFrameMeshPattern() {
        if (this.frameMeshPattern == null) {
            return this.getDefaultFrameMeshPattern();
        }
        return this.frameMeshPattern;
    }

    @Deprecated
    public String getReferenceMeshId() {
        return this.referenceMeshID;
    }

    public String getFilename() {
        return this.filename;
    }

    public ImageOutputProperties getProperties() {
        if (this.properties == null) {
            return new ImageOutputProperties();
        }
        return this.properties;
    }

    public void setProperties(ImageOutputProperties properties) {
        assert (!this.hasExplicitProperties()) : "Properties explicitly specified";
        this.properties = properties;
    }

    public boolean hasExplicitProperties() {
        return this.properties != null;
    }

    public Rectangle4d getBaseViewport() {
        if (this.scene == null) {
            return RenderControl.BLENDER_VIEWPORT;
        }
        Camera camera = this.scene.getSceneGraph().getCamera(this.getCameraID());
        PolyMesh3D frameMesh = this.scene.getFrameMesh(this);
        return frameMesh == null ? RenderControl.BLENDER_VIEWPORT : camera.getProjectedBounds(frameMesh);
    }

    public Rectangle4d getBaseImageRect() {
        return new Rectangle4d(this.getProperties().getSizeInPixels());
    }

    public Rectangle4d getSolidViewport() {
        Rectangle4d viewport = this.getBaseViewport();
        Rectangle4d solidRegionProportional = this.getProperties().getSolidRegion();
        if (solidRegionProportional == null) {
            return viewport;
        }
        return viewport.fromProportional(solidRegionProportional);
    }

    public Rectangle4d getSolidImageRect() {
        Rectangle4d viewport = this.getBaseViewport();
        Rectangle4d solidProportional = viewport.toProportional(this.getSolidViewport());
        return this.getBaseImageRect().fromProportional(solidProportional);
    }

    public Rectangle4d getTotalViewport() {
        Rectangle4d viewport = this.getBaseViewport();
        Rectangle4d solidViewport = this.getSolidViewport();
        Rectangle4d fadeMarginProportional = this.getProperties().getFadeMargin();
        if (fadeMarginProportional == null) {
            return solidViewport;
        }
        return solidViewport.combine(viewport.fromProportional(fadeMarginProportional));
    }

    public Rectangle4d getTotalImageRect() {
        Rectangle4d viewport = this.getBaseViewport();
        Rectangle4d totalProportional = viewport.toProportional(this.getTotalViewport());
        return this.getBaseImageRect().fromProportional(totalProportional);
    }

    public String getBlowupOfImageID() {
        return this.blowupOfImageID;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    void setScene(InputScene scene) {
        this.scene = scene;
    }

    private String getDefaultCameraID() {
        String[] idParts = this.id.split("_");
        return "CAM" + idParts[0];
    }

    private String getDefaultFrameMeshPattern() {
        String[] idParts = this.id.split("_");
        if (idParts.length == 2) {
            return ".*FRAME" + idParts[1] + ".*";
        }
        return ".*FRAME.*";
    }
}

