/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class ImageFill {
    public static String ELEMENT_NAME = "image_fill";
    public static String IMAGE_ATTR_NAME = "image";
    public static String IS_RENDER_ATTR_NAME = "is_render";
    public static String BOUNDS_ATTR_NAME = "bounds";
    public static DocumentNodeDecoder<ImageFill> DECODER = new DocumentNodeDecoder<ImageFill>(){

        @Override
        public ImageFill decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String imageName = attributes.get(IMAGE_ATTR_NAME);
            boolean isRenderImage = Boolean.valueOf(attributes.get(IS_RENDER_ATTR_NAME));
            String boundsStr = attributes.get(BOUNDS_ATTR_NAME);
            Rectangle bounds = boundsStr == null ? null : StringUtils.decodeRectangle(boundsStr);
            return new ImageFill(imageName, isRenderImage, bounds);
        }
    };
    private final String imageName;
    private final boolean isRenderImage;
    private final Rectangle bounds;
    private boolean imageLoaded;
    private BufferedImage image;

    public ImageFill(String imageName, boolean isRenderImage, Rectangle bounds) {
        this.imageName = imageName;
        this.isRenderImage = isRenderImage;
        this.bounds = bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public BufferedImage getImage() {
        if (!this.imageLoaded) {
            if (this.isRenderImage) {
                RenderControl renderControl = RenderControl.getInstance();
                RenderImage renderImage = null;
                try {
                    renderImage = ImageOutputLayerID.isWellFormedID(this.imageName) ? renderControl.getRenderImage(new ImageOutputLayerID(this.imageName), RenderControl.RenderCondition.NEVER) : renderControl.getRenderImage(new ImageOutputID(this.imageName), RenderControl.RenderCondition.NEVER);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Failed to load fill image: " + this.imageName, e);
                }
                if (renderImage != null) {
                    this.image = renderImage.getImage();
                }
            } else {
                RenderResourceIO resourceIO = RenderResourceIO.getInstance();
                try {
                    this.image = resourceIO.getInputImage(this.imageName);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass()).warn("Failed to load fill image: " + this.imageName, e);
                }
            }
            this.imageLoaded = true;
        }
        return this.image;
    }

    public BufferedImage apply(BufferedImage input, Point inputOffset) {
        BufferedImage fillImage = this.getImage();
        if (fillImage == null) {
            return input;
        }
        fillImage = this.bounds != null ? ImageUtils.scale(fillImage, this.bounds.width, this.bounds.height) : ImageUtils.scale(fillImage, input.getWidth(), input.getWidth());
        Graphics2D graphics = (Graphics2D)input.getGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, input.getWidth(), input.getHeight());
        graphics.setComposite(AlphaComposite.Src);
        if (this.bounds != null) {
            graphics.drawImage((Image)fillImage, this.bounds.x - inputOffset.x, this.bounds.y - inputOffset.y, null);
        } else {
            graphics.drawImage((Image)fillImage, 0, 0, null);
        }
        graphics.dispose();
        return input;
    }
}

