/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.AppearanceFilter;
import com.sodiumarc.patchwork.render.control.ImageFill;
import com.sodiumarc.patchwork.render.control.KnownImageFilter;
import com.sodiumarc.patchwork.render.control.MatchPattern;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class FillAppearance {
    public static String ELEMENT_NAME = "fill_app";
    public static String RENDERED_ATTR_NAME = "rendered";
    public static String ERASE_ATTR_NAME = "erase";
    public static FillAppearance DEFAULT_INSTANCE = new FillAppearance(Collections.singletonList(MatchPattern.MATCH_ANY), null, Collections.singletonList(new AppearanceFilter(KnownImageFilter.SKETCH)), true, false);
    public static DocumentNodeDecoder<FillAppearance> DECODER = new DocumentNodeDecoder<FillAppearance>(){

        @Override
        public FillAppearance decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            List<MatchPattern> matchPatterns = XMLUtils.decodeChildren(node, MatchPattern.DECODER);
            List<AppearanceFilter> filters = XMLUtils.decodeChildren(node, AppearanceFilter.DECODER);
            ImageFill imageFill = CollectionUtils.first(XMLUtils.decodeChildren(node, ImageFill.DECODER));
            return new FillAppearance(matchPatterns, imageFill, filters, Boolean.valueOf(attributes.get(RENDERED_ATTR_NAME)), Boolean.valueOf(attributes.get(ERASE_ATTR_NAME)));
        }
    };
    private final List<MatchPattern> matchPatterns;
    private final List<AppearanceFilter> filters;
    private final ImageFill imageFill;
    private final boolean rendered;
    private final boolean erase;

    public boolean isRendered() {
        return this.rendered;
    }

    public boolean isErase() {
        return this.erase;
    }

    public boolean isBillboard() {
        return this.imageFill != null;
    }

    public BufferedImage applyFilters(BufferedImage input, Point inputOffset) {
        BufferedImage result = input;
        if (this.imageFill != null) {
            result = this.imageFill.apply(result, inputOffset);
        }
        for (AppearanceFilter filter : this.filters) {
            result = filter.apply(result);
        }
        return result;
    }

    public Filter<String> getMeshFilter(Map<String, String> substitutionTable) {
        return MatchPattern.createMeshFilter(this.matchPatterns, substitutionTable);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.matchPatterns;
    }

    private FillAppearance(List<MatchPattern> matchPatterns, ImageFill imageFill, List<AppearanceFilter> filters, boolean rendered, boolean erase) {
        this.matchPatterns = matchPatterns;
        this.rendered = rendered;
        this.erase = erase;
        this.filters = filters;
        this.imageFill = imageFill;
    }
}

