/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.LineStyle;
import com.sodiumarc.patchwork.render.control.MatchPattern;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class EdgeAppearance {
    public static String ELEMENT_NAME = "edge_app";
    public static String RENDERED_ATTR_NAME = "rendered";
    public static String SPLIT_ANGLE_ATTR_NAME = "split_angle";
    public static String DRAW_ANGLE_ATTR_NAME = "draw_angle";
    public static String LINE_STYLE_ELEMENT_NAME = "line_style";
    public static String TYPE_ATTR_NAME = "type";
    public static String COLOR_ATTR_NAME = "color";
    public static String WIDTH_ATTR_NAME = "width";
    public static String STYLE_NAME_ATTR_NAME = "style_name";
    public static EdgeAppearance DEFAULT_INSTANCE = new EdgeAppearance(Collections.singletonList(MatchPattern.MATCH_ANY), new EnumMap<EdgeType, LineStyle>(EdgeType.class), true, 1.5, 1.5);
    public static DocumentNodeDecoder<EdgeAppearance> DECODER = new DocumentNodeDecoder<EdgeAppearance>(){

        @Override
        public EdgeAppearance decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            EnumMap<EdgeType, LineStyle> styleMap = new EnumMap<EdgeType, LineStyle>(EdgeType.class);
            for (Node child : XMLUtils.getChildElements(node, LINE_STYLE_ELEMENT_NAME)) {
                Map<String, String> attributes = XMLUtils.getAttributes(child);
                EdgeType type = EdgeType.valueOf(attributes.get(TYPE_ATTR_NAME).toUpperCase());
                Color color = ColorUtils.decodeHexString(attributes.get(COLOR_ATTR_NAME));
                float width = Float.valueOf(attributes.get(WIDTH_ATTR_NAME)).floatValue();
                LineStyle style = new LineStyle(color, width, attributes.get(STYLE_NAME_ATTR_NAME));
                styleMap.put(type, style);
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            List<MatchPattern> matchPatterns = XMLUtils.decodeChildren(node, MatchPattern.DECODER);
            return new EdgeAppearance(matchPatterns, styleMap, Boolean.valueOf(attributes.get(RENDERED_ATTR_NAME)), Double.valueOf(attributes.get(SPLIT_ANGLE_ATTR_NAME)), Double.valueOf(attributes.get(DRAW_ANGLE_ATTR_NAME)));
        }
    };
    private final List<MatchPattern> matchPatterns;
    private final boolean rendered;
    private final double splitAngle;
    private final double drawAngle;
    private final Map<EdgeType, LineStyle> styleMap;

    public boolean isRendered() {
        return this.rendered;
    }

    public double getSplitAngle() {
        return this.splitAngle;
    }

    public double getDrawAngle() {
        return this.drawAngle;
    }

    public LineStyle getStyle(EdgeType edgeType) {
        if (this.styleMap.containsKey((Object)edgeType)) {
            return this.styleMap.get((Object)edgeType);
        }
        return LineStyle.DEFAULT_BLACK;
    }

    public Filter<String> getMeshFilter(Map<String, String> substitutionTable) {
        return MatchPattern.createMeshFilter(this.matchPatterns, substitutionTable);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.matchPatterns;
    }

    private EdgeAppearance(List<MatchPattern> matchPatterns, Map<EdgeType, LineStyle> styleMap, boolean rendered, double splitAngle, double drawAngle) {
        this.matchPatterns = matchPatterns;
        this.rendered = rendered;
        this.splitAngle = splitAngle;
        this.drawAngle = drawAngle;
        this.styleMap = styleMap;
    }

    public static enum EdgeType {
        BOUNDARY,
        CREASE;

    }
}

