/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.render.control.CameraInterpolator;
import com.sodiumarc.patchwork.render.control.InputScene;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CameraImporter {
    public static final String ELEMENT_NAME = "import_cameras";
    public static final String FILE_ATTR_NAME = "file";
    public static final String SCENE_ID_ATTR_NAME = "scene_id";
    public static final String CAMERA_PATTERN = "camera_pattern";
    public static final String ALIGN_FROM_ID = "align_from_id";
    public static final String ALIGN_TO_ID = "align_to_id";
    public static DocumentNodeDecoder<CameraImporter> DECODER = new DocumentNodeDecoder<CameraImporter>(){

        @Override
        public CameraImporter decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(CameraImporter.ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            String importFilename = FileUtils.ensureExtension(attributes.get(CameraImporter.FILE_ATTR_NAME), "xml");
            String cameraPatternStr = attributes.get(CameraImporter.CAMERA_PATTERN);
            Pattern cameraPattern = cameraPatternStr == null ? null : Pattern.compile(cameraPatternStr);
            return new CameraImporter(importFilename, attributes.get(CameraImporter.SCENE_ID_ATTR_NAME), cameraPattern, attributes.get(CameraImporter.ALIGN_FROM_ID), attributes.get(CameraImporter.ALIGN_TO_ID));
        }
    };
    private final String importFilename;
    private final String importSceneID;
    private final Pattern cameraPattern;
    private final String alignFromID;
    private final String alignToID;
    private static final Logger LOGGER = Logger.getLogger(CameraInterpolator.class);

    public CameraImporter(String importFilename, String sceneID, Pattern cameraPattern, String alignFromID, String alignToID) {
        this.importFilename = importFilename;
        this.importSceneID = sceneID;
        this.cameraPattern = cameraPattern;
        this.alignFromID = alignFromID;
        this.alignToID = alignToID;
    }

    public void addCameras(SceneGraph sceneGraph) throws ParserConfigurationException, SAXException, IOException {
        Transform3D alignmentTransform;
        Map<String, InputScene> scenes;
        try {
            scenes = InputScene.loadFromFile(this.importFilename);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load import file: " + this.importFilename);
            return;
        }
        String sceneID = this.importSceneID == null ? InputScene.DEFAULT_ID : this.importSceneID;
        InputScene scene = scenes.get(sceneID);
        if (scene == null) {
            LOGGER.warn("Failed to to find scene for import: " + sceneID);
            return;
        }
        scene.loadData();
        Map<String, Camera> allCameras = scene.getSceneGraph().getCameras();
        HashMap<String, Camera> camerasToImport = new HashMap<String, Camera>();
        ArrayList<SceneGraphNode> nodesToImport = new ArrayList<SceneGraphNode>();
        for (Map.Entry<String, Camera> entry : allCameras.entrySet()) {
            String cameraID = entry.getKey();
            Camera camera = entry.getValue();
            if (this.cameraPattern != null && !this.cameraPattern.matcher(cameraID).matches()) continue;
            camerasToImport.put(cameraID, camera);
            nodesToImport.add(camera.getParent().cloneSubtree(true));
        }
        if (this.alignFromID != null && this.alignToID != null) {
            Camera alignFromCamera = (Camera)camerasToImport.get(this.alignFromID);
            assert (alignFromCamera != null) : "Camera not found for alignment: " + this.alignFromID;
            Camera alignToCamera = sceneGraph.getCamera(this.alignToID);
            assert (alignToCamera != null) : "Camera not found for alignment: " + this.alignToID;
            alignmentTransform = new Transform3D(alignToCamera.getCumulativeTransform());
            alignmentTransform.mul(alignFromCamera.getInverseTransform());
        } else {
            alignmentTransform = new Transform3D();
        }
        SceneGraphNode cameraParentNode = new SceneGraphNode("IMPORTED_CAMERAS", alignmentTransform, nodesToImport);
        sceneGraph.getRoot().addChild(cameraParentNode);
    }
}

