/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render.control;

import com.sodiumarc.patchwork.render.control.KnownImageFilter;
import com.sodiumarc.patchwork.util.image.ImageFilter;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class AppearanceFilter {
    public static String ELEMENT_NAME = "filter";
    public static String FILTER_ATTR_NAME = "name";
    public static DocumentNodeDecoder<AppearanceFilter> DECODER = new DocumentNodeDecoder<AppearanceFilter>(){

        @Override
        public AppearanceFilter decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            KnownImageFilter knownFilter = KnownImageFilter.valueOf(attributes.get(FILTER_ATTR_NAME).toUpperCase());
            ImageFilter imageFilter = knownFilter.getInstance();
            if (imageFilter != null) {
                return new AppearanceFilter(imageFilter, XMLUtils.childrenAsProperties(node, "name", "value"));
            }
            return null;
        }
    };
    private final ImageFilter filter;
    private final Properties properties;

    public AppearanceFilter(KnownImageFilter knownFilter) {
        this(knownFilter.getInstance(), new Properties());
    }

    public AppearanceFilter(ImageFilter filter, Properties properties) {
        this.filter = filter;
        this.properties = properties;
    }

    public BufferedImage apply(BufferedImage input) {
        return this.filter.apply(input, this.properties);
    }
}

