/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DeepImage;
import com.sodiumarc.patchwork.render.DepthFunction;
import com.sodiumarc.patchwork.render.DepthMap;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class WritableDeepImage
extends DeepImage {
    private final DepthMap depthMap;

    public static WritableDeepImage composeImages(List<DeepImage> images, WritableDeepImage destination) {
        return WritableDeepImage.composeImages(images, destination, -1);
    }

    public static WritableDeepImage composeImages(List<DeepImage> images, WritableDeepImage destination, int alphaThreshold) {
        if (destination == null) {
            RectangularShape combinedRect = null;
            for (DeepImage image : images) {
                Rectangle bounds = image.getBounds();
                if (combinedRect == null) {
                    combinedRect = bounds.getBounds2D();
                    continue;
                }
                combinedRect = ((Rectangle2D)combinedRect).createUnion(bounds);
            }
            if (combinedRect == null) {
                return null;
            }
            destination = new WritableDeepImage(combinedRect.getBounds());
        }
        for (DeepImage image : images) {
            destination.prepareForComposite(image);
        }
        Rectangle totalBounds = destination.getBounds();
        ArrayList<DeepImage> pendingImages = new ArrayList<DeepImage>(images);
        ArrayList<DeepImage> rowCrossingImages = new ArrayList<DeepImage>();
        ArrayList<DeepImage> activeImages = new ArrayList<DeepImage>();
        LocationDepthComparator comparator = new LocationDepthComparator();
        int n = totalBounds.y + totalBounds.height;
        for (int y = totalBounds.y; y < n; ++y) {
            Iterator iter = rowCrossingImages.iterator();
            while (iter.hasNext()) {
                DeepImage crossing = (DeepImage)iter.next();
                if (y < crossing.getOffset().y + crossing.getHeight()) continue;
                iter.remove();
            }
            iter = pendingImages.iterator();
            while (iter.hasNext()) {
                DeepImage pending = (DeepImage)iter.next();
                if (y < pending.getOffset().y) continue;
                iter.remove();
                rowCrossingImages.add(pending);
            }
            int m = totalBounds.x + totalBounds.width;
            for (int x = totalBounds.x; x < m; ++x) {
                Iterator iter2 = activeImages.iterator();
                while (iter2.hasNext()) {
                    DeepImage active = (DeepImage)iter2.next();
                    if (active.containsPoint(x, y)) continue;
                    iter2.remove();
                    rowCrossingImages.add(active);
                }
                iter2 = rowCrossingImages.iterator();
                while (iter2.hasNext()) {
                    DeepImage crossing = (DeepImage)iter2.next();
                    if (!crossing.containsPoint(x, y)) continue;
                    iter2.remove();
                    activeImages.add(crossing);
                }
                comparator.setLocation(x, y);
                Collections.sort(activeImages, comparator);
                for (DeepImage active : activeImages) {
                    destination.compositeColor(active, x, y, alphaThreshold, true);
                }
            }
        }
        return destination;
    }

    public WritableDeepImage(int width, int height) {
        super(new BufferedImage(width, height, 2), new DepthMap(width, height));
        this.depthMap = (DepthMap)this.getDepthFunction();
    }

    public WritableDeepImage(Dimension size) {
        this(size.width, size.height);
    }

    public WritableDeepImage(Rectangle bounds) {
        super(new BufferedImage(bounds.width, bounds.height, 2), new DepthMap(bounds.width, bounds.height));
        this.setOffset(bounds.getLocation());
        this.depthMap = (DepthMap)this.getDepthFunction();
    }

    public WritableDeepImage(BufferedImage image, DepthFunction depthFunction) {
        super(image, depthFunction);
        this.depthMap = (DepthMap)this.getDepthFunction();
    }

    public void compositeColor(int x, int y, double depth, int color, boolean isPremultiplied, int alphaThreshold, boolean overwrite) {
        if (!this.containsPoint(x, y)) {
            return;
        }
        if (alphaThreshold >= 0 && ColorUtils.getComponent(color, ColorComponent.ALPHA) < alphaThreshold) {
            return;
        }
        x = this.toLocalX(x);
        y = this.toLocalY(y);
        double oldDepth = this.depthMap.getDepth(x, y);
        int oldColor = this.getImage().getRGB(x, y);
        int resultColor = 0;
        resultColor = Double.isInfinite(oldDepth) ? color : (overwrite ? this.composite(color, oldColor, isPremultiplied) : (oldDepth >= depth ? this.composite(color, oldColor, isPremultiplied) : this.composite(oldColor, color, isPremultiplied)));
        if (resultColor != oldColor) {
            this.getImage().setRGB(x, y, resultColor);
        }
        if (depth < oldDepth) {
            this.depthMap.setDepth(x, y, depth);
        }
    }

    public void compositeColor(DeepImage source, int x, int y, int alphaThreshold, boolean overwrite) {
        double depth = source.getDepth(x, y);
        double oldDepth = this.depthMap.getDepth(x, y);
        if (oldDepth >= depth) {
            Point offset = this.getOffset();
            source.getHoleMap().applyTo(this.getImage(), offset.x, offset.y, x, y);
        }
        source.getHoleMap().applyTo(this.getHoleMap(), x, y);
        this.compositeColor(x, y, depth, source.getColor(x, y), source.isPremultiplied(), alphaThreshold, overwrite);
    }

    public void prepareForComposite(DeepImage source) {
        this.getHoleMap().prepareToAccept(source.getHoleMap());
    }

    public void compositeImage(DeepImage source, int alphaThreshold, boolean overwrite) {
        Point offset = source.getOffset();
        int n = offset.y + source.getHeight();
        for (int y = offset.y; y < n; ++y) {
            int m = offset.x + source.getWidth();
            for (int x = offset.x; x < m; ++x) {
                this.compositeColor(source, x, y, alphaThreshold, overwrite);
            }
        }
    }

    public void setHoleMapFromImage(boolean invert) {
        Point offset = this.getOffset();
        this.getHoleMap().setFrom(this.getImage(), offset.x, offset.y, invert);
    }

    public BufferedImage createDepthImage() {
        return this.depthMap.createDepthImage();
    }

    private int composite(int srcColor, int destColor, boolean isPremultiplied) {
        int srcAlpha = ColorUtils.getComponent(srcColor, ColorComponent.ALPHA);
        if (srcAlpha == 255) {
            return srcColor;
        }
        if (srcAlpha == 0) {
            return destColor;
        }
        if (!isPremultiplied) {
            srcColor = ColorUtils.toPremultiplied(srcColor);
            destColor = ColorUtils.toPremultiplied(destColor);
        }
        float a_s = (float)srcAlpha / 255.0f;
        float f_d = 1.0f - a_s;
        int result = 0;
        for (ColorComponent component : ColorComponent.values()) {
            int srcCompnent = ColorUtils.getComponent(srcColor, component);
            int destCompnent = ColorUtils.getComponent(destColor, component);
            int composite = (int)((float)srcCompnent + f_d * (float)destCompnent);
            result = ColorUtils.setComponent(result, component, composite);
        }
        if (!isPremultiplied) {
            result = ColorUtils.fromPremultplied(result);
        }
        return result;
    }

    public static class LocationDepthComparator
    implements Comparator<DeepImage> {
        private int x;
        private int y;

        @Override
        public int compare(DeepImage image0, DeepImage image1) {
            if (image0 == null) {
                return image1 == null ? 0 : -1;
            }
            if (image1 == null) {
                return 1;
            }
            double d0 = image0.getDepth(this.x, this.y);
            double d1 = image1.getDepth(this.x, this.y);
            return Double.compare(d1, d0);
        }

        public void setLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

