/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.RenderResourceIO;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class TextureMap {
    private String _name;
    private final BufferedImage _data;

    public TextureMap(String fileName) throws IOException {
        this._name = fileName;
        this._data = RenderResourceIO.getInstance().getInputImage(fileName);
    }

    public String getName() {
        return this._name;
    }

    public int getColor(double u, double v) {
        int vWrapped;
        int uWrapped = (int)Math.floor((double)this._data.getWidth() * u) % this._data.getWidth();
        if (uWrapped < 0) {
            uWrapped += this._data.getWidth();
        }
        if ((vWrapped = (int)Math.floor((double)this._data.getHeight() * v) % this._data.getHeight()) < 0) {
            vWrapped += this._data.getHeight();
        }
        return this._data.getRGB(uWrapped, vWrapped);
    }
}

