/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.render.RenderAppProperties;
import com.sodiumarc.patchwork.render.control.RenderImageProperty;
import com.sodiumarc.patchwork.util.ResourceIO;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RenderResourceIO
extends ResourceIO {
    public static final String OUTPUT_IMAGE_EXTENSION = "png";
    public static final String TEMP_IMAGE_EXTENSION = "png";
    public static final String PROPERTIES_EXTENSION = "properties";
    private final File imageInputDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.IMAGE_INPUT_DIR.getValue());
    private final File colladaInputDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.COLLADA_INPUT_DIR.getValue());
    private final File xmlInputDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.XML_INPUT_DIR.getValue());
    private final File imageOutputDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.IMAGE_OUTPUT_DIR.getValue());
    private final File layerOutputDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.LAYER_OUTPUT_DIR.getValue());
    private final File imageTempDir = new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.IMAGE_TEMP_DIR.getValue());
    private static final RenderResourceIO DEFAULT_INSTANCE = new RenderResourceIO();

    public static RenderResourceIO getInstance() {
        return DEFAULT_INSTANCE;
    }

    public BufferedImage getInputImage(String name) throws IOException {
        File file = new File(this.imageInputDir, name);
        return ImageIO.read(file);
    }

    public COLLADA getCOLLADA(String filename) throws IOException, SAXException, ParserConfigurationException {
        File inputFile = new File(this.colladaInputDir, filename);
        return COLLADA.fromFile(inputFile);
    }

    public Document getXMLDocument(String filename) throws IOException, ParserConfigurationException, SAXException {
        return XMLUtils.getXMLDocument(new File(this.xmlInputDir, filename), true);
    }

    public List<Document> getXMLDocuments() throws IOException, ParserConfigurationException, SAXException {
        return this.getXMLDocuments(this.xmlInputDir);
    }

    public void writeOutputImage(BufferedImage image, File directory, String filename) throws FileNotFoundException, IOException {
        filename = FileUtils.ensureExtension(filename, "png");
        File outputFile = new File(directory, filename);
        FileImageOutputStream fileOut = new FileImageOutputStream(outputFile);
        ImageIO.write((RenderedImage)image, FileUtils.getFileExtension(filename), fileOut);
        fileOut.close();
    }

    public BufferedImage getOutputImage(File directory, String name) throws IOException {
        String filename = FileUtils.ensureExtension(name, "png");
        File file = new File(directory, filename);
        if (!file.exists()) {
            return null;
        }
        return ImageIO.read(file);
    }

    public BufferedImage getSubstituteImage(String name) throws IOException {
        return this.getOutputImage(this.getSubstituteDir(), name);
    }

    public void writeTemporaryImage(BufferedImage image, String filename) throws FileNotFoundException, IOException {
        filename = FileUtils.ensureExtension(filename, "png");
        File outputFile = new File(this.imageTempDir, filename);
        ImageIO.write((RenderedImage)image, FileUtils.getFileExtension(filename), new FileImageOutputStream(outputFile));
    }

    public void writeOutputImageProperties(Properties properties, File outputDir, String filename) throws FileNotFoundException, IOException {
        File outputFile = new File(outputDir, FileUtils.ensureExtension(filename, PROPERTIES_EXTENSION));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        properties.store(writer, null);
        writer.close();
    }

    public Map<RenderImageProperty, String> getImageProperties(File directory, String imageName) throws FileNotFoundException, IOException {
        if (imageName == null) {
            return null;
        }
        File inputFile = new File(directory, FileUtils.addExtension(imageName, PROPERTIES_EXTENSION));
        if (!inputFile.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(inputFile));
        Properties properties = new Properties();
        properties.load(reader);
        reader.close();
        Map<RenderImageProperty, String> result = RenderImageProperty.fromProperties(properties);
        return result;
    }

    public File getLayerOutputDir() {
        return this.layerOutputDir;
    }

    public File getImageInputDir() {
        return this.imageInputDir;
    }

    public File getColladaInputDir() {
        return this.colladaInputDir;
    }

    public File getXmlInputDir() {
        return this.xmlInputDir;
    }

    public File getImageOutputDir() {
        return this.imageOutputDir;
    }

    public File getImageTempDir() {
        return this.imageTempDir;
    }

    public File getRawScanDir() {
        return new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.RAW_SCAN_DIR.getValue());
    }

    public File getProcessedScanDir() {
        return new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.PROCESSED_SCAN_DIR.getValue());
    }

    public File getSubstituteDir() {
        return new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.SUBSTITUTE_DIR.getValue());
    }

    public File getAnimInputDir() {
        return new File(RenderAppProperties.BASE_DIR.getValue(), RenderAppProperties.ANIM_INPUT_DIR.getValue());
    }

    private RenderResourceIO() {
    }
}

