/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DeepImage;
import com.sodiumarc.patchwork.render.EdgeProcessor;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.RenderShape;
import com.sodiumarc.patchwork.render.SketchEdgeRenderer;
import com.sodiumarc.patchwork.render.WritableDeepImage;
import com.sodiumarc.patchwork.render.control.EdgeAppearance;
import com.sodiumarc.patchwork.render.control.FillAppearance;
import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.PointLight;
import com.sodiumarc.patchwork.util.Filter;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class RenderObject {
    private final String identifier;
    private final Rectangle bounds;
    private final List<RenderShape> shapes;
    private final EdgeProcessor edgeProcessor;
    private final EdgeAppearance edgeAppearance;
    private final RenderQuality quality;
    private static final Logger LOGGER = Logger.getLogger(RenderObject.class);
    private static final Logger RENDER_IMAGE_LOGGER = Logger.getLogger(RenderObject.class.getCanonicalName() + "|render");
    private static final int EDGE_MARGIN = 5;

    public RenderObject(PolyMesh3D mesh, FillAppearance fillAppearance, EdgeAppearance edgeAppearance, RenderQuality quality) throws IOException {
        this.identifier = mesh.getIdentifier();
        this.edgeProcessor = new EdgeProcessor();
        this.edgeProcessor.processEdges(Collections.singleton(mesh));
        this.quality = quality;
        this.edgeAppearance = edgeAppearance == null ? EdgeAppearance.DEFAULT_INSTANCE : edgeAppearance;
        this.shapes = new ArrayList<RenderShape>();
        if (quality == RenderQuality.NICEST) {
            final double splitAngle = this.edgeAppearance.getSplitAngle();
            Filter<Edge> splitFilter = new Filter<Edge>(){

                @Override
                public boolean accept(Edge edge) {
                    return edge.getPoly0To1() != null && edge.getPoly1To0() != null && edge.getCreaseAngle() <= splitAngle;
                }
            };
            String idPrefix = mesh.getIdentifier() + ";";
            MeshUtils.markPolygonGroups(mesh, splitFilter, idPrefix);
            for (String groupId : mesh.getPolygonGroupIdentifiers()) {
                RenderShape shape = new RenderShape(mesh, groupId, this.edgeProcessor, fillAppearance, edgeAppearance);
                this.shapes.add(shape);
            }
        } else {
            mesh.setPolygonGroupdentifier(this.getIdentifier());
            RenderShape shape = new RenderShape(mesh, this.getIdentifier(), this.edgeProcessor, fillAppearance, edgeAppearance);
            this.shapes.add(shape);
        }
        RectangularShape combinedRect = null;
        for (RenderShape shape : this.shapes) {
            Rectangle shapeRect = shape.getBounds();
            if (combinedRect == null) {
                combinedRect = shapeRect.getBounds2D();
                continue;
            }
            combinedRect = ((Rectangle2D)combinedRect).createUnion(shapeRect);
        }
        this.bounds = combinedRect == null ? new Rectangle(0, 0, 0, 0) : combinedRect.getBounds();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Collection<DeepImage> draw(Collection<PointLight> lights, boolean drawFill, boolean drawEdges) throws IOException {
        Rectangle inflatedBounds = new Rectangle(this.bounds.x - 5, this.bounds.y - 5, this.bounds.width + 10, this.bounds.height + 10);
        WritableDeepImage composite = new WritableDeepImage(inflatedBounds);
        ArrayList<DeepImage> shapeImages = new ArrayList<DeepImage>();
        for (RenderShape shape : this.shapes) {
            DeepImage shapeImage = shape.draw(lights, drawFill ? this.quality : RenderQuality.FASTEST, !drawFill);
            if (shapeImage == null) continue;
            shapeImages.add(shapeImage);
        }
        composite.setName(this.getIdentifier());
        WritableDeepImage.composeImages(shapeImages, composite);
        if (RENDER_IMAGE_LOGGER.isDebugEnabled()) {
            this.writeDebugImage(this.getIdentifier() + "_RENDER", composite.getImage());
        }
        if (drawEdges) {
            SketchEdgeRenderer edgeRenderer = SketchEdgeRenderer.getDefaultInstance();
            double creaseAngle = this.edgeAppearance.getDrawAngle();
            edgeRenderer.drawPaths(composite, this.edgeProcessor.getCreasePaths(creaseAngle), this.edgeAppearance.getStyle(EdgeAppearance.EdgeType.CREASE));
            edgeRenderer.drawPaths(composite, this.edgeProcessor.getInternalSilhouettePaths(), this.edgeAppearance.getStyle(EdgeAppearance.EdgeType.BOUNDARY));
        }
        return Collections.singleton(composite);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.identifier + "]";
    }

    private void writeDebugImage(String imageName, BufferedImage image) {
        try {
            RenderResourceIO.getInstance().writeTemporaryImage(image, imageName);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Failed to write debug image: " + imageName, e);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write debug image: " + imageName, e);
        }
    }
}

