/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.mesh.Edge;
import com.sodiumarc.patchwork.render.mesh.MeshUtils;
import com.sodiumarc.patchwork.render.mesh.Path;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.mesh.Polygon3D;
import com.sodiumarc.patchwork.render.scenegraph.CoordinateSystem;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.ComparablePoint3d;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.Tuple3dComparator;
import com.sodiumarc.patchwork.util.VectorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class EdgeProcessor {
    private Map<MyEdge, EdgeSegmentInfo> _edgeInfoMap = new HashMap<MyEdge, EdgeSegmentInfo>();
    private static final Tuple3dComparator VERTEX_COMPARATOR = new Tuple3dComparator(GeometricAxis.Y, GeometricAxis.X, GeometricAxis.Z);

    public void processEdges(Collection<PolyMesh3D> projectedMeshes) {
        this._edgeInfoMap.clear();
        TreeMap<ComparablePoint3d, PointOfInterest> pointsOfInterest = new TreeMap<ComparablePoint3d, PointOfInterest>();
        ArrayList<MyEdge> activeEdges = new ArrayList<MyEdge>();
        ArrayList<Span> spanPairs = new ArrayList<Span>();
        for (PolyMesh3D projectedMesh : projectedMeshes) {
            for (Edge edge : projectedMesh.getEdges()) {
                MyEdge myEdge = new MyEdge(edge, projectedMesh);
                ComparablePoint3d location = new ComparablePoint3d(myEdge.getFirstVertex(), VERTEX_COMPARATOR);
                PointOfInterest poi = (PointOfInterest)pointsOfInterest.get(location);
                if (poi == null) {
                    poi = new PointOfInterest(myEdge);
                    pointsOfInterest.put(location, poi);
                    continue;
                }
                poi.addStartingEdge(myEdge);
            }
        }
        while (!pointsOfInterest.isEmpty()) {
            Point3d location = (Point3d)pointsOfInterest.firstKey();
            PointOfInterest poi = (PointOfInterest)pointsOfInterest.remove(location);
            Iterator iter = activeEdges.iterator();
            while (iter.hasNext()) {
                Edge edge;
                edge = (MyEdge)iter.next();
                if (!(((MyEdge)edge).getLastVertex().getY() <= poi.getLocation().getY())) continue;
                iter.remove();
                this.retireEdge((MyEdge)edge, spanPairs);
            }
            for (MyEdge newEdge : poi.getStartingEdges()) {
                this.addSpansForEdge(newEdge, activeEdges, spanPairs);
                this.addIntersectionsForEdge(newEdge, activeEdges, pointsOfInterest);
                activeEdges.add(newEdge);
            }
            for (MyEdge newEdge : poi.getStartingEdges()) {
                EdgeSegmentInfo edgeInfo = this.initEdgeInfo(newEdge, spanPairs);
                this._edgeInfoMap.put(newEdge, edgeInfo);
            }
            for (EdgeIntersection intersection : poi.getEdgeIntersections()) {
                this.processIntersection(intersection, this._edgeInfoMap);
            }
        }
    }

    public List<Path> getExternalSilhouettePaths() {
        EdgeSegmentFilter externalSilhouetteFilter = new EdgeSegmentFilter(){

            @Override
            public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontGroups, Collection<Polygon3D> backGroups) {
                return edge.isPhysicalBoundaryEdge() && frontGroups.size() == 0 && backGroups.size() == 0;
            }
        };
        return this.getPaths(externalSilhouetteFilter);
    }

    public List<Path> getInternalSilhouettePaths() {
        EdgeSegmentFilter internalSilhouetteFilter = new EdgeSegmentFilter(){

            @Override
            public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontGroups, Collection<Polygon3D> backGroups) {
                return edge.isPhysicalBoundaryEdge() && frontGroups.size() == 0;
            }
        };
        return this.getPaths(internalSilhouetteFilter);
    }

    public List<Path> getCreasePaths(final double creaseAngle) {
        EdgeSegmentFilter creaseFilter = new EdgeSegmentFilter(){

            @Override
            public boolean accept(Edge edge, Point3d segmentVertex0, Point3d segmentVertex1, Collection<Polygon3D> frontGroups, Collection<Polygon3D> backGroups) {
                return edge.getCreaseAngle() > creaseAngle && frontGroups.size() == 0;
            }
        };
        return this.getPaths(creaseFilter);
    }

    public List<Path> getPaths(EdgeSegmentFilter filter) {
        ArrayList<Path> result = new ArrayList<Path>();
        this.processEdgeInfo(this._edgeInfoMap, result, filter);
        return result;
    }

    private void retireEdge(MyEdge edge, List<Span> spans) {
        Iterator<Span> iter = spans.iterator();
        while (iter.hasNext()) {
            Span spanPair = iter.next();
            if (spanPair.getLeadingEdge() != edge && spanPair.getTrailingEdge() != edge) continue;
            iter.remove();
        }
    }

    private void processEdgeInfo(Map<MyEdge, EdgeSegmentInfo> edgeInfo, List<Path> paths, EdgeSegmentFilter filter) {
        ArrayList<Point3d> vertices = new ArrayList<Point3d>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Map.Entry<MyEdge, EdgeSegmentInfo> entry : edgeInfo.entrySet()) {
            EdgeSegmentInfo info = entry.getValue();
            List<Point3d> boundaryPoints = info.getBoundaryPoints();
            for (int i = 0; i < info.segmentCount(); ++i) {
                Point3d segVertex0 = boundaryPoints.get(i);
                Point3d segVertex1 = boundaryPoints.get(i + 1);
                if (!filter.accept(info.getEdge(), info.getBoundaryPointUnprojected(i), info.getBoundaryPointUnprojected(i + 1), info.getFrontGroups(i), info.getBackGroups(i))) continue;
                int index0 = vertices.size();
                vertices.add(segVertex0);
                int index1 = vertices.size();
                vertices.add(segVertex1);
                edges.add(new Edge(vertices, index0, index1));
            }
        }
        Map<Integer, Integer> substitutionMap = MeshUtils.consolidateVertices(vertices, 0.01, EnumSet.of(GeometricAxis.X, GeometricAxis.Y));
        ArrayList<Edge> consolidatedEdges = new ArrayList<Edge>(edges.size());
        for (Edge edge : edges) {
            Integer newVertex1Index;
            int oldVertex0Index = edge.getVertex0Index();
            int oldVertex1Index = edge.getVertex1Index();
            Integer newVertex0Index = substitutionMap.get(oldVertex0Index);
            if (newVertex0Index == null) {
                newVertex0Index = oldVertex0Index;
            }
            if ((newVertex1Index = substitutionMap.get(oldVertex1Index)) == null) {
                newVertex1Index = oldVertex1Index;
            }
            if (newVertex0Index == newVertex1Index) continue;
            if (newVertex0Index.intValue() != edge.getVertex0Index() || newVertex1Index.intValue() != edge.getVertex1Index()) {
                consolidatedEdges.add(new Edge(vertices, newVertex0Index, newVertex1Index));
                continue;
            }
            consolidatedEdges.add(edge);
        }
        MeshUtils.getPaths(vertices, consolidatedEdges, paths);
    }

    private EdgeSegmentInfo initEdgeInfo(MyEdge edge, List<Span> spans) {
        ArrayList<Polygon3D> frontPolys = new ArrayList<Polygon3D>();
        ArrayList<Polygon3D> backPolys = new ArrayList<Polygon3D>();
        Point3d firstVertex = edge.getFirstVertex();
        double slope = this.getSlope(edge);
        Range<Double> edgeRange = edge.getBoundingRange(GeometricAxis.X);
        HashMap<MyEdge, Point3d> crossingPoints = new HashMap<MyEdge, Point3d>();
        for (Span span : spans) {
            double edgeZ;
            double spanFraction;
            Point3d spanEndPoint;
            boolean connectsToTrailing;
            MyEdge leadingEdge = span.getLeadingEdge();
            MyEdge trailingEdge = span.getTrailingEdge();
            if (edge.samePolygon(leadingEdge) || edge.samePolygon(trailingEdge)) continue;
            Range<Double> leadingRange = leadingEdge.getBoundingRange(GeometricAxis.X);
            Range<Double> trailingRange = trailingEdge.getBoundingRange(GeometricAxis.X);
            if (leadingRange.getMin() > edgeRange.getMax() || trailingRange.getMax() < edgeRange.getMin()) continue;
            boolean connectsToLeading = firstVertex == leadingEdge.getFirstVertex();
            boolean bl = connectsToTrailing = firstVertex == trailingEdge.getFirstVertex();
            if (connectsToLeading || connectsToTrailing) {
                boolean insideTrailing;
                boolean insideLeading = !connectsToLeading || slope > this.getSlope(leadingEdge);
                boolean bl2 = insideTrailing = !connectsToTrailing || slope < this.getSlope(trailingEdge);
                if (!insideLeading || !insideTrailing) continue;
                Polygon3D spanPoly = span.getPolygon();
                Point3d planePoint = edge.getFirstVertexUnprojected();
                Point3d refPoint = edge.getLastVertexUnprojected();
                double distance = VectorUtils.pointPlaneDistance(refPoint, planePoint, spanPoly.getNormal());
                if (distance > 0.0) {
                    backPolys.add(spanPoly);
                    continue;
                }
                frontPolys.add(spanPoly);
                continue;
            }
            Point3d edgeRefPoint = firstVertex;
            Point3d spanStartPoint = (Point3d)crossingPoints.get(leadingEdge);
            if (spanStartPoint == null) {
                spanStartPoint = this.getYIntersection(leadingEdge, edgeRefPoint.getY(), true);
                crossingPoints.put(leadingEdge, spanStartPoint);
            }
            if ((spanEndPoint = (Point3d)crossingPoints.get(trailingEdge)) == null) {
                spanEndPoint = this.getYIntersection(trailingEdge, edgeRefPoint.getY(), true);
                crossingPoints.put(trailingEdge, spanEndPoint);
            }
            if (spanStartPoint == null || spanEndPoint == null || spanStartPoint.getX() >= spanEndPoint.getX() || !(0.0 <= (spanFraction = MathUtils.rangeFraction(edgeRefPoint.getX(), spanStartPoint.getX(), spanEndPoint.getX()))) || !(spanFraction <= 1.0)) continue;
            Point3d spanCrossPoint = VectorUtils.getLinePoint(spanStartPoint, spanEndPoint, spanFraction, new Point3d());
            double spanZ = spanCrossPoint.getZ();
            if (spanZ > (edgeZ = edgeRefPoint.getZ())) {
                backPolys.add(span.getPolygon());
                continue;
            }
            frontPolys.add(span.getPolygon());
        }
        return new EdgeSegmentInfo(edge, slope, frontPolys, backPolys);
    }

    private void addSpansForEdge(MyEdge newEdge, List<MyEdge> activeEdges, List<Span> spans) {
        Polygon3D leadingPoly = this.getLeadingPolygon(newEdge);
        Polygon3D trailingPoly = this.getTrailingPolygon(newEdge);
        for (MyEdge edge : activeEdges) {
            if (this.isHorizontal(edge)) continue;
            if (trailingPoly != null && trailingPoly == this.getLeadingPolygon(edge)) {
                spans.add(new Span(edge, newEdge, trailingPoly));
            }
            if (leadingPoly == null || leadingPoly != this.getTrailingPolygon(edge)) continue;
            spans.add(new Span(newEdge, edge, leadingPoly));
        }
    }

    private void addIntersectionsForEdge(MyEdge newEdge, List<MyEdge> activeEdges, Map<ComparablePoint3d, PointOfInterest> pointsOfInterest) {
        for (MyEdge activeEdge : activeEdges) {
            EdgeIntersection newIntersection;
            if (!this.canIntersect(newEdge, activeEdge) || (newIntersection = this.getXYIntersection(newEdge, activeEdge)) == null) continue;
            ComparablePoint3d location = new ComparablePoint3d(newIntersection.getNearEdgePoint(), VERTEX_COMPARATOR);
            PointOfInterest poi = pointsOfInterest.get(location);
            if (poi == null) {
                poi = new PointOfInterest(newIntersection);
                pointsOfInterest.put(location, poi);
                continue;
            }
            poi.addEdgeIntersection(newIntersection);
        }
    }

    private void processIntersection(EdgeIntersection intersection, Map<MyEdge, EdgeSegmentInfo> edgeInfoMap) {
        MyEdge nearEdge = intersection.getNearEdge();
        MyEdge farEdge = intersection.getFarEdge();
        EdgeSegmentInfo nearEdgeInfo = edgeInfoMap.get(nearEdge);
        EdgeSegmentInfo farEdgeInfo = edgeInfoMap.get(farEdge);
        this.updateEdgeAtBoundary(farEdgeInfo, nearEdgeInfo, intersection.getFarEdgePoint(), true);
        this.updateEdgeAtBoundary(nearEdgeInfo, farEdgeInfo, intersection.getNearEdgePoint(), false);
    }

    private void updateEdgeAtBoundary(EdgeSegmentInfo updateInfo, EdgeSegmentInfo boundaryInfo, Point3d intersection, boolean boundaryInFront) {
        boolean contained;
        MyEdge boundaryEdge = boundaryInfo.getEdge();
        boolean trailingIntoLeading = this.isHorizontal(boundaryEdge) ? true : updateInfo.getEdgeSlope() > boundaryInfo.getEdgeSlope();
        Polygon3D fromPoly = trailingIntoLeading ? this.getTrailingPolygon(boundaryEdge) : this.getLeadingPolygon(boundaryEdge);
        Polygon3D intoPoly = trailingIntoLeading ? this.getLeadingPolygon(boundaryEdge) : this.getTrailingPolygon(boundaryEdge);
        ArrayList<Polygon3D> polys = new ArrayList<Polygon3D>(boundaryInFront ? updateInfo.lastSegmentFrontGroups() : updateInfo.lastSegmentBackGroups());
        assert (fromPoly != null || intoPoly != null);
        if (fromPoly != null && !(contained = polys.remove(fromPoly))) {
            Logger.getLogger(this.getClass()).warn("missing poly: " + fromPoly + " for edge " + updateInfo.getEdge() + " crossing boundary edge " + boundaryEdge);
        }
        if (intoPoly != null) {
            polys.add(intoPoly);
        }
        if (boundaryInFront) {
            updateInfo.addSegment(intersection, polys, updateInfo.lastSegmentBackGroups());
        } else {
            updateInfo.addSegment(intersection, updateInfo.lastSegmentFrontGroups(), polys);
        }
    }

    private boolean canIntersect(Edge edge0, Edge edge1) {
        if (edge0.equals(edge1)) {
            return false;
        }
        if (edge0.samePolygon(edge1)) {
            return false;
        }
        return edge0.getVertex0() != edge1.getVertex0() && edge0.getVertex0() != edge1.getVertex1() && edge0.getVertex1() != edge1.getVertex0() && edge0.getVertex1() != edge1.getVertex1();
    }

    private EdgeIntersection getXYIntersection(MyEdge edge0, MyEdge edge1) {
        if (!edge0.getBoundingRange(GeometricAxis.X).overlaps(edge1.getBoundingRange(GeometricAxis.X))) {
            return null;
        }
        double e0x0 = edge0.getVertex0().getX();
        double e0y0 = edge0.getVertex0().getY();
        double e0x1 = edge0.getVertex1().getX();
        double e0y1 = edge0.getVertex1().getY();
        double e1x0 = edge1.getVertex0().getX();
        double e1y0 = edge1.getVertex0().getY();
        double e1x1 = edge1.getVertex1().getX();
        double e1y1 = edge1.getVertex1().getY();
        double t0 = ((e1x1 - e1x0) * (e0y0 - e1y0) - (e1y1 - e1y0) * (e0x0 - e1x0)) / ((e1y1 - e1y0) * (e0x1 - e0x0) - (e1x1 - e1x0) * (e0y1 - e0y0));
        double t1 = ((e0x1 - e0x0) * (e0y0 - e1y0) - (e0y1 - e0y0) * (e0x0 - e1x0)) / ((e1y1 - e1y0) * (e0x1 - e0x0) - (e1x1 - e1x0) * (e0y1 - e0y0));
        if (t0 >= 0.0 && t0 <= 1.0 && t1 >= 0.0 && t1 <= 1.0) {
            Point3d edge0Point = VectorUtils.getLinePoint(edge0.getVertex0(), edge0.getVertex1(), t0, new Point3d());
            Point3d edge1Point = VectorUtils.getLinePoint(edge1.getVertex0(), edge1.getVertex1(), t1, new Point3d());
            return new EdgeIntersection(edge0, edge1, edge0Point, edge1Point);
        }
        return null;
    }

    private Point3d getYIntersection(Edge edge0, double yValue, boolean allowOvershoot) {
        double e0y0 = edge0.getVertex0().getY();
        double e0y1 = edge0.getVertex1().getY();
        double t0 = -((e0y0 - yValue) / (e0y1 - e0y0));
        if (allowOvershoot || t0 >= 0.0 && t0 <= 1.0) {
            return VectorUtils.getLinePoint(edge0.getVertex0(), edge0.getVertex1(), t0, new Point3d());
        }
        return null;
    }

    private Polygon3D getLeadingPolygon(MyEdge edge) {
        if (this.isHorizontal(edge)) {
            if (edge.getFirstVertex() == edge.getVertex0()) {
                return edge.getPoly1To0();
            }
            return edge.getPoly0To1();
        }
        if (edge.getFirstVertex() == edge.getVertex0()) {
            return edge.getPoly0To1();
        }
        return edge.getPoly1To0();
    }

    private Polygon3D getTrailingPolygon(MyEdge edge) {
        if (this.isHorizontal(edge)) {
            if (edge.getFirstVertex() == edge.getVertex0()) {
                return edge.getPoly0To1();
            }
            return edge.getPoly1To0();
        }
        if (edge.getFirstVertex() == edge.getVertex0()) {
            return edge.getPoly1To0();
        }
        return edge.getPoly0To1();
    }

    private boolean isHorizontal(Edge edge) {
        return edge.getVertex0().getY() == edge.getVertex1().getY();
    }

    private double getSlope(MyEdge edge) {
        Point3d firstVertex = edge.getFirstVertex();
        Point3d lastVertex = edge.getLastVertex();
        return (lastVertex.getX() - firstVertex.getX()) / (lastVertex.getY() - firstVertex.getY());
    }

    private static class EdgeSegmentInfo {
        private final MyEdge _edge;
        private final List<Point3d> _boundaryPoints = new ArrayList<Point3d>();
        private final List<Collection<Polygon3D>> _frontPolysBySegment = new ArrayList<Collection<Polygon3D>>();
        private final List<Collection<Polygon3D>> _backPolysBySegment = new ArrayList<Collection<Polygon3D>>();
        private final double _slope;

        private EdgeSegmentInfo(MyEdge edge, double slope, Collection<Polygon3D> frontPolys, Collection<Polygon3D> backPolys) {
            assert (frontPolys != null);
            assert (backPolys != null);
            assert (!(frontPolys instanceof Set));
            assert (!(backPolys instanceof Set));
            this._edge = edge;
            this._boundaryPoints.add(edge.getFirstVertex());
            this._boundaryPoints.add(edge.getLastVertex());
            this._frontPolysBySegment.add(Collections.unmodifiableCollection(frontPolys));
            this._backPolysBySegment.add(Collections.unmodifiableCollection(backPolys));
            this._slope = slope;
        }

        public MyEdge getEdge() {
            return this._edge;
        }

        public double getEdgeSlope() {
            return this._slope;
        }

        public int segmentCount() {
            return this._boundaryPoints.size() - 1;
        }

        public List<Point3d> getBoundaryPoints() {
            return this._boundaryPoints;
        }

        public Point3d getBoundaryPointUnprojected(int k) {
            Point3d projected = this._boundaryPoints.get(k);
            Vector3d v = new Vector3d(projected);
            v.sub(this._edge.getFirstVertex());
            double length = v.length();
            v.set(this._edge.getLastVertex());
            v.sub(this._edge.getFirstVertex());
            double totalLength = v.length();
            double fraction = totalLength == 0.0 ? 0.0 : length / totalLength;
            return VectorUtils.getLinePoint(this._edge.getFirstVertexUnprojected(), this._edge.getLastVertexUnprojected(), fraction, new Point3d());
        }

        public Collection<Polygon3D> getFrontGroups(int k) {
            return this._frontPolysBySegment.get(k);
        }

        public Collection<Polygon3D> getBackGroups(int k) {
            return this._backPolysBySegment.get(k);
        }

        public Collection<Polygon3D> lastSegmentFrontGroups() {
            return this._frontPolysBySegment.get(this._frontPolysBySegment.size() - 1);
        }

        public Collection<Polygon3D> lastSegmentBackGroups() {
            return this._backPolysBySegment.get(this._backPolysBySegment.size() - 1);
        }

        public void addSegment(Point3d startPoint, Collection<Polygon3D> frontPolys, Collection<Polygon3D> backPolys) {
            assert (frontPolys != null);
            assert (backPolys != null);
            assert (!(frontPolys instanceof Set));
            assert (!(backPolys instanceof Set));
            this._boundaryPoints.add(this._boundaryPoints.size() - 1, startPoint);
            this._frontPolysBySegment.add(Collections.unmodifiableCollection(frontPolys));
            this._backPolysBySegment.add(Collections.unmodifiableCollection(backPolys));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[ edge = " + this._edge + ", points = " + this._boundaryPoints + ", front groups = " + this._frontPolysBySegment + ", back counts = " + this._backPolysBySegment + "]";
        }
    }

    private static class EdgeIntersection
    implements Comparable<EdgeIntersection> {
        private final MyEdge _nearEdge;
        private final MyEdge _farEdge;
        private final Point3d _nearEdgePoint;
        private final Point3d _farEdgePoint;

        EdgeIntersection(MyEdge edge0, MyEdge edge1, Point3d edge0Point, Point3d edge1Point) {
            if (edge0Point.getZ() <= edge1Point.getZ()) {
                this._nearEdge = edge0;
                this._farEdge = edge1;
                this._nearEdgePoint = edge0Point;
                this._farEdgePoint = edge1Point;
            } else {
                this._nearEdge = edge1;
                this._farEdge = edge0;
                this._nearEdgePoint = edge1Point;
                this._farEdgePoint = edge0Point;
            }
        }

        public MyEdge getNearEdge() {
            return this._nearEdge;
        }

        public MyEdge getFarEdge() {
            return this._farEdge;
        }

        public Point3d getNearEdgePoint() {
            return this._nearEdgePoint;
        }

        public Point3d getFarEdgePoint() {
            return this._farEdgePoint;
        }

        @Override
        public int compareTo(EdgeIntersection other) {
            return VERTEX_COMPARATOR.compare(this.getNearEdgePoint(), other.getNearEdgePoint());
        }
    }

    private static class PointOfInterest
    implements Comparable<PointOfInterest> {
        private final List<EdgeIntersection> _edgeIntersections = new ArrayList<EdgeIntersection>();
        private final List<MyEdge> _startingEdges = new ArrayList<MyEdge>();

        PointOfInterest(EdgeIntersection edgeIntersection) {
            this._edgeIntersections.add(edgeIntersection);
        }

        PointOfInterest(MyEdge startingEdge) {
            this._startingEdges.add(startingEdge);
        }

        public void addEdgeIntersection(EdgeIntersection edgeIntersection) {
            this._edgeIntersections.add(edgeIntersection);
        }

        public void addStartingEdge(MyEdge edge) {
            this._startingEdges.add(edge);
        }

        public List<EdgeIntersection> getEdgeIntersections() {
            return this._edgeIntersections;
        }

        public List<MyEdge> getStartingEdges() {
            return this._startingEdges;
        }

        public Point3d getLocation() {
            if (!this._startingEdges.isEmpty()) {
                return this._startingEdges.get(0).getFirstVertex();
            }
            return this._edgeIntersections.get(0).getNearEdgePoint();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[Starting Edges = " + this._startingEdges + ", Intersections = " + this._edgeIntersections + "]";
        }

        @Override
        public int compareTo(PointOfInterest other) {
            return VERTEX_COMPARATOR.compare(this.getLocation(), other.getLocation());
        }
    }

    private static class Span {
        private final MyEdge _leadingEdge;
        private final MyEdge _trailingEdge;
        private final Polygon3D _polygon;

        public Span(MyEdge leadingEdge, MyEdge trailingEdge, Polygon3D polygon) {
            this._leadingEdge = leadingEdge;
            this._trailingEdge = trailingEdge;
            this._polygon = polygon;
        }

        public MyEdge getLeadingEdge() {
            return this._leadingEdge;
        }

        public MyEdge getTrailingEdge() {
            return this._trailingEdge;
        }

        public Polygon3D getPolygon() {
            return this._polygon;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[ leading = " + this._leadingEdge + ", trailing = " + this._trailingEdge + "]";
        }
    }

    private static class MyEdge
    extends Edge {
        private final PolyMesh3D _mesh;
        private final int _firstVertexIndex;
        private final int _lastVertexIndex;

        public MyEdge(Edge edge, PolyMesh3D mesh) {
            super(edge.getVertices(), edge.getVertex0Index(), edge.getVertex1Index());
            this.setPoly0To1(edge.getPoly0To1());
            this.setPoly1To0(edge.getPoly1To0());
            this._mesh = mesh;
            this._firstVertexIndex = VERTEX_COMPARATOR.compare(this.getVertex0(), this.getVertex1()) < 0 ? this.getVertex0Index() : this.getVertex1Index();
            this._lastVertexIndex = VERTEX_COMPARATOR.compare(this.getVertex0(), this.getVertex1()) < 0 ? this.getVertex1Index() : this.getVertex0Index();
        }

        public Point3d getFirstVertex() {
            return this.getVertices().get(this._firstVertexIndex);
        }

        public Point3d getFirstVertexUnprojected() {
            return this._mesh.getAlternateVertices(CoordinateSystem.CAMERA).get(this._firstVertexIndex);
        }

        public Point3d getLastVertex() {
            return this.getVertices().get(this._lastVertexIndex);
        }

        public Point3d getLastVertexUnprojected() {
            return this._mesh.getAlternateVertices(CoordinateSystem.CAMERA).get(this._lastVertexIndex);
        }

        public int getFirstVertexIndex() {
            return this._firstVertexIndex;
        }

        public int getLastVertexIndex() {
            return this._lastVertexIndex;
        }
    }

    public static interface EdgeSegmentFilter {
        public boolean accept(Edge var1, Point3d var2, Point3d var3, Collection<Polygon3D> var4, Collection<Polygon3D> var5);
    }
}

