/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.render;

import com.sodiumarc.patchwork.render.DepthFunction;
import com.sodiumarc.patchwork.render.HoleMap;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class DeepImage {
    private final BufferedImage image;
    private final DepthFunction depthFunction;
    private final HoleMap holeMap;
    private final Rectangle bounds;
    private String name;

    public DeepImage(BufferedImage image, DepthFunction depthFunction) {
        this.image = image;
        this.depthFunction = depthFunction;
        this.bounds = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        this.holeMap = new HoleMap();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public DepthFunction getDepthFunction() {
        return this.depthFunction;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Point getOffset() {
        return this.bounds.getLocation();
    }

    public void setOffset(Point offset) {
        this.bounds.setLocation(offset);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Dimension getSize() {
        return this.bounds.getSize();
    }

    public int getColor(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return 0;
        }
        x = this.toLocalX(x);
        y = this.toLocalY(y);
        return this.image.getRGB(x, y);
    }

    public double getDepth(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return Double.POSITIVE_INFINITY;
        }
        x = this.toLocalX(x);
        y = this.toLocalY(y);
        return this.depthFunction.getDepth(x, y);
    }

    public boolean containsPoint(int x, int y) {
        return this.bounds.contains(x, y);
    }

    public int toLocalX(int x) {
        return x - this.bounds.x;
    }

    public int toLocalY(int y) {
        return y - this.bounds.y;
    }

    public boolean isPremultiplied() {
        return this.image.getType() == 3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HoleMap getHoleMap() {
        return this.holeMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }
}

