/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate.condition;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.condition.TransitionCondition;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.Map;
import org.w3c.dom.Node;

public class ConditionalStateTransition
implements AS3Convertible {
    public static String ELEMENT_NAME = "conditional_trans";
    public static String DESTINATION_STATE_ID_ATTR_NAME = "destination_state_id";
    public static DocumentNodeDecoder<ConditionalStateTransition> DECODER = new DocumentNodeDecoder<ConditionalStateTransition>(){

        @Override
        public ConditionalStateTransition decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new ConditionalStateTransition(attributes.get(DESTINATION_STATE_ID_ATTR_NAME), (TransitionCondition)CollectionUtils.first(XMLUtils.decodeChildren(node, TransitionCondition.TRANSITION_DECODERS)));
        }
    };
    private final String destinationStateID;
    private final TransitionCondition condition;

    public ConditionalStateTransition(String destinationStateID, TransitionCondition condition) {
        this.destinationStateID = destinationStateID;
        this.condition = condition;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("DESTINATION_STATE_ID", this.destinationStateID);
        template.setParameterValue("CONDITION", this.condition.toAS3String(templates));
        return template.getProcessedText();
    }
}

