/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate.condition;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class CardLinkCriteria
implements AS3Convertible {
    public static String ELEMENT_NAME = "card_link";
    public static String ID_ATTR_NAME = "id";
    public static String OTHER_CARD_ID_ATTR_NAME = "other_card_id";
    public static String OTHER_CARD_STATES_ATTR_NAME = "other_card_states";
    public static String DIRECTION_ATTR_NAME = "direction";
    public static DocumentNodeDecoder<CardLinkCriteria> DECODER = new DocumentNodeDecoder<CardLinkCriteria>(){

        @Override
        public CardLinkCriteria decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            GridDirection direction = GridDirection.valueOf(attributes.get(DIRECTION_ATTR_NAME).toUpperCase());
            String statesStr = attributes.get(OTHER_CARD_STATES_ATTR_NAME);
            Set otherCardStateIDs = statesStr == null ? null : (Set)StringUtils.split(statesStr, ",", true, new HashSet<String>());
            return new CardLinkCriteria(attributes.get(ID_ATTR_NAME), attributes.get(OTHER_CARD_ID_ATTR_NAME), otherCardStateIDs, direction);
        }
    };
    private final String id;
    private final GridDirection direction;
    private final String otherCardID;
    private final Set<String> otherCardStateIDs;

    public CardLinkCriteria(String identifier, String otherCardID, Set<String> otherCardStateIDs, GridDirection direction) {
        this.id = identifier;
        this.direction = direction;
        this.otherCardID = otherCardID;
        this.otherCardStateIDs = otherCardStateIDs;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("ID", this.id);
        template.setParameterValue("DIRECTION", this.direction.toString());
        template.setParameterValue("OTHER_CARD_ID", this.otherCardID);
        String statesStr = null;
        if (this.otherCardStateIDs != null) {
            statesStr = "[" + StringUtils.toQuotedDelimitedList(this.otherCardStateIDs, ",", "\"") + "]";
        }
        template.setParameterValueNullable("OTHER_CARD_STATES", statesStr);
        return template.getProcessedText();
    }
}

