/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AnimationInstance;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.CrossMorph;
import com.sodiumarc.patchwork.animation.NumericalAlphaFunction;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.CardState;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class Hotspot
implements AS3Convertible {
    public static final Rectangle4d DEFAULT_BOUNDS = new Rectangle4d(0.8, 0.8, 0.15, 0.15);
    public static String ELEMENT_NAME = "hotspot";
    public static String ID_ATTR_NAME = "id";
    public static String DESTINATION_STATE_ID_ATTR_NAME = "destination_state_id";
    public static String TYPE_ATTR_NAME = "type";
    public static String TRANSITION_ATTR_NAME = "trans";
    public static DocumentNodeDecoder<Hotspot> DECODER = new DocumentNodeDecoder<Hotspot>(){

        @Override
        public Hotspot decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new Hotspot(attributes);
        }
    };
    private String id;
    private Rectangle4d bounds;
    private final String transitionIDParam;
    private String destinationStateID;
    private final Type type;
    private final Transition transition;

    public Hotspot(Map<String, String> properties) {
        this.id = properties.get(ID_ATTR_NAME);
        this.destinationStateID = properties.get(DESTINATION_STATE_ID_ATTR_NAME);
        String[] transitionStrings = properties.get(TRANSITION_ATTR_NAME).split(":");
        this.transition = Transition.valueOf(transitionStrings[0].toUpperCase());
        this.transitionIDParam = this.transition != Transition.NONE && transitionStrings.length == 2 ? transitionStrings[1] : null;
        String[] typeStrings = properties.get(TYPE_ATTR_NAME).split(":");
        this.type = Type.valueOf(typeStrings[0].toUpperCase());
        switch (this.type) {
            case MESH: {
                ImageOutputID imageID = new ImageOutputID(typeStrings[1]);
                RenderImage image = null;
                try {
                    image = RenderControl.getInstance().getRenderImage(imageID, RenderControl.DEFAULT_CONDITION);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                assert (image != null) : "Failed to find image: " + imageID;
                Rectangle4d hotspotProjected = image.getHotspotProjectedBounds(this.getID());
                assert (hotspotProjected != null) : "Failed to find hotspot: " + this.getID();
                Rectangle4d boundsProjected = image.getProjectedBounds();
                this.bounds = boundsProjected.toProportional(hotspotProjected);
                break;
            }
            case REGION: {
                this.bounds = typeStrings.length > 1 ? new Rectangle4d(typeStrings[1]) : null;
                break;
            }
            default: {
                this.bounds = null;
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDestinationStateID() {
        return this.destinationStateID;
    }

    public void setDestinationStateID(String destinationStateID) {
        this.destinationStateID = destinationStateID;
    }

    public Type getType() {
        return this.type;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public boolean hasExplicitBounds() {
        return this.bounds != null;
    }

    public Rectangle4d getBounds() {
        if (this.bounds == null) {
            return DEFAULT_BOUNDS;
        }
        return this.bounds;
    }

    public void setBounds(Rectangle4d bounds) {
        this.bounds = bounds;
    }

    public CardState createAutoTransitionState(String transitionStateID, CardState fromState, CardState toState) {
        List<Object> animations = Collections.emptyList();
        switch (this.transition) {
            case NONE: {
                return null;
            }
            case CROSS_MORPH: 
            case FLAT_ZOOM: {
                animations = this.createCrossMorphTransitions(transitionStateID, fromState, toState);
                if (this.getType() != Type.REGION || this.hasExplicitBounds()) break;
                CrossMorph frontmost = (CrossMorph)CollectionUtils.last(animations);
                this.setBounds(frontmost.getFromRectangle());
                break;
            }
            case ANIM_REF: {
                animations = Collections.singletonList(new AnimationInstance(null, this.transitionIDParam));
                break;
            }
            case REVERSE: {
                CompoundAnimation reverse = new CompoundAnimation((String)null);
                reverse.setAlphaFunction(NumericalAlphaFunction.REVERSE);
                reverse.setComponentAnimations(Collections.singletonList(new AnimationInstance(this.id, this.transitionIDParam)));
                animations = Collections.singletonList(reverse);
            }
        }
        CardState result = new CardState(transitionStateID);
        result.setAnimations(animations);
        result.setAutoTransitionStateID(toState.getID());
        String bgColor = null;
        if (fromState.getBgColor() != null) {
            bgColor = fromState.getBgColor();
        } else if (toState.getBgColor() != null) {
            bgColor = toState.getBgColor();
        }
        result.setBgColor(bgColor);
        this.setDestinationStateID(result.getID());
        return result;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("HOTSPOT_ID", this.getID());
        template.setParameterValue("DESTINATION_STATE_ID", this.getDestinationStateID());
        template.setParameterValue("IS_BACKOUT", this.type == Type.BUTTON ? "true" : "false");
        template.setParameterValue("HOTSPOT_BOUNDS", this.getBounds().encode());
        return template.getProcessedText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", destination = " + this.destinationStateID + "]";
    }

    public List<CrossMorph> createCrossMorphTransitions(String transitionStateID, CardState fromState, CardState toState) {
        AS3Animation toAnim;
        AS3Animation fromAnim;
        int i;
        ArrayList<? extends AS3Animation> fromAnimations = new ArrayList<AS3Animation>(fromState.getAnimations());
        ArrayList<? extends AS3Animation> toAnimations = new ArrayList<AS3Animation>(toState.getAnimations());
        ArrayList<CrossMorph> transitionAnimations = new ArrayList<CrossMorph>();
        int trackIndex = -1;
        for (i = 0; i < fromAnimations.size() && i < toAnimations.size(); ++i) {
            fromAnim = (AS3Animation)fromAnimations.get(i);
            toAnim = (AS3Animation)toAnimations.get(i);
            if (this.transitionIDParam == null) {
                transitionAnimations.add(this.createNonTrackingTransition(fromAnim, toAnim));
                continue;
            }
            if (this.transitionIDParam.equals(fromAnim.getID()) && this.transitionIDParam.equals(toAnim.getID())) {
                transitionAnimations.add(this.createNonTrackingTransition(fromAnim, toAnim));
                trackIndex = i;
                continue;
            }
            transitionAnimations.add(null);
        }
        for (i = 0; i < transitionAnimations.size(); ++i) {
            fromAnim = (AS3Animation)fromAnimations.get(i);
            toAnim = (AS3Animation)toAnimations.get(i);
            if (transitionAnimations.get(i) != null) continue;
            if (trackIndex == -1) {
                Logger.getLogger(this.getClass()).warn("Failed to find track layer: " + this.transitionIDParam);
                transitionAnimations.set(i, this.createNonTrackingTransition(fromAnim, toAnim));
                continue;
            }
            transitionAnimations.set(i, this.createTrackingTransition(fromAnim, toAnim, (CrossMorph)transitionAnimations.get(trackIndex)));
        }
        return transitionAnimations;
    }

    private CrossMorph createNonTrackingTransition(AS3Animation fromAnim, AS3Animation toAnim) {
        RenderImage fromImage = CollectionUtils.first(fromAnim.getImages(false));
        RenderImage toImage = CollectionUtils.first(toAnim.getImages(false));
        CrossMorph morph = this.transition == Transition.FLAT_ZOOM ? CrossMorph.newFlatZoomInstance(null, fromImage, toImage) : CrossMorph.newReferenceAlignmentInstance(null, fromImage, toImage, null, null);
        return morph;
    }

    private CrossMorph createTrackingTransition(AS3Animation fromAnim, AS3Animation toAnim, CrossMorph track) {
        RenderImage fromImage = CollectionUtils.first(fromAnim.getImages(false));
        RenderImage toImage = CollectionUtils.first(toAnim.getImages(false));
        return CrossMorph.newTrackingInstance(null, fromImage, toImage, track);
    }

    public static enum Transition {
        FLAT_ZOOM,
        CROSS_MORPH,
        ANIM_REF,
        REVERSE,
        NONE;

    }

    public static enum Type {
        BUTTON,
        MESH,
        REGION;

    }
}

