/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.generate;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.generate.GameConfig;
import com.sodiumarc.patchwork.generate.GeneratorAppProperties;
import com.sodiumarc.patchwork.generate.GeneratorProgressObserver;
import com.sodiumarc.patchwork.generate.GeneratorResourceIO;
import com.sodiumarc.patchwork.render.control.RenderImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GeneratorControl {
    private static GeneratorControl INSTANCE;

    public static GeneratorControl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GeneratorControl();
        }
        return INSTANCE;
    }

    public Set<String> getCardIDs() throws IOException, ParserConfigurationException, SAXException {
        GameConfig config = GameConfig.loadFromFile(GeneratorAppProperties.CONFIG_INPUT_FILE.getValue());
        return config.getCardFilenames();
    }

    public void generate(List<String> cardFilenames, GeneratorProgressObserver observer) throws IOException, ParserConfigurationException, SAXException, ParseException {
        TemplateLibrary templates = new TemplateLibrary(GeneratorAppProperties.AS3_TEMPLATE_FILE.getValue());
        GameConfig config = GameConfig.loadFromFile(GeneratorAppProperties.CONFIG_INPUT_FILE.getValue());
        for (String cardFilename : cardFilenames) {
            this.generateCard(config.getCard(cardFilename), 0, 1, templates, observer);
        }
        String as3String = config.toAS3String(templates);
        GeneratorResourceIO.getInstance().writeAS3File(as3String, "MyGameConfig");
    }

    public void generateAll(GeneratorProgressObserver observer) throws IOException, ParseException, ParserConfigurationException, SAXException {
        GameConfig config = GameConfig.loadFromFile(GeneratorAppProperties.CONFIG_INPUT_FILE.getValue());
        TemplateLibrary templates = new TemplateLibrary(GeneratorAppProperties.AS3_TEMPLATE_FILE.getValue());
        int cardIndex = 0;
        List<Card> cards = config.getCards();
        for (Card card : cards) {
            this.generateCard(card, cardIndex, cards.size(), templates, observer);
            ++cardIndex;
        }
        String as3String = config.toAS3String(templates);
        GeneratorResourceIO.getInstance().writeAS3File(as3String, "MyGameConfig");
    }

    private void publishResources(Card card) throws IOException {
        for (RenderImage resourceName : card.getImages()) {
            resourceName.publish();
        }
    }

    private void generateCard(Card card, int cardIndex, int totalCards, TemplateLibrary templates, GeneratorProgressObserver observer) throws FileNotFoundException, ParseException, IOException {
        if (observer != null) {
            observer.cardGenerationStarted(card.getId(), cardIndex, totalCards);
        }
        String as3String = card.toAS3String(templates);
        as3String = AS3ConversionUtils.format(as3String);
        GeneratorResourceIO.getInstance().writeAS3File(as3String, card.getId());
        this.publishResources(card);
        if (observer != null) {
            observer.cardGenerationComplete(card.getId(), cardIndex, totalCards);
        }
    }
}

