/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.collada;

import com.sodiumarc.patchwork.collada.ColladaElement;
import com.sodiumarc.patchwork.collada.Input;
import com.sodiumarc.patchwork.collada.P;
import java.util.ArrayList;
import java.util.List;

public class Polygons
extends ColladaElement {
    public static final String ELEMENT_NAME = "polygons";
    public static final String ATTR_MATERIAL = "material";
    public static final String SEMANTIC_VERTEX = "VERTEX";
    public static final String SEMANTIC_NORMAL = "NORMAL";
    public static final String SEMANTIC_COLOR = "COLOR";

    public List<List<Integer>> getIndexLists() {
        List<P> ps = this.getChildElementsByType(P.class);
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>(ps.size());
        for (P p : ps) {
            result.add(p.getValues());
        }
        return result;
    }

    public List<Integer> getIndexListForSemantic(String semantic, List<Integer> compositeIndexList) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Input input = this.getInputForSemantic(semantic);
        if (input != null) {
            int semanticOffset = input.getOffset();
            int indexStride = this.getMaxInputOffset() + 1;
            int offset = 0;
            for (Integer index : compositeIndexList) {
                if (offset == semanticOffset) {
                    result.add(index);
                }
                offset = (offset + 1) % indexStride;
            }
        }
        return result;
    }

    public String getMaterialID() {
        return this.getAttributeValue(ATTR_MATERIAL);
    }

    Polygons() {
        super(ELEMENT_NAME);
    }
}

