/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.collada;

import com.sodiumarc.patchwork.collada.InstanceCamera;
import com.sodiumarc.patchwork.collada.InstanceGeometry;
import com.sodiumarc.patchwork.collada.InstanceLight;
import com.sodiumarc.patchwork.collada.NameableElement;
import com.sodiumarc.patchwork.collada.Rotate;
import com.sodiumarc.patchwork.collada.Scale;
import com.sodiumarc.patchwork.collada.Translate;
import java.util.ArrayList;
import java.util.List;

public class Node
extends NameableElement {
    public static final String ELEMENT_NAME = "node";
    public static final String ATTR_LAYER = "layer";
    public static final String SID_TRANSLATE = "translate";
    public static final String SID_ROTATEZ = "rotateZ";
    public static final String SID_ROTATEY = "rotateY";
    public static final String SID_ROTATEX = "rotateX";
    public static final String SID_SCALE = "scale";

    public final String getLayer() {
        return this.getAttributeValue(ATTR_LAYER);
    }

    public final List<Node> getChildNodes() {
        return this.getChildElementsByType(Node.class);
    }

    public final List<String> getGeometryIds() {
        List<InstanceGeometry> instanceGeometries = this.getChildElementsByType(InstanceGeometry.class);
        ArrayList<String> ids = new ArrayList<String>();
        for (InstanceGeometry instanceGeometry : instanceGeometries) {
            String id = instanceGeometry.getGeometryId();
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public final List<String> getCameraIds() {
        List<InstanceCamera> instanceCameras = this.getChildElementsByType(InstanceCamera.class);
        ArrayList<String> ids = new ArrayList<String>();
        for (InstanceCamera instanceCamera : instanceCameras) {
            String id = instanceCamera.getCameraId();
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public final List<String> getLightIds() {
        List<InstanceLight> instanceLights = this.getChildElementsByType(InstanceLight.class);
        ArrayList<String> ids = new ArrayList<String>();
        for (InstanceLight instanceLight : instanceLights) {
            String id = instanceLight.getLightId();
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public final Translate getTranslate() {
        List<Translate> translates = this.getChildElementsByType(Translate.class);
        if (translates.size() > 0) {
            return translates.get(0);
        }
        return null;
    }

    public final Scale getScale() {
        List<Scale> scales = this.getChildElementsByType(Scale.class);
        if (scales.size() > 0) {
            return scales.get(0);
        }
        return null;
    }

    public final Rotate getRotate(String sid) {
        List<Rotate> rotates = this.getChildElementsByType(Rotate.class);
        for (Rotate rotate : rotates) {
            if (!rotate.getSid().equals(sid)) continue;
            return rotate;
        }
        return null;
    }

    public final boolean subtreeContainsGeometry() {
        if (this.getGeometryIds().size() > 0) {
            return true;
        }
        List<Node> childNodes = this.getChildNodes();
        for (Node child : childNodes) {
            if (!child.subtreeContainsGeometry()) continue;
            return true;
        }
        return false;
    }

    Node() {
        super(ELEMENT_NAME);
    }
}

