/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.collada;

import com.sodiumarc.patchwork.collada.Input;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColladaElement {
    public static final String ATTR_ID = "id";
    private final String _elementName;
    private final List<ColladaElement> _childElements;
    private final Map<Class<?>, List<ColladaElement>> _childElementsByType;
    private final Map<String, String> _attributeValuesByName;

    public static String uriFragmentToId(String uriFragment) {
        if (uriFragment != null && uriFragment.length() > 0) {
            return uriFragment.substring(1);
        }
        return null;
    }

    public final String getElementName() {
        return this._elementName;
    }

    public final String getId() {
        return this.getAttributeValue(ATTR_ID);
    }

    public final List<Input> getInputs() {
        return this.getChildElementsByType(Input.class);
    }

    public final String getAttributeValue(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this._attributeValuesByName.get(name);
    }

    public final List<ColladaElement> getChildElements() {
        return Collections.unmodifiableList(this._childElements);
    }

    public final <T extends ColladaElement> List<T> getChildElementsByType(Class<T> type) {
        List<ColladaElement> childElements = this._childElementsByType.get(type);
        if (childElements == null) {
            return Collections.emptyList();
        }
        return childElements;
    }

    public final <T extends ColladaElement> List<T> getDescendantElementsByType(Class<T> type) {
        ArrayList descendants = new ArrayList();
        this.getDescendantElementsByTypeImpl(this, type, descendants);
        return descendants;
    }

    public final <T extends ColladaElement> T getChildElement(Class<T> type, String id) {
        List<T> childElements = this.getChildElementsByType(type);
        for (ColladaElement child : childElements) {
            if (!id.equals(child.getId())) continue;
            return (T)child;
        }
        return null;
    }

    public final Input getInputForSemantic(String semantic) {
        if (semantic == null) {
            throw new NullPointerException();
        }
        List<Input> inputs = this.getInputs();
        for (Input input : inputs) {
            if (!semantic.equals(input.getSemantic())) continue;
            return input;
        }
        return null;
    }

    public final int getMaxInputOffset() {
        int maxInputOffset = 0;
        List<Input> inputs = this.getInputs();
        for (Input input : inputs) {
            if (input.getOffset() <= maxInputOffset) continue;
            maxInputOffset = input.getOffset();
        }
        return maxInputOffset;
    }

    public void processCData(String cdata) {
    }

    ColladaElement(String elementName) {
        this._elementName = elementName;
        this._childElements = new ArrayList<ColladaElement>();
        this._childElementsByType = new HashMap();
        this._attributeValuesByName = new HashMap<String, String>();
    }

    void setAttribute(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        this._attributeValuesByName.put(name, value);
    }

    void addChildElement(ColladaElement childElement) {
        List<ColladaElement> childElements = this._childElementsByType.get(childElement.getClass());
        if (childElements == null) {
            childElements = new ArrayList<ColladaElement>();
            this._childElementsByType.put(childElement.getClass(), childElements);
        }
        childElements.add(childElement);
        this._childElements.add(childElement);
    }

    public String toString() {
        return this.getElementName();
    }

    private <T extends ColladaElement> void getDescendantElementsByTypeImpl(ColladaElement root, Class<T> type, List<T> descendants) {
        for (ColladaElement child : root.getChildElements()) {
            if (child.getClass() == type) {
                descendants.add(child);
            }
            this.getDescendantElementsByTypeImpl(child, type, descendants);
        }
    }
}

