/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.collada;

import com.sodiumarc.patchwork.collada.Channel;
import com.sodiumarc.patchwork.collada.NameableElement;
import com.sodiumarc.patchwork.collada.Sampler;
import com.sodiumarc.patchwork.collada.Source;
import java.util.ArrayList;
import java.util.List;

public class Animation
extends NameableElement {
    public static final String ELEMENT_NAME = "animation";

    public final List<Float> getSourceArray(String id) {
        Source source = this.getChildElement(Source.class, id);
        if (source != null) {
            return source.getFloatValues();
        }
        return null;
    }

    public final List<String> getSamplerIds() {
        ArrayList<String> samplerIds = new ArrayList<String>();
        List<Sampler> samplers = this.getChildElementsByType(Sampler.class);
        for (Sampler sampler : samplers) {
            samplerIds.add(sampler.getId());
        }
        return samplerIds;
    }

    public final List<Float> getInputValues(String samplerId) {
        Sampler sampler = this.getChildElement(Sampler.class, samplerId);
        String inputSourceId = sampler.getInputSourceId();
        return this.getSourceArray(inputSourceId);
    }

    public final List<Float> getOutputValues(String samplerId) {
        Sampler sampler = this.getChildElement(Sampler.class, samplerId);
        String outputSourceId = sampler.getOutputSourceId();
        return this.getSourceArray(outputSourceId);
    }

    public final List<Channel> getChannels() {
        return this.getChildElementsByType(Channel.class);
    }

    Animation() {
        super(ELEMENT_NAME);
    }
}

