/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.HeaderLabel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentListCellRenderer;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.table.ProjectComponentTableCellRenderer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class StateEditorPanel
extends TargetablePanel<CardViewer> {
    private final CardViewerListener cardViewerListener = new CardViewerListener(){

        @Override
        public void infoChanged(CardViewer source) {
        }

        @Override
        public void locationChanged(CardViewer source) {
            StateEditorPanel.this.updateTable();
            StateEditorPanel.this.headerLabel.setTarget(StateEditorPanel.this.cardViewer.getCurrentLocation());
        }

        @Override
        public void stateChanged(CardViewer source) {
            StateEditorPanel.this.updateTable();
        }

        @Override
        public void targetChanged(CardViewer source) {
        }
    };
    private AbstractTableModel stateEditorTableModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Scene";
                }
                case 1: {
                    return "Layer";
                }
                case 2: {
                    return "State";
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Scene.class;
                }
                case 1: {
                    return SceneLayer.class;
                }
                case 2: {
                    return SceneLayerState.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return StateEditorPanel.this.layers.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((SceneLayer)StateEditorPanel.this.layers.get(rowIndex)).getParentComponent();
                }
                case 1: {
                    return StateEditorPanel.this.layers.get(rowIndex);
                }
                case 2: {
                    return ((CardViewer)StateEditorPanel.this.getTarget()).getCurrentState((SceneLayer)StateEditorPanel.this.layers.get(rowIndex));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SceneLayer sceneLayer = (SceneLayer)StateEditorPanel.this.layers.get(rowIndex);
            StateEditorPanel.this.cardViewer.setState(sceneLayer, (SceneLayerState)aValue);
        }
    };
    private final HeaderLabel headerLabel;
    private CardViewer cardViewer;
    private final List<SceneLayer> layers = new ArrayList<SceneLayer>();

    public StateEditorPanel() {
        super(new BorderLayout());
        this.headerLabel = new HeaderLabel(false);
        JTable table = new JTable(this.stateEditorTableModel);
        table.setRowSelectionAllowed(false);
        table.setRowHeight(25);
        table.setRowMargin(2);
        table.setShowVerticalLines(false);
        table.getColumnModel().getColumn(2).setCellEditor(new StateCellEditor());
        ProjectComponentTableCellRenderer renderer = new ProjectComponentTableCellRenderer();
        table.setDefaultRenderer(Scene.class, renderer);
        table.setDefaultRenderer(SceneLayer.class, renderer);
        table.setDefaultRenderer(SceneLayerState.class, renderer);
        this.add((Component)this.headerLabel, "North");
        JScrollPane scroller = new JScrollPane(table);
        scroller.getViewport().setBackground(Color.WHITE);
        scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder(1)));
        this.add((Component)scroller, "Center");
    }

    @Override
    protected void targetSet() {
        this.setCardViewer((CardViewer)this.getTarget());
    }

    private void setCardViewer(CardViewer cardViewer) {
        if (this.cardViewer != null) {
            this.cardViewer.removeCardListener(this.cardViewerListener);
        }
        this.cardViewer = cardViewer;
        if (this.cardViewer != null) {
            this.cardViewer.addCardListener(this.cardViewerListener);
        }
        this.headerLabel.setTarget(cardViewer == null ? null : cardViewer.getCurrentLocation());
        this.updateTable();
    }

    private void updateTable() {
        SceneLocation location;
        this.layers.clear();
        CardViewer target = (CardViewer)this.getTarget();
        if (target != null && (location = target.getCurrentLocation()) != null) {
            Card card = location.getAncestorByType(Card.class);
            for (Scene scene : card.getScenes()) {
                for (SceneLayer sceneLayer : scene.getSceneLayers()) {
                    List<SceneLayerState> states = sceneLayer.getStates();
                    if (states.isEmpty()) continue;
                    this.layers.add(sceneLayer);
                }
            }
        }
        this.stateEditorTableModel.fireTableDataChanged();
    }

    private class StateCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final JComboBox comboBox = new JComboBox();

        public StateCellEditor() {
            this.comboBox.setRenderer(new ProjectComponentListCellRenderer());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBox.removeActionListener(this);
            SceneLayer sceneLayer = (SceneLayer)StateEditorPanel.this.stateEditorTableModel.getValueAt(row, 1);
            ArrayList<SceneLayerState> options = new ArrayList<SceneLayerState>(sceneLayer.getStates());
            options.add(0, null);
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
            this.comboBox.setSelectedItem(value);
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }
    }
}

