/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardStack;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;

public class PlayingGrid {
    private final int rows;
    private final int cols;
    private final CardStack[][] cells;

    public PlayingGrid(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.cells = new CardStack[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                this.cells[row][col] = new CardStack();
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public boolean isInBounds(GridCoords coords) {
        return coords.getRow() >= 0 && coords.getRow() < this.rows && coords.getCol() >= 0 && coords.getCol() < this.cols;
    }

    public Card getTopCard(GridCoords coords) {
        if (!this.isInBounds(coords)) {
            return null;
        }
        return this.getCardStack(coords).getTopCard();
    }

    public Card getUnderCard(GridCoords coords) {
        if (!this.isInBounds(coords)) {
            return null;
        }
        return this.getCardStack(coords).getUnderCard();
    }

    public int getCardCount(GridCoords coords) {
        if (!this.isInBounds(coords)) {
            return 0;
        }
        return this.getCardStack(coords).size();
    }

    public void placeCard(Card card, GridCoords coords) {
        if (!this.isInBounds(coords)) {
            throw new IllegalArgumentException("Coords out of bounds: " + coords);
        }
        this.getCardStack(coords).addCard(card);
    }

    public GridCoords removeCard(Card card) {
        GridCoords coords = this.getCoords(card);
        if (coords != null) {
            this.getCardStack(coords).removeCard(card);
        }
        return coords;
    }

    public GridCoords getCoords(Card card) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                CardStack cell = this.cells[row][col];
                if (!cell.contains(card)) continue;
                return new GridCoords(row, col);
            }
        }
        return null;
    }

    public GridCoords getEmptyCell() {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                CardStack cell = this.cells[row][col];
                if (!cell.isEmpty()) continue;
                return new GridCoords(row, col);
            }
        }
        return null;
    }

    private CardStack getCardStack(GridCoords coords) {
        return this.cells[coords.getRow()][coords.getCol()];
    }
}

