/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardBorder;
import com.sodiumarc.patchwork.util.ColorUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class LoadingProgressPainter {
    public static final BufferedImage HOURGLASS_IMAGE = ResourceManager.getImageResource("system/hourglass.png");
    public static final BufferedImage PRESS_ANY_KEY_IMAGE = ResourceManager.getImageResource("system/press_any_key.png");
    public static final BufferedImage[] charImages = new BufferedImage[]{ResourceManager.getImageResource("system/char0.png"), ResourceManager.getImageResource("system/char1.png"), ResourceManager.getImageResource("system/char2.png"), ResourceManager.getImageResource("system/char3.png"), ResourceManager.getImageResource("system/char4.png"), ResourceManager.getImageResource("system/char5.png"), ResourceManager.getImageResource("system/char6.png"), ResourceManager.getImageResource("system/char7.png"), ResourceManager.getImageResource("system/char8.png"), ResourceManager.getImageResource("system/char9.png"), ResourceManager.getImageResource("system/charPercent.png")};
    private final CardBorder rectanglePainter = new CardBorder(PatchworkProject.CARD_DIMENSION);
    private boolean visible;
    private float percentComplete;
    private BufferedImage titleImage;
    private static final Color FILL_COLOR = new Color(245, 245, 245);

    public LoadingProgressPainter() {
        this.rectanglePainter.setPercentComplete(0.0f);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setPercentComplete(float percentComplete) {
        this.percentComplete = percentComplete;
        this.rectanglePainter.setPercentComplete(percentComplete);
    }

    public BufferedImage getTitleImage() {
        return this.titleImage;
    }

    public void setTitleImage(BufferedImage titleImage) {
        this.titleImage = titleImage;
    }

    public void paint(Graphics2D g2, Point location) {
        if (!this.visible) {
            return;
        }
        Point center = new Point(location.x + PatchworkProject.CARD_SIZE / 2, location.y + PatchworkProject.CARD_SIZE / 2);
        Color oldColor = g2.getColor();
        Color fillColor = ColorUtils.blend(Color.WHITE, FILL_COLOR, this.percentComplete / 100.0f);
        g2.setColor(fillColor);
        g2.fillRect(location.x, location.y, PatchworkProject.CARD_SIZE, PatchworkProject.CARD_SIZE);
        Composite oldComposite = g2.getComposite();
        float alpha = 1.0f;
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        if (this.titleImage != null) {
            g2.drawImage((Image)this.titleImage, location.x, location.y, null);
        } else {
            g2.drawImage((Image)HOURGLASS_IMAGE, center.x - HOURGLASS_IMAGE.getWidth() / 2, center.y - (HOURGLASS_IMAGE.getHeight() - 10), null);
        }
        if (this.percentComplete < 100.0f) {
            this.paintPercentage(g2, new Point(center.x, center.y + 65));
        } else {
            g2.drawImage((Image)PRESS_ANY_KEY_IMAGE, center.x - PRESS_ANY_KEY_IMAGE.getWidth() / 2, center.y + 65, null);
        }
        g2.setComposite(oldComposite);
        this.rectanglePainter.paint(g2, location);
        g2.setColor(oldColor);
    }

    private void paintPercentage(Graphics2D g2, Point topCenter) {
        int percent = (int)this.percentComplete;
        BufferedImage firstDigitImage = charImages[percent / 10];
        BufferedImage secondDigitImage = charImages[percent % 10];
        BufferedImage percentImage = charImages[10];
        int totalWidth = firstDigitImage.getWidth() + secondDigitImage.getWidth() + percentImage.getWidth();
        int x = topCenter.x - totalWidth / 2;
        int y = topCenter.y;
        g2.drawImage((Image)firstDigitImage, x, y, null);
        g2.drawImage((Image)secondDigitImage, x += firstDigitImage.getWidth(), y, null);
        g2.drawImage((Image)percentImage, x += secondDigitImage.getWidth(), y, null);
    }
}

