/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.animation.AbstractAnimation;
import com.sodiumarc.patchwork.animation.SineInterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.resource.ResourceManager;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class InstructionAnimation
extends AbstractAnimation {
    public static final BufferedImage DEFAULT_CURSOR = ResourceManager.getImageResource("system/cursor_default.png");
    public static final BufferedImage MOVE_CURSOR = ResourceManager.getImageResource("system/cursor_move.png");
    private float elapsedFraction;
    private Rectangle boundaryRect = new Rectangle(0, 0, 100, 100);
    private BufferedImage drawImage;
    private static final Point2D[] CURSOR_STOPS_PROPORTIONAL = new Point2D[]{new Point2D.Float(0.3f, 0.85f), new Point2D.Float(0.3f, 0.3f), new Point2D.Float(0.8f, 0.3f), new Point2D.Float(0.7f, 0.7f)};
    private static SineInterpFunction EASE_THROUGH_FUNC = new SineInterpFunction(-1, 1);
    private static final Color SHADOW_COLOR = new Color(0, 0, 0, 80);

    public void setBoundaryRect(Rectangle boundaryRect) {
        this.boundaryRect.setRect(boundaryRect);
        this.drawImage = new BufferedImage(boundaryRect.width, boundaryRect.height, 2);
    }

    public void paint(Graphics2D g2) {
        if (!this.isRunning() || this.drawImage == null) {
            return;
        }
        Phase phase = this.getPhase();
        if (phase == null) {
            return;
        }
        float phaseFraction = this.getPhaseFraction();
        Rectangle gridRect = new Rectangle(0, 0, this.boundaryRect.width / 2, this.boundaryRect.width / 2);
        Graphics2D graphics = this.drawImage.createGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, this.drawImage.getWidth(), this.drawImage.getHeight());
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.setColor(Color.GRAY);
        graphics.drawRect(gridRect.x, gridRect.y, gridRect.width, gridRect.height);
        int xCenter = gridRect.x + gridRect.width / 2;
        int yCenter = gridRect.y + gridRect.height / 2;
        graphics.drawLine(gridRect.x, yCenter, gridRect.x + gridRect.width, yCenter);
        graphics.drawLine(xCenter, gridRect.y, xCenter, gridRect.y + gridRect.height);
        Dimension cardSize = new Dimension(gridRect.width / 2, gridRect.height / 2);
        Point cardStart = new Point(gridRect.x, gridRect.y);
        this.paintCard(graphics, cardStart, cardSize, false);
        Point dragCardPosition = this.getDragCardPosition(phase, phaseFraction, gridRect);
        if (dragCardPosition != null) {
            this.paintCard(graphics, dragCardPosition, cardSize, phase == Phase.MOVE_CARD);
        }
        Point cursorPosition = this.getCursorPosition(phase, phaseFraction, gridRect);
        BufferedImage cursor = phase == Phase.MOVE_CARD || cursorPosition.y < yCenter ? MOVE_CURSOR : DEFAULT_CURSOR;
        this.paintCursor(graphics, cursor, cursorPosition);
        graphics.dispose();
        Composite oldComposite = g2.getComposite();
        float alpha = 0.0f;
        switch (phase) {
            case MOUSE_TO_CARD: {
                alpha = Math.min(1.0f, 4.0f * phaseFraction);
                break;
            }
            case MOUSE_FROM_CARD: {
                alpha = Math.min(1.0f, 4.0f * (1.0f - phaseFraction));
                break;
            }
            case MOVE_CARD: {
                alpha = 1.0f;
            }
        }
        g2.setComposite(AlphaComposite.getInstance(3, alpha *= 0.3f));
        g2.drawImage((Image)this.drawImage, this.boundaryRect.x + this.boundaryRect.width / 4, this.boundaryRect.y + this.boundaryRect.height / 4, null);
        g2.setComposite(oldComposite);
    }

    @Override
    protected void elapsedFractionChanged(float elapsedFraction) {
        this.elapsedFraction = elapsedFraction;
        this.repaintRequired();
    }

    @Override
    public void stop() {
        this.elapsedFraction = 0.0f;
        super.stop();
    }

    protected void repaintRequired() {
    }

    private Phase getPhase() {
        Phase[] phases = Phase.values();
        for (int i = 0; i < phases.length; ++i) {
            float phaseEnd;
            float phaseStart = phases[i].startFraction;
            float f = phaseEnd = i == phases.length - 1 ? 1.0f : phases[i + 1].startFraction;
            if (!(this.elapsedFraction >= phaseStart) || !(this.elapsedFraction < phaseEnd)) continue;
            return phases[i];
        }
        return null;
    }

    private float getPhaseFraction() {
        Phase[] phases = Phase.values();
        for (int i = 0; i < phases.length; ++i) {
            float phaseEnd;
            float phaseStart = phases[i].startFraction;
            float f = phaseEnd = i == phases.length - 1 ? 1.0f : phases[i + 1].startFraction;
            if (!(this.elapsedFraction >= phaseStart) || !(this.elapsedFraction < phaseEnd)) continue;
            return (float)MathUtils.rangeFraction(this.elapsedFraction, phaseStart, phaseEnd);
        }
        return 0.0f;
    }

    private void paintCard(Graphics2D g2, Point loc, Dimension size, boolean shadow) {
        if (shadow) {
            g2.setColor(SHADOW_COLOR);
            g2.fillRect(loc.x + 5, loc.y + 5, size.width, size.height);
        }
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(loc.x, loc.y, size.width, size.height);
        g2.setColor(Color.BLACK);
        g2.drawRect(loc.x, loc.y, size.width, size.height);
        g2.drawRect(loc.x + 3, loc.y + 3, size.width - 6, size.height - 6);
        g2.setColor(Color.WHITE);
        g2.drawRect(loc.x + 1, loc.y + 1, size.width - 2, size.height - 2);
        g2.drawRect(loc.x + 2, loc.y + 2, size.width - 4, size.height - 4);
    }

    private void paintCursor(Graphics2D g2, BufferedImage cursor, Point loc) {
        if (cursor == MOVE_CURSOR) {
            g2.drawImage((Image)cursor, loc.x - cursor.getWidth() / 2, loc.y - cursor.getHeight() / 2, null);
        } else {
            g2.drawImage((Image)cursor, loc.x, loc.y, null);
        }
    }

    private Point getCursorPosition(Phase phase, float phaseFraction, Rectangle gridRect) {
        int fromIndex = phase.ordinal();
        int toIndex = fromIndex + 1;
        int fromX = (int)((double)gridRect.x + (double)gridRect.width * CURSOR_STOPS_PROPORTIONAL[fromIndex].getX());
        int fromY = (int)((double)gridRect.y + (double)gridRect.height * CURSOR_STOPS_PROPORTIONAL[fromIndex].getY());
        int toX = (int)((double)gridRect.x + (double)gridRect.width * CURSOR_STOPS_PROPORTIONAL[toIndex].getX());
        int toY = (int)((double)gridRect.y + (double)gridRect.height * CURSOR_STOPS_PROPORTIONAL[toIndex].getY());
        float adjustedFraction = EASE_THROUGH_FUNC.getInterpFraction(phaseFraction);
        int xCur = (int)MathUtils.interpolate(adjustedFraction, fromX, toX);
        int yCur = (int)MathUtils.interpolate(adjustedFraction, fromY, toY);
        if (phase == Phase.MOVE_CARD) {
            yCur += this.getYDip(adjustedFraction, gridRect);
        }
        return new Point(xCur, yCur);
    }

    private Point getDragCardPosition(Phase phase, float phaseFraction, Rectangle gridRect) {
        int xCenter = gridRect.x + gridRect.width / 2;
        switch (phase) {
            case MOUSE_TO_CARD: {
                return null;
            }
            case MOUSE_FROM_CARD: {
                return new Point(xCenter, gridRect.y);
            }
            case MOVE_CARD: {
                float adjustedFraction = EASE_THROUGH_FUNC.getInterpFraction(phaseFraction);
                return new Point((int)MathUtils.interpolate(adjustedFraction, gridRect.x, xCenter), gridRect.y + this.getYDip(adjustedFraction, gridRect));
            }
        }
        return null;
    }

    private int getYDip(float moveFraction, Rectangle gridRect) {
        float dipAmount = (float)gridRect.height * 0.05f;
        return (int)((double)dipAmount * MathUtils.rangeFraction(Math.sin((double)moveFraction * Math.PI), 0.0, 1.0));
    }

    private static enum Phase {
        MOUSE_TO_CARD(0.7f),
        MOVE_CARD(0.8f),
        MOUSE_FROM_CARD(0.9f);

        private final float startFraction;

        private Phase(float startFraction) {
            this.startFraction = startFraction;
        }
    }
}

