/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.animation.AbstractAnimation;
import com.sodiumarc.patchwork.animation.Animation;
import com.sodiumarc.patchwork.animation.RampInterpFunction;
import com.sodiumarc.patchwork.animation.SineInterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponentListener;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.sound.SoundSequence;
import com.sodiumarc.patchwork.app.scenecomposer.sound.LayeredAudioPlayer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardShadow;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardShelves;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardStateManager;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewpointControls;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GameSaveData;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GameStateHistory;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.InstructionAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.LoadingProgressPainter;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.PlayingGrid;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.PlayingGridLayout;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.PlayingGridPainter;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.ShelfCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClock;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.SimulationClockListener;
import com.sodiumarc.patchwork.util.ClickOrDragEvent;
import com.sodiumarc.patchwork.util.ClickOrDragSensor;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.Filter;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class GridViewerPanel
extends TargetablePanel<ProjectComponent> {
    public static final Cursor HOTSPOT_CURSOR = Cursor.getPredefinedCursor(12);
    public static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    public static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    public static final int MILLIS_PER_TICK = 20;
    public static final int SHELF_SIZE = 3;
    private final CardViewerListener cardListener = new CardViewerListener(){

        @Override
        public void targetChanged(CardViewer source) {
            GridViewerPanel.this.updateMouseOverCard();
        }

        @Override
        public void infoChanged(CardViewer source) {
        }

        @Override
        public void locationChanged(CardViewer source) {
            GridViewerPanel.this.updateMouseOverCard();
        }

        @Override
        public void stateChanged(CardViewer source) {
            GridViewerPanel.this.updateMouseOverCard();
        }
    };
    private final ProjectComponentListener projectListener = new ProjectComponentListener(){

        @Override
        public void modified(List<ProjectComponent> modifiedPath) {
        }

        @Override
        public void childComponentRemoved(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            if (child instanceof Card) {
                GridViewerPanel.this.deleteCard((Card)child);
            }
        }

        @Override
        public void childComponentAdded(List<ProjectComponent> parentPath, ProjectComponent child, int index) {
            if (child instanceof Card) {
                GridViewerPanel.this.createCardViewer((Card)child);
            }
        }
    };
    private final boolean editMode;
    private final Dimension cardSize;
    private final PlayingGrid playingGrid;
    private final CardShelves cardShelves;
    private final PlayingGridLayout layout;
    private final PlayingGridPainter gridPainter;
    private final LoadingProgressPainter loadingProgressPainter;
    private final JFileChooser saveFileChooser;
    private final ClickOrDragSensor clickOrDragSensor;
    private final CardViewpointControls cardViewpointControls;
    private final CardStateManager cardStateManager;
    private final GameStateHistory gameStateHistory;
    private final SimulationClock simulationClock;
    private final LayeredAudioPlayer audioPlayer;
    private final InstructionAnimation instructionAnimation;
    private PatchworkProject project;
    private final Map<Card, CardViewer> cardViewers;
    private final List<GridViewerListener> listeners;
    private final List<CardMoveAnimation> cardMoveAnimations;
    private CardViewer selectedCardViewer;
    private GridCoords selectedGridCoords;
    private ShelfCoords selectedShelfCoords;
    private Point mouseCurrentLocation;
    private CardViewer draggingCard;
    private GridCoords dragStartGridCoords;
    private Point dragStartLocation;
    private Point dragCurrentLocation;
    private CardViewer mouseOverCard;
    private boolean inPrologue;
    private static long PROLOGUE_ANIM_DURATION = 2000L;
    private static final float PROLOGUE_LIFT_END = 0.2f;
    private static final float PROLOGUE_DROP_START = 0.6f;
    private static SineInterpFunction EASE_TO_FUNC = new SineInterpFunction(0, 1);
    private static SineInterpFunction EASE_FROM_FUNC = new SineInterpFunction(-1, 0);
    private static SineInterpFunction EASE_THROUGH_FUNC = new SineInterpFunction(-1, 1);
    private static final Logger LOGGER = Logger.getLogger(GridViewerPanel.class);

    public GridViewerPanel(Dimension cardSize, boolean editMode) {
        this.cardSize = cardSize;
        this.editMode = editMode;
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileSelectionMode(0);
        this.saveFileChooser.setMultiSelectionEnabled(false);
        this.saveFileChooser.resetChoosableFileFilters();
        this.saveFileChooser.addChoosableFileFilter(GameSaveData.SAVE_GAME_FILE_FILTER);
        this.loadingProgressPainter = new LoadingProgressPainter();
        this.playingGrid = new PlayingGrid(2, 2);
        this.cardShelves = new CardShelves(EnumSet.of(GridDirection.WEST, GridDirection.EAST), 3);
        this.layout = new PlayingGridLayout(2, 2, 3, cardSize);
        this.gridPainter = new PlayingGridPainter(this.layout, this, editMode);
        this.gridPainter.setInterpFunc(new RampInterpFunction(0.2f, 1.0f));
        if (editMode) {
            this.gridPainter.setFractionComplete(1.0f);
        }
        this.cardViewers = new HashMap<Card, CardViewer>();
        this.listeners = new ArrayList<GridViewerListener>();
        this.cardMoveAnimations = new ArrayList<CardMoveAnimation>();
        this.cardStateManager = new CardStateManager(this);
        this.cardStateManager.setEnabled(false);
        this.gameStateHistory = new GameStateHistory(this, 32);
        this.simulationClock = new SimulationClock(20);
        this.audioPlayer = new LayeredAudioPlayer(this.simulationClock);
        this.audioPlayer.start();
        this.instructionAnimation = new InstructionAnimation(){

            @Override
            protected void repaintRequired() {
                GridViewerPanel.this.repaint();
            }
        };
        this.instructionAnimation.setBoundaryRect(this.layout.getCellBounds(this, new GridCoords(1, 1)));
        this.setLayout(this.layout);
        Filter<MouseEvent> eventFilter = new Filter<MouseEvent>(){

            @Override
            public boolean accept(MouseEvent event) {
                return event.getButton() == 1 && !event.isShiftDown() && !event.isControlDown();
            }
        };
        this.clickOrDragSensor = new ClickOrDragSensor(this, 2.0, 200L, eventFilter){

            @Override
            protected void eventOccurred(ClickOrDragEvent event) {
                GridViewerPanel.this.onClickOrDrag(event);
            }
        };
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GridViewerPanel.this.onMouseMoved(e.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GridViewerPanel.this.onMouseExit();
            }
        });
        this.cardViewpointControls = new CardViewpointControls(this);
        this.cardViewpointControls.setEnabled(!editMode);
        this.selectedGridCoords = new GridCoords(0, 0);
        this.simulationClock.addListener(new SimulationClockListener(){

            @Override
            public void tick(int elapsedTicks, long elapsedMillis) {
                GridViewerPanel.this.updateDragAnimation(elapsedTicks, elapsedMillis);
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                GridViewerPanel.this.updateInstructionAnimation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public SimulationClock getSimulationClock() {
        return this.simulationClock;
    }

    public GameStateHistory getGameStateHistory() {
        return this.gameStateHistory;
    }

    public CardViewer getSelectedCardViewer() {
        return this.selectedCardViewer;
    }

    public LayeredAudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setOptionEnabled(CardViewer.Option option, boolean enabled) {
        for (CardViewer cardViewer : this.cardViewers.values()) {
            cardViewer.setOptionEnabled(option, enabled);
        }
    }

    public void toggleOption(CardViewer.Option option) {
        Iterator<CardViewer> i$ = this.cardViewers.values().iterator();
        while (i$.hasNext()) {
            CardViewer cardViewer;
            boolean wasEnabled = (cardViewer = i$.next()).isOptionEnabled(option);
            cardViewer.setOptionEnabled(option, !wasEnabled);
        }
    }

    public void setProject(PatchworkProject project) {
        this.cardStateManager.setEnabled(false);
        if (this.project != null) {
            this.project.removeListener(this.projectListener);
            for (Card card : this.project.getCards()) {
                this.deleteCard(card);
            }
        }
        this.project = project;
        if (this.project != null) {
            this.project.addListener(this.projectListener);
            for (Card card : project.getCards()) {
                this.createCardViewer(card);
            }
        }
        this.revalidate();
        this.cardStateManager.setEnabled(true);
    }

    public PatchworkProject getProject() {
        return this.project;
    }

    public void setLoadingPercent(int percentComplete) {
        this.loadingProgressPainter.setPercentComplete(percentComplete);
        this.repaint();
    }

    public void setShowLoadingPercent(boolean showLoadingPercent) {
        this.loadingProgressPainter.setVisible(showLoadingPercent);
        this.repaint();
    }

    public void setTitleImage(BufferedImage titleImage) {
        this.loadingProgressPainter.setTitleImage(titleImage);
    }

    public boolean isInPrologue() {
        return this.inPrologue;
    }

    public void setInPrologue(boolean inPrologue, boolean animate) {
        if (inPrologue != this.inPrologue) {
            this.inPrologue = inPrologue;
            this.instructionAnimation.stop();
            if (inPrologue) {
                this.layout.setRows(1);
                this.layout.setColumns(1);
                this.gridPainter.setFractionComplete(0.0f);
            } else if (animate) {
                CardViewer cardViewer = this.cardViewers.get(this.playingGrid.getTopCard(GridCoords.ORIGIN));
                Point location = this.layout.getCellLocation(this, GridCoords.ORIGIN);
                if (cardViewer != null) {
                    this.removeCardFromGrid(cardViewer, false);
                }
                this.layout.setRows(2);
                this.layout.setColumns(2);
                GridInitAnimation gridAnimation = new GridInitAnimation();
                gridAnimation.setDurationInMillis(PROLOGUE_ANIM_DURATION);
                gridAnimation.start();
                if (cardViewer != null) {
                    CardMoveAnimation shuffleAnim = new CardMoveAnimation(CardAnimationType.PROLOGUE_TRANSITION, cardViewer, location, GridCoords.ORIGIN);
                    this.cardMoveAnimations.add(shuffleAnim);
                    shuffleAnim.start();
                }
                this.updateInstructionAnimation();
                this.instructionAnimation.setLoop(true);
                this.instructionAnimation.setDurationInMillis(PROLOGUE_ANIM_DURATION * 4L);
                this.instructionAnimation.start();
            } else {
                this.layout.setRows(2);
                this.layout.setColumns(2);
                this.gridPainter.setFractionComplete(1.0f);
            }
            this.clickOrDragSensor.setDragEnabled(!inPrologue);
            this.repaint();
            this.gameStateHistory.clear();
            this.gameStateHistory.captureCurrentState();
        }
    }

    public CardViewer getCardViewer(Card card) {
        return this.cardViewers.get(card);
    }

    public Collection<CardViewer> getCardViewers() {
        return this.cardViewers.values();
    }

    public boolean isOnGrid(Card card) {
        return this.playingGrid.getCoords(card) != null;
    }

    public GridCoords getCoords(Card card) {
        return this.playingGrid.getCoords(card);
    }

    public boolean isInPlay(Card card) {
        return this.cardViewers.get(card).isInPlay();
    }

    public boolean isMouseOver(Card card) {
        return CompareUtilities.equals(this.cardViewers.get(card), this.mouseOverCard);
    }

    public boolean isCaptured(Card card) {
        CardViewer cardViewer = this.cardViewers.get(card);
        for (CardViewer otherCardViewer : this.cardViewers.values()) {
            if (!otherCardViewer.isUnderCapturedCard(cardViewer) && !otherCardViewer.isOverCapturedCard(cardViewer)) continue;
            return true;
        }
        return false;
    }

    public Card getUnderCard(Card card) {
        GridCoords coords = this.playingGrid.getCoords(card);
        if (coords == null) {
            return null;
        }
        return this.playingGrid.getUnderCard(coords);
    }

    public boolean isOver(Card overCard, Card underCard) {
        return underCard.equals(this.getUnderCard(overCard));
    }

    public boolean isCardMoveInProgress() {
        if (this.isDragInProgress()) {
            return true;
        }
        for (CardMoveAnimation animation : this.cardMoveAnimations) {
            if (!animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    public boolean isDragInProgress() {
        return this.draggingCard != null;
    }

    public void clearGrid() {
        for (CardViewer cardViewer : this.getCardViewers()) {
            this.remove(cardViewer.getPanel());
            cardViewer.setInPlay(false);
            this.playingGrid.removeCard(cardViewer.getCard());
        }
        this.setSelectedCard(null);
    }

    public void playOpeningScore(PatchworkProject project) {
        SoundSequence openingScore;
        if (project != null && (openingScore = project.getOpeningScore()) != null) {
            if (!this.simulationClock.isRunning()) {
                this.simulationClock.start();
            }
            this.audioPlayer.playSequence(openingScore, true);
        }
    }

    public void restart() {
        this.setProject(this.project);
        if (this.project != null) {
            this.audioPlayer.stopAllLayers();
            this.playOpeningScore(this.project);
            this.newGame();
        }
    }

    public void newGame() {
        this.cardStateManager.setEnabled(false);
        this.clearGrid();
        this.setSelectedGridCoords(GridCoords.ORIGIN);
        if (this.project != null) {
            Card startingCard = this.project.getStartingCard();
            if (startingCard == null) {
                ArrayList<Card> cards = new ArrayList<Card>(this.project.getCards());
                Collections.sort(cards);
                startingCard = CollectionUtils.first(cards);
            }
            boolean inPrologue = this.project.getPrologueEndState() != null;
            this.setInPrologue(inPrologue, true);
            this.setTarget(startingCard);
        }
        this.setSelectedCard(null);
        this.cardStateManager.setEnabled(true);
        this.gameStateHistory.clear();
        this.gameStateHistory.captureCurrentState();
    }

    public void saveGame() {
        File saveDir = PatchworkComposerProperties.SAVEGAME_DIR.getFile();
        int saveIndex = 1;
        String stem = "SaveGame";
        while (new File(saveDir, FileUtils.addExtension(stem + saveIndex, "sav")).exists()) {
            ++saveIndex;
        }
        String filename = FileUtils.addExtension(stem + saveIndex, "sav");
        this.saveFileChooser.setSelectedFile(new File(saveDir, filename));
        int result = this.saveFileChooser.showSaveDialog(SwingUtilities.getRoot(this));
        if (result == 0) {
            int confirm;
            File file = this.saveFileChooser.getSelectedFile();
            if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Confirm Overwrite", 0)) != 0) {
                return;
            }
            GameSaveData saveData = this.getGameSaveData();
            saveData.writeToFile(file);
        }
    }

    public void loadGame() {
        File file;
        this.saveFileChooser.setCurrentDirectory(PatchworkComposerProperties.SAVEGAME_DIR.getFile());
        int result = this.saveFileChooser.showOpenDialog(SwingUtilities.getRoot(this));
        if (result == 0 && (file = this.saveFileChooser.getSelectedFile()).exists()) {
            GameSaveData saveData = null;
            try {
                saveData = GameSaveData.loadFromFile(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            if (saveData != null) {
                this.gameStateHistory.clear();
                this.loadGame(saveData);
                this.gameStateHistory.captureCurrentState();
            }
        }
    }

    public GameSaveData getGameSaveData() {
        return new GameSaveData(this);
    }

    public void loadGame(GameSaveData saveData) {
        CardViewer cardViewer;
        Card card;
        this.cardStateManager.setEnabled(false);
        this.instructionAnimation.stop();
        this.clearGrid();
        this.audioPlayer.stopAllLayers();
        List<CardSaveData> cardSaves = saveData.getCardSaveData(this.project);
        for (CardSaveData cardSaveData : cardSaves) {
            card = cardSaveData.getCard();
            cardViewer = this.createCardViewer(card);
            cardViewer.prepareForDisplay();
            cardViewer.setTarget(null);
            cardViewer.resetStates();
            cardViewer.setStates(cardSaveData.getLayerStates(), false);
        }
        for (CardSaveData cardSaveData : cardSaves) {
            card = cardSaveData.getCard();
            cardViewer = this.getCardViewer(card);
            SceneLocation savedLocation = cardSaveData.getSceneLocation();
            if (savedLocation != null) {
                cardViewer.setTarget(savedLocation);
                continue;
            }
            cardViewer.setTarget(card.getStartingLocation());
        }
        for (CardSaveData cardSaveData : cardSaves) {
            card = cardSaveData.getCard();
            cardViewer = this.getCardViewer(card);
            cardViewer.clearUnderCapturedCards();
            for (Card underCard : cardSaveData.getUnderCards()) {
                cardViewer.addUnderCapturedCard(this.getCardViewer(underCard));
            }
            cardViewer.clearOverCapturedCards();
            for (Card overCard : cardSaveData.getOverCards()) {
                cardViewer.addOverCapturedCard(this.getCardViewer(overCard));
            }
            cardViewer.setInPlay(cardSaveData.isInPlay());
        }
        for (CardSaveData cardSaveData : cardSaves) {
            CardViewer cardViewer2 = this.cardViewers.get(cardSaveData.getCard());
            GridCoords coords = cardSaveData.getGridCoords();
            if (coords == null) continue;
            this.addCardToGrid(cardViewer2, coords);
        }
        this.setInPrologue(saveData.isInPrologue(), false);
        Card selectedCard = saveData.getSelectedCard(this.project);
        if (selectedCard != null) {
            this.setSelectedCard(this.cardViewers.get(selectedCard));
        }
        this.audioPlayer.loadSaveData(saveData.getAudioSaveData(this.project));
        if (!this.simulationClock.isRunning()) {
            this.simulationClock.start();
        }
        this.cardStateManager.setEnabled(true);
    }

    public void addGridListener(GridViewerListener listener) {
        this.listeners.add(listener);
    }

    public void removeCardListener(GridViewerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void targetSet() {
        ProjectComponent target = (ProjectComponent)this.getTarget();
        if (target == null) {
            return;
        }
        Card card = target.getAncestorByType(Card.class);
        if (card == null) {
            return;
        }
        CardViewer cardViewer = this.cardViewers.get(card);
        if (cardViewer == null) {
            cardViewer = this.createCardViewer(card);
        }
        if (cardViewer != null) {
            if (target.getAncestorByType(SceneLocation.class) != null) {
                cardViewer.setTarget(target);
            }
            this.setSelectedCard(cardViewer);
            if (!this.isInPlay(card) && !this.isCaptured(card) && this.selectedGridCoords != null) {
                this.addCardToGrid(cardViewer, this.selectedGridCoords);
            }
        }
        if (!this.simulationClock.isRunning()) {
            this.simulationClock.start();
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        this.gridPainter.paint((Graphics2D)g);
        if (this.instructionAnimation.isRunning()) {
            this.instructionAnimation.paint((Graphics2D)g);
        }
        this.paintChildren(g);
        this.paintDragLayer((Graphics2D)g);
        this.loadingProgressPainter.paint((Graphics2D)g, this.layout.getCellLocation(this, new GridCoords(0, 0)));
    }

    private void fireSelectionChanged(CardViewer cardViewer) {
        for (GridViewerListener listener : this.listeners) {
            listener.selectionChanged(this, cardViewer);
        }
    }

    private void fireMouseOverChanged(CardViewer cardViewer) {
        for (GridViewerListener listener : this.listeners) {
            listener.mouseOverChanged(this, cardViewer);
        }
    }

    private void fireGridContentsChanged() {
        for (GridViewerListener listener : this.listeners) {
            listener.gridContentsChanged(this);
        }
    }

    private void setSelectedGridCoords(GridCoords coords) {
        this.selectedGridCoords = coords;
        this.selectedShelfCoords = null;
        this.gridPainter.setSelectedGridCoords(coords);
    }

    private void setSelectedShelfCoords(ShelfCoords coords) {
        this.selectedShelfCoords = coords;
        this.selectedGridCoords = null;
        this.gridPainter.setSelectedShelfCoords(coords);
    }

    private void setSelectedCard(CardViewer cardViewer) {
        if (this.selectedCardViewer != null) {
            this.selectedCardViewer.setSelected(false);
        }
        this.selectedCardViewer = cardViewer;
        if (this.selectedCardViewer != null) {
            this.selectedCardViewer.setSelected(true);
        }
        if (this.editMode) {
            this.cardViewpointControls.setCardViewer(this.selectedCardViewer);
        }
        this.fireSelectionChanged(cardViewer);
    }

    private CardViewer createCardViewer(Card card) {
        CardViewer cardViewer = this.cardViewers.get(card);
        if (cardViewer == null) {
            cardViewer = new CardViewer(card, this.cardSize, this);
            this.cardViewers.put(card, cardViewer);
            this.cardStateManager.addCard(cardViewer);
            cardViewer.addCardListener(this.cardListener);
        }
        return cardViewer;
    }

    private void deleteCard(Card card) {
        CardViewer cardViewer = this.cardViewers.get(card);
        if (cardViewer != null) {
            this.removeCardFromGrid(cardViewer, false);
            this.cardViewers.remove(card);
            this.cardStateManager.removeCard(cardViewer);
            cardViewer.removeCardListener(this.cardListener);
        }
    }

    private void addCardToGrid(CardViewer cardViewer, GridCoords coords) {
        if (this.playingGrid.getCoords(cardViewer.getCard()) != null) {
            return;
        }
        if (this.cardShelves.getCoords(cardViewer.getCard()) != null) {
            return;
        }
        Card underCard = this.playingGrid.getTopCard(coords);
        boolean captured = false;
        if (underCard != null) {
            CardViewer underCardViewer = this.cardViewers.get(underCard);
            if (this.overCapturesUnder(cardViewer, underCard)) {
                underCardViewer.setInPlay(false);
                this.playingGrid.removeCard(underCard);
                cardViewer.addUnderCapturedCard(underCardViewer);
                this.remove(underCardViewer.getPanel());
            } else if (this.underCapturesOver(cardViewer.getCard(), underCardViewer)) {
                cardViewer.setInPlay(false);
                underCardViewer.addOverCapturedCard(cardViewer);
                captured = true;
            }
        }
        if (!captured) {
            this.playingGrid.placeCard(cardViewer.getCard(), coords);
            this.layout.setComponentCoords((Component)cardViewer.getPanel(), coords);
            this.add(cardViewer.getPanel());
            cardViewer.setCurrentGridCoords(coords, true);
            cardViewer.setInPlay(true);
            cardViewer.prepareForDisplay();
        }
        if (coords.equals(this.selectedGridCoords)) {
            this.setSelectedGridCoords(this.playingGrid.getEmptyCell());
        }
        this.updateMouseOverCard();
        this.validate();
        this.repaint();
        this.fireGridContentsChanged();
    }

    private GridCoords removeCardFromGrid(CardViewer cardViewer, boolean byUser) {
        Card releasedCard;
        this.remove(cardViewer.getPanel());
        GridCoords coords = this.playingGrid.removeCard(cardViewer.getCard());
        if (coords == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(cardViewer.getCard());
        }
        Card newTopCard = this.playingGrid.getTopCard(coords);
        if (byUser && (releasedCard = this.getReleasedUnderCard(cardViewer)) != null) {
            cardViewer.removeUnderCapturedCard(this.cardViewers.get(releasedCard));
            this.playingGrid.placeCard(releasedCard, coords);
            newTopCard = releasedCard;
        }
        if (newTopCard != null) {
            CardViewer newTopViewer = this.cardViewers.get(newTopCard);
            this.layout.setComponentCoords((Component)newTopViewer.getPanel(), coords);
            newTopViewer.prepareForDisplay();
            newTopViewer.setCurrentGridCoords(coords, true);
            newTopViewer.setInPlay(true);
            this.add(newTopViewer.getPanel());
        }
        this.updateMouseOverCard();
        this.validate();
        this.fireGridContentsChanged();
        return coords;
    }

    private void addCardToShelf(CardViewer cardViewer, ShelfCoords coords) {
        if (this.playingGrid.getCoords(cardViewer.getCard()) != null) {
            LOGGER.warn("Attempt to place card on shelf that is already on grid: " + cardViewer.getCard());
            return;
        }
        if (this.cardShelves.getCoords(cardViewer.getCard()) != null) {
            LOGGER.warn("Attempt to place card on shelf that is already on shelf: " + cardViewer.getCard());
            return;
        }
        if (this.cardShelves.getCard(coords) != null) {
            LOGGER.warn("Attempt to place card at occupied shelf coords: " + cardViewer.getCard());
            return;
        }
        Card card = cardViewer.getCard();
        this.cardShelves.placeCard(card, coords);
        this.layout.setComponentCoords((Component)cardViewer.getPanel(), coords);
        this.add(cardViewer.getPanel());
        cardViewer.setCurrentGridCoords(null, true);
        cardViewer.setInPlay(true);
        cardViewer.prepareForDisplay();
        if (coords.equals(this.selectedGridCoords)) {
            this.setSelectedGridCoords(this.playingGrid.getEmptyCell());
        }
    }

    private Card getReleasedUnderCard(CardViewer cardViewer) {
        for (CardLink cardLink : cardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.UNDER || !this.cardStateManager.isSatisfied(cardLink)) continue;
            return cardLink.getOtherCard();
        }
        return null;
    }

    private Card getReleasedOverCard(CardViewer cardViewer) {
        for (CardLink cardLink : cardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.OVER || !this.cardStateManager.isSatisfied(cardLink)) continue;
            return cardLink.getOtherCard();
        }
        return null;
    }

    private boolean overCapturesUnder(CardViewer overCardViewer, Card underCard) {
        for (CardLink cardLink : overCardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.UNDER || !underCard.equals(cardLink.getOtherCard())) continue;
            return true;
        }
        return false;
    }

    private boolean underCapturesOver(Card overCard, CardViewer underCardViewer) {
        for (CardLink cardLink : underCardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.OVER || !overCard.equals(cardLink.getOtherCard())) continue;
            return true;
        }
        return false;
    }

    private void onMouseMoved(Point point) {
        this.mouseCurrentLocation = point;
        this.updateMouseOverCard();
    }

    private void onMouseExit() {
        this.mouseCurrentLocation = null;
        this.updateMouseOverCard();
    }

    private void updateMouseOverCard() {
        boolean mouseOverEnabled;
        CardViewer newMouseOverCard = null;
        Point relativeLocation = null;
        boolean bl = mouseOverEnabled = !this.isCardMoveInProgress();
        if (mouseOverEnabled && this.mouseCurrentLocation != null) {
            GridCoords gridCoords = this.layout.getCellCoords(this, this.mouseCurrentLocation, false);
            if (gridCoords != null) {
                Rectangle cellBounds = this.layout.getCellBounds(this, gridCoords);
                Point cellLocation = cellBounds.getLocation();
                relativeLocation = new Point(this.mouseCurrentLocation);
                relativeLocation.translate(-cellLocation.x, -cellLocation.y);
            }
            Card card = gridCoords == null ? null : this.playingGrid.getTopCard(gridCoords);
            CardViewer cardViewer = newMouseOverCard = card == null ? null : this.cardViewers.get(card);
        }
        if (!CompareUtilities.equals(newMouseOverCard, this.mouseOverCard)) {
            if (this.mouseOverCard != null) {
                this.mouseOverCard.setMouseOverPosition(null);
            }
            this.mouseOverCard = newMouseOverCard;
            this.fireMouseOverChanged(newMouseOverCard);
        }
        if (this.mouseOverCard != null) {
            this.mouseOverCard.setMouseOverPosition(relativeLocation);
        }
        Cursor cursor = Cursor.getDefaultCursor();
        if (this.draggingCard != null) {
            cursor = MOVE_CURSOR;
        } else if (this.mouseOverCard != null && relativeLocation != null) {
            if (!this.mouseOverCard.isInteractionEnabled()) {
                cursor = WAIT_CURSOR;
            } else if (this.mouseOverCard.getHotspotForLocation(relativeLocation) != null) {
                cursor = HOTSPOT_CURSOR;
            } else if (!this.inPrologue) {
                cursor = MOVE_CURSOR;
            }
        }
        if (!CompareUtilities.equals(cursor, this.getCursor())) {
            this.setCursor(cursor);
        }
    }

    private void onClickOrDrag(ClickOrDragEvent event) {
        if (!this.cardMoveAnimations.isEmpty()) {
            return;
        }
        this.mouseCurrentLocation = event.getLocation();
        switch (event.getType()) {
            case CLICKED: {
                this.onClick(event.getLocation());
                break;
            }
            case DRAG_STARTED: {
                CardViewer cardViewer;
                GridCoords gridCoords = this.layout.getCellCoords(this, event.getLocation(), false);
                if (gridCoords == null) {
                    return;
                }
                Rectangle cellBounds = this.layout.getCellBounds(this, gridCoords);
                Point cellLocation = cellBounds.getLocation();
                Card card = this.playingGrid.getTopCard(gridCoords);
                if (card == null || !(cardViewer = this.getCardViewer(card)).isInteractionEnabled()) break;
                Card releasedCard = this.getReleasedOverCard(cardViewer);
                if (releasedCard != null) {
                    CardViewer releasedCardViewer = this.cardViewers.get(releasedCard);
                    cardViewer.removeOverCapturedCard(releasedCardViewer);
                    releasedCardViewer.prepareForDisplay();
                    releasedCardViewer.setInPlay(true);
                    this.draggingCard = releasedCardViewer;
                    this.fireGridContentsChanged();
                } else {
                    this.draggingCard = cardViewer;
                    this.removeCardFromGrid(cardViewer, true);
                }
                this.setSelectedCard(cardViewer);
                this.dragStartGridCoords = gridCoords;
                this.dragCurrentLocation = this.dragStartLocation = cellLocation;
                this.draggingCard.setCurrentGridCoords(gridCoords, false);
                this.draggingCard.getShadow().setHeight(0.0f);
                break;
            }
            case DRAGGED: {
                if (this.draggingCard == null) break;
                this.dragCurrentLocation = new Point(this.dragStartLocation);
                Point delta = event.getDelta();
                this.dragCurrentLocation.translate(delta.x, delta.y);
                Rectangle originCellBounds = this.layout.getCellBounds(this, new GridCoords(0, 0));
                this.dragCurrentLocation.x = MathUtils.clamp(this.dragCurrentLocation.x, originCellBounds.x, originCellBounds.x + originCellBounds.width);
                this.dragCurrentLocation.y = MathUtils.clamp(this.dragCurrentLocation.y, originCellBounds.y, originCellBounds.y + originCellBounds.height);
                this.draggingCard.setCurrentGridCoords(this.layout.getCellCoords(this, this.dragCurrentLocation, true), false);
                break;
            }
            case DRAG_ENDED: {
                if (this.draggingCard == null) break;
                GridCoords dropCoords = this.layout.getClosestCornerCoords(this, this.dragCurrentLocation);
                Card existing = this.playingGrid.getTopCard(dropCoords);
                AbstractAnimation shuffleAnim = null;
                if (existing != null && !this.canStack(this.draggingCard.getCard(), existing)) {
                    CardViewer existingViewer = this.cardViewers.get(existing);
                    if (!existingViewer.isInteractionEnabled()) {
                        dropCoords = this.dragStartGridCoords;
                    } else if (this.getUnderCard(existing) != null || existingViewer.getLinkedDirs().contains((Object)GridDirection.UNDER)) {
                        dropCoords = this.dragStartGridCoords;
                    } else {
                        GridCoords shuffleCoords = this.playingGrid.getEmptyCell();
                        if (shuffleCoords == null) {
                            dropCoords = this.dragStartGridCoords;
                        } else {
                            this.removeCardFromGrid(existingViewer, false);
                            shuffleAnim = new CardMoveAnimation(CardAnimationType.HOP, existingViewer, dropCoords, shuffleCoords);
                            this.cardMoveAnimations.add((CardMoveAnimation)shuffleAnim);
                            shuffleAnim.start();
                        }
                    }
                }
                CardMoveAnimation dropAnim = new CardMoveAnimation(CardAnimationType.DROP, this.draggingCard, this.dragCurrentLocation, dropCoords);
                if (shuffleAnim != null) {
                    dropAnim.setDurationInMillis(shuffleAnim.getDurationInMillis());
                }
                this.cardMoveAnimations.add(dropAnim);
                dropAnim.start();
                this.draggingCard = null;
                this.dragStartGridCoords = null;
                this.dragStartLocation = null;
                this.dragCurrentLocation = null;
                this.instructionAnimation.stop();
            }
        }
        this.updateMouseOverCard();
        this.repaint();
    }

    private void onClick(Point location) {
        GridCoords gridCoords = this.layout.getCellCoords(this, location, false);
        ShelfCoords shelfCoords = this.layout.getShelfCoords(this, location);
        if (gridCoords != null) {
            Rectangle cellBounds = this.layout.getCellBounds(this, gridCoords);
            Point cellLocation = cellBounds.getLocation();
            Point relativeLocation = new Point(location);
            relativeLocation.translate(-cellLocation.x, -cellLocation.y);
            Card card = this.playingGrid.getTopCard(gridCoords);
            CardViewer cardViewer = null;
            if (card != null) {
                cardViewer = this.cardViewers.get(card);
                LocationTransition hotspot = cardViewer.getHotspotForLocation(relativeLocation);
                if (hotspot != null && cardViewer.isInteractionEnabled()) {
                    cardViewer.activateTransition(hotspot);
                }
                this.setSelectedCard(cardViewer);
            } else {
                this.setSelectedGridCoords(gridCoords.equals(this.selectedGridCoords) ? null : gridCoords);
            }
        } else if (shelfCoords != null) {
            this.setSelectedShelfCoords(shelfCoords.equals(this.selectedShelfCoords) ? null : shelfCoords);
        } else {
            block0: for (int col = 0; col < this.layout.getColumns(); ++col) {
                for (int row = 0; row < this.layout.getRows(); ++row) {
                    GridCoords coords = new GridCoords(row, col);
                    Rectangle delButtonBounds = this.gridPainter.getDeleteButtonBounds(coords);
                    if (!delButtonBounds.contains(location)) continue;
                    Card card = this.playingGrid.getTopCard(coords);
                    if (card == null) continue block0;
                    this.removeCardFromGrid(this.cardViewers.get(card), false);
                    continue block0;
                }
            }
        }
    }

    private boolean canStack(Card over, Card under) {
        CardViewer overCardViewer = this.cardViewers.get(over);
        for (CardLink cardLink : overCardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.UNDER || !under.equals(cardLink.getOtherCard()) || !this.cardStateManager.predicatesAreSatisfied(cardLink)) continue;
            return true;
        }
        CardViewer underCardViewer = this.cardViewers.get(under);
        for (CardLink cardLink : underCardViewer.getActiveCardLinks()) {
            if (cardLink.getDirection() != GridDirection.OVER || !over.equals(cardLink.getOtherCard()) || !this.cardStateManager.predicatesAreSatisfied(cardLink)) continue;
            return true;
        }
        return false;
    }

    private void paintDragLayer(Graphics2D g2) {
        if (this.draggingCard != null) {
            this.paintFloatingCard(g2, this.draggingCard, this.dragCurrentLocation);
        } else {
            for (CardMoveAnimation animation : this.cardMoveAnimations) {
                animation.paint(g2);
            }
        }
    }

    private void paintFloatingCard(Graphics2D g2, CardViewer cardViewer, Point location) {
        Rectangle cellBounds = this.layout.getCellBounds(this, new GridCoords(0, 0));
        cardViewer.getPanel().setBounds(cellBounds);
        cardViewer.getShadow().paint(g2, location.x, location.y);
        AffineTransform oldTransform = g2.getTransform();
        AffineTransform dragTransform = new AffineTransform();
        dragTransform.setToTranslation(location.x, location.y);
        g2.transform(dragTransform);
        cardViewer.getImagePanel().paint(g2);
        g2.setTransform(oldTransform);
    }

    private void updateDragAnimation(int elapsedTicks, long elapsedMillis) {
        if (this.draggingCard != null) {
            CardShadow cardShadow = this.draggingCard.getShadow();
            boolean repaintNeeded = this.draggingCard.isAnimating();
            if (cardShadow.getHeight() < (float)cardShadow.getMaxHeight()) {
                cardShadow.setHeight(cardShadow.getHeight() + 2.0f);
                repaintNeeded = true;
            }
            if (repaintNeeded) {
                this.repaint();
            }
        }
        Iterator<CardMoveAnimation> iter = this.cardMoveAnimations.iterator();
        while (iter.hasNext()) {
            CardMoveAnimation animation = iter.next();
            if (animation.isRunning()) continue;
            iter.remove();
        }
        this.updateMouseOverCard();
    }

    private void updateInstructionAnimation() {
        this.instructionAnimation.setBoundaryRect(this.layout.getCellBounds(this, new GridCoords(1, 1)));
    }

    private static enum CardAnimationType {
        DROP,
        HOP,
        PROLOGUE_TRANSITION;

    }

    private class CardMoveAnimation
    extends AbstractAnimation {
        private final CardAnimationType mode;
        private final CardViewer cardViewer;
        private final GridCoords endCoords;
        private final Point startLocation;
        private final Point endLocation;
        private final Point currentLocation;
        private final float startHeight;
        private final int maxHeight;

        public CardMoveAnimation(CardAnimationType mode, CardViewer cardViewer, GridCoords startCoords, GridCoords endCoords) {
            this(mode, cardViewer, gridViewerPanel.layout.getCellLocation(gridViewerPanel, startCoords), endCoords);
        }

        public CardMoveAnimation(CardAnimationType mode, CardViewer cardViewer, Point startLocation, GridCoords endCoords) {
            this.mode = mode;
            this.cardViewer = cardViewer;
            this.startLocation = startLocation;
            this.endCoords = endCoords;
            this.endLocation = GridViewerPanel.this.layout.getCellLocation(GridViewerPanel.this, endCoords);
            this.currentLocation = new Point(startLocation);
            this.startHeight = cardViewer.getShadow().getHeight();
            this.maxHeight = cardViewer.getShadow().getMaxHeight();
            double distance = startLocation.distance(this.endLocation);
            long duration = mode == CardAnimationType.PROLOGUE_TRANSITION ? PROLOGUE_ANIM_DURATION : (long)MathUtils.clamp((int)(distance * 2.0), 100, 300);
            this.setDurationInMillis(duration);
        }

        void paint(Graphics2D g2) {
            if (this.isRunning()) {
                GridViewerPanel.this.paintFloatingCard(g2, this.cardViewer, this.currentLocation);
            }
        }

        @Override
        protected void elapsedFractionChanged(float elapsedFraction) {
            Point current;
            this.cardViewer.getShadow().setHeight(this.getHeight(elapsedFraction));
            if (this.mode == CardAnimationType.PROLOGUE_TRANSITION) {
                if (elapsedFraction < 0.6f) {
                    current = this.startLocation;
                } else {
                    elapsedFraction = (float)MathUtils.rangeFraction(elapsedFraction, 0.6f, 1.0);
                    current = this.getLocation(this.startLocation, this.endLocation, elapsedFraction);
                }
            } else {
                current = this.getLocation(this.startLocation, this.endLocation, elapsedFraction);
            }
            this.currentLocation.setLocation(current);
            this.cardViewer.setCurrentGridCoords(GridViewerPanel.this.layout.getCellCoords(GridViewerPanel.this, this.currentLocation, true), false);
            GridViewerPanel.this.repaint();
        }

        @Override
        protected void animationStopped(Animation source) {
            GridViewerPanel.this.addCardToGrid(this.cardViewer, this.endCoords);
        }

        private Point getLocation(Point start, Point end, float elapsedFraction) {
            elapsedFraction = this.mode == CardAnimationType.DROP ? EASE_TO_FUNC.getInterpFraction(elapsedFraction) : EASE_THROUGH_FUNC.getInterpFraction(elapsedFraction);
            int x = (int)MathUtils.interpolate(EASE_TO_FUNC.getInterpFraction(elapsedFraction), this.startLocation.x, this.endLocation.x);
            int y = (int)MathUtils.interpolate(EASE_FROM_FUNC.getInterpFraction(elapsedFraction), this.startLocation.y, this.endLocation.y);
            return new Point(x, y);
        }

        private float getHeight(float elapsedFraction) {
            switch (this.mode) {
                case DROP: {
                    return (float)MathUtils.interpolate(elapsedFraction, this.startHeight, 0.0);
                }
                case HOP: {
                    double angle = MathUtils.interpolate(elapsedFraction, 0.0, Math.PI);
                    return (float)(Math.sin(angle) * 0.5 * (double)this.maxHeight);
                }
                case PROLOGUE_TRANSITION: {
                    if (elapsedFraction <= 0.2f) {
                        elapsedFraction = (float)MathUtils.rangeFraction(elapsedFraction, 0.0, 0.2f);
                        return EASE_THROUGH_FUNC.getInterpFraction(elapsedFraction) * (float)this.maxHeight;
                    }
                    if (elapsedFraction < 0.6f) {
                        return this.maxHeight;
                    }
                    elapsedFraction = 1.0f - (float)MathUtils.rangeFraction(elapsedFraction, 0.6f, 1.0);
                    return EASE_TO_FUNC.getInterpFraction(elapsedFraction) * (float)this.maxHeight;
                }
            }
            return 0.0f;
        }
    }

    private class GridInitAnimation
    extends AbstractAnimation {
        private GridInitAnimation() {
        }

        @Override
        protected void elapsedFractionChanged(float elapsedFraction) {
            GridViewerPanel.this.gridPainter.setFractionComplete(elapsedFraction);
            GridViewerPanel.this.repaint();
        }
    }

    public static enum SoundLayer {
        SCORE,
        AMBIENT,
        SFX;

    }
}

