/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

public class GridCoords {
    public static final GridCoords ORIGIN = new GridCoords(0, 0);
    public static final GridCoords UNIT_DIM = new GridCoords(1, 1);
    private final double row;
    private final double col;

    public GridCoords(String encodedForm) {
        String[] components = encodedForm.split(",");
        assert (components.length == 2) : "Wrong number of components: " + components.length;
        this.row = Double.valueOf(components[0]);
        this.col = Double.valueOf(components[1]);
    }

    public GridCoords(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public GridCoords(double row, double col) {
        this.row = row;
        this.col = col;
    }

    public int getRow() {
        return (int)Math.floor(this.row);
    }

    public int getCol() {
        return (int)Math.floor(this.col);
    }

    public double getRowDouble() {
        return this.row;
    }

    public double getColDouble() {
        return this.col;
    }

    public String encode() {
        return this.row + "," + this.col;
    }

    public String toString() {
        return "GridCoords [row=" + this.row + ", col=" + this.col + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.col;
        result = 31 * result + (int)this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridCoords other = (GridCoords)obj;
        if (this.col != other.col) {
            return false;
        }
        return this.row == other.row;
    }
}

