/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer.viewer;

import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.PatchworkProject;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.LocationTransition;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.StateTransition;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.BooleanFormulaParser;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewer;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.CardViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridCoords;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerListener;
import com.sodiumarc.patchwork.app.scenecomposer.viewer.GridViewerPanel;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CardStateManager {
    private CardViewerListener cardListener = new CardViewerListener(){

        @Override
        public void stateChanged(CardViewer source) {
            CardStateManager.this.update();
        }

        @Override
        public void locationChanged(CardViewer source) {
            CardStateManager.this.update();
            if (CardStateManager.this.isEnabled() && source.getTarget() instanceof SceneLocation) {
                CardStateManager.this.captureGameState();
            }
        }

        @Override
        public void infoChanged(CardViewer source) {
        }

        @Override
        public void targetChanged(CardViewer source) {
            if (source.getTarget() instanceof LocationTransition) {
                CardStateManager.this.update();
            }
        }
    };
    private final BooleanFormulaParser booleanFormulaParser;
    private final List<CardViewer> cardViewers;
    private final GridViewerPanel gridViewer;
    private boolean enabled = true;
    private static final Logger LOGGER = Logger.getLogger(CardStateManager.class);

    public CardStateManager(GridViewerPanel gridViewer) {
        this.gridViewer = gridViewer;
        this.cardViewers = new ArrayList<CardViewer>();
        this.booleanFormulaParser = new BooleanFormulaParser();
        gridViewer.addGridListener(new GridViewerListener(){

            @Override
            public void selectionChanged(GridViewerPanel source, CardViewer cardViewer) {
            }

            @Override
            public void gridContentsChanged(GridViewerPanel source) {
                CardStateManager.this.update();
                if (CardStateManager.this.isEnabled() && !source.isCardMoveInProgress()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Capturing state on grid change.");
                    }
                    CardStateManager.this.captureGameState();
                }
            }

            @Override
            public void mouseOverChanged(GridViewerPanel source, CardViewer overCardViewer) {
                CardStateManager.this.update();
            }
        });
    }

    public void addCard(CardViewer cardViewer) {
        this.cardViewers.add(cardViewer);
        cardViewer.addCardListener(this.cardListener);
    }

    public void removeCard(CardViewer cardViewer) {
        this.cardViewers.remove(cardViewer);
        cardViewer.removeCardListener(this.cardListener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.update();
            }
        }
    }

    public boolean predicatesAreSatisfied(CardLink cardLink) {
        if (!this.predicatesAreSatisfied(cardLink.getPredicates(), cardLink.getPredicateOperator(), cardLink.getPredicateFormula())) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(cardLink + " is enabled!");
        }
        return true;
    }

    public boolean isSatisfied(CardLink cardLink) {
        Card ownerCard = cardLink.getAncestorByType(Card.class);
        Card otherCard = cardLink.getOtherCard();
        if (otherCard == null) {
            return false;
        }
        CardViewer ownerCardViewer = this.getViewerForCard(ownerCard);
        CardViewer otherCardViewer = this.getViewerForCard(otherCard);
        if (!ownerCardViewer.isActive(cardLink)) {
            return false;
        }
        boolean dirLinked = false;
        switch (cardLink.getDirection()) {
            case UNDER: {
                if (ownerCardViewer.isUnderCapturedCard(otherCardViewer)) {
                    dirLinked = true;
                    break;
                }
                if (!cardLink.isOriginating()) break;
                dirLinked = !this.gridViewer.isInPlay(otherCard) && !this.gridViewer.isCaptured(otherCard);
                break;
            }
            case OVER: {
                if (ownerCardViewer.isOverCapturedCard(otherCardViewer)) {
                    dirLinked = true;
                    break;
                }
                if (!cardLink.isOriginating()) break;
                dirLinked = !this.gridViewer.isInPlay(otherCard) && !this.gridViewer.isCaptured(otherCard);
                break;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                boolean bl = dirLinked = this.getDirection(ownerCard, otherCard) == cardLink.getDirection();
            }
        }
        if (!dirLinked) {
            return false;
        }
        if (!this.predicatesAreSatisfied(cardLink.getPredicates(), cardLink.getPredicateOperator(), cardLink.getPredicateFormula())) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(cardLink + " is enabled!");
        }
        return true;
    }

    private void update() {
        if (!this.enabled) {
            return;
        }
        for (CardViewer cardViewer : this.cardViewers) {
            cardViewer.removeCardListener(this.cardListener);
        }
        this.completeAllStateTransitions();
        this.updateLinkDisplay();
        for (CardViewer cardViewer : this.cardViewers) {
            cardViewer.addCardListener(this.cardListener);
        }
    }

    private void updateLinkDisplay() {
        HashMap<CardViewer, EnumSet<GridDirection>> newState = new HashMap<CardViewer, EnumSet<GridDirection>>();
        for (CardViewer cardViewer : this.cardViewers) {
            newState.put(cardViewer, EnumSet.noneOf(GridDirection.class));
        }
        for (CardViewer cardViewer : this.cardViewers) {
            for (CardLink cardLink : cardViewer.getActiveCardLinks()) {
                GridDirection dir = cardLink.getDirection();
                Card otherCard = cardLink.getOtherCard();
                if (!this.isSatisfied(cardLink)) continue;
                ((Set)newState.get(cardViewer)).add(dir);
                ((Set)newState.get(this.getViewerForCard(otherCard))).add(dir.opposite());
            }
        }
        for (CardViewer cardViewer : this.cardViewers) {
            Set<GridDirection> oldLinkDirs = cardViewer.getLinkedDirs();
            Set newLinkDirs = (Set)newState.get(cardViewer);
            for (GridDirection dir : GridDirection.values()) {
                if (newLinkDirs.contains((Object)dir) && !oldLinkDirs.contains((Object)dir)) {
                    cardViewer.addLinkedDir(dir);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Linking card %s to %s", new Object[]{cardViewer.getCard(), dir}));
                    }
                }
                if (!oldLinkDirs.contains((Object)dir) || newLinkDirs.contains((Object)dir)) continue;
                cardViewer.removeLinkedDir(dir);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(String.format("Unlinking card %s from %s", new Object[]{cardViewer.getCard(), dir}));
            }
        }
    }

    private void completeAllStateTransitions() {
        HashSet<SceneLayerState> transitionStates = new HashSet<SceneLayerState>();
        for (CardViewer cardViewer : this.cardViewers) {
            Card card = cardViewer.getCard();
            boolean unstacked = this.gridViewer.isOnGrid(card) && this.gridViewer.getUnderCard(card) == null;
            Map<SceneLayer, SceneLayerState> stateMap = cardViewer.getCurrentStates();
            block1: for (Map.Entry<SceneLayer, SceneLayerState> entry : stateMap.entrySet()) {
                SceneLayer sceneLayer = entry.getKey();
                if (!cardViewer.isCurrentStateComplete(sceneLayer)) continue;
                SceneLayerState state = entry.getValue();
                for (StateTransition transition : state.getTransitions()) {
                    if (!this.isSatisfied(transition, unstacked, false)) continue;
                    CollectionUtils.addIfNotNull(transitionStates, transition.getDestinationState());
                    break;
                }
                for (StateTransition transition : state.getInverseTransitions()) {
                    if (!this.isSatisfied(transition, unstacked, true)) continue;
                    transitionStates.add(transition.getAncestorByType(SceneLayerState.class));
                    continue block1;
                }
            }
        }
        if (!transitionStates.isEmpty()) {
            for (SceneLayerState state : transitionStates) {
                CardViewer cardViewer = this.getViewerForCard(state.getAncestorByType(Card.class));
                SceneLayer sceneLayer = state.getAncestorByType(SceneLayer.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Setting layer %s to state: %s", sceneLayer.getIDPath(1), state));
                }
                cardViewer.setState(sceneLayer, state);
            }
            this.completeAllStateTransitions();
        }
        if (this.gridViewer.isInPrologue()) {
            this.checkForPrologueEnd();
        }
    }

    private boolean isSatisfied(StateTransition transition, boolean unstacked, boolean inverse) {
        if (transition.isUnstackedOnly() && !unstacked) {
            return false;
        }
        return this.predicatesAreSatisfied(transition) != inverse;
    }

    private boolean predicatesAreSatisfied(StateTransition transition) {
        return this.predicatesAreSatisfied(transition.getPredicates(), transition.getPredicateOperator(), transition.getPredicateFormula());
    }

    private boolean predicatesAreSatisfied(List<Predicate> predicates, Predicate.Operator operator, String formula) {
        if (predicates.isEmpty()) {
            return true;
        }
        switch (operator) {
            case ALL: {
                for (Predicate predicate : predicates) {
                    if (this.isSatisfied(predicate)) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                for (Predicate predicate : predicates) {
                    if (!this.isSatisfied(predicate)) continue;
                    return true;
                }
                return false;
            }
            case FORMULA: {
                HashMap<String, Boolean> varValues = new HashMap<String, Boolean>();
                for (Predicate predicate : predicates) {
                    varValues.put(predicate.getID(), this.isSatisfied(predicate));
                }
                return this.booleanFormulaParser.evaluate(formula, varValues);
            }
        }
        return false;
    }

    private boolean isSatisfied(Predicate predicate) {
        boolean satisfied = this.isSatisfiedNonNegated(predicate);
        return predicate.isNegated() ? !satisfied : satisfied;
    }

    private boolean isSatisfiedNonNegated(Predicate predicate) {
        ProjectComponent subject = predicate.getPredicateSubject();
        if (subject == null) {
            return true;
        }
        Card subjectCard = subject.getAncestorByType(Card.class);
        if (!this.checkCardStatus(subjectCard, predicate.getCardStatus(), predicate.getRequiredCoords(), predicate.isMouseOverOnly())) {
            return false;
        }
        CardViewer subjectCardViewer = this.getViewerForCard(subjectCard);
        boolean satisfied = true;
        if (subject instanceof SceneLocation) {
            satisfied = subject.equals(subjectCardViewer.getCurrentLocation());
        } else if (subject instanceof LocationTransition) {
            satisfied = subject.equals(subjectCardViewer.getTarget());
        } else if (subject instanceof SceneLayerState) {
            SceneLayer sceneLayer = subject.getAncestorByType(SceneLayer.class);
            satisfied = subject.equals(subjectCardViewer.getCurrentState(sceneLayer));
        } else if (subject instanceof CardLink) {
            CardLink cardLink = (CardLink)subject;
            satisfied = this.isSatisfied(cardLink);
        }
        return satisfied;
    }

    private void checkForPrologueEnd() {
        PatchworkProject project = this.gridViewer.getProject();
        if (project != null) {
            Map<SceneLayer, SceneLayerState> states;
            Card startingCard = project.getStartingCard();
            SceneLayerState endState = project.getPrologueEndState();
            if (startingCard != null && endState != null && (states = this.gridViewer.getCardViewer(startingCard).getCurrentStates()).containsValue(endState)) {
                this.gridViewer.setInPrologue(false, true);
            }
        }
    }

    private boolean checkCardStatus(Card subjectCard, Predicate.CardStatus cardStatus, GridCoords requiredCoords, boolean mouseOverOnly) {
        if (mouseOverOnly && !this.gridViewer.isMouseOver(subjectCard)) {
            return false;
        }
        switch (cardStatus) {
            case NONE: {
                return true;
            }
            case IN_PLAY: {
                return this.gridViewer.isInPlay(subjectCard);
            }
            case ON_GRID: {
                return this.gridViewer.getCoords(subjectCard) != null;
            }
            case AT_COORDS: {
                return requiredCoords.equals(this.gridViewer.getCoords(subjectCard));
            }
        }
        return false;
    }

    private CardViewer getViewerForCard(Card card) {
        for (CardViewer cardViewer : this.cardViewers) {
            if (!cardViewer.getCard().equals(card)) continue;
            return cardViewer;
        }
        return null;
    }

    private GridDirection getDirection(Card fromCard, Card toCard) {
        GridCoords fromCoords = this.gridViewer.getCoords(fromCard);
        GridCoords toCoords = this.gridViewer.getCoords(toCard);
        if (fromCoords == null || toCoords == null) {
            return null;
        }
        if (fromCoords.getRow() == toCoords.getRow()) {
            if (fromCoords.getCol() == toCoords.getCol() - 1) {
                return GridDirection.EAST;
            }
            if (fromCoords.getCol() == toCoords.getCol() + 1) {
                return GridDirection.WEST;
            }
        }
        if (fromCoords.getCol() == toCoords.getCol()) {
            if (fromCoords.getRow() == toCoords.getRow() - 1) {
                return GridDirection.SOUTH;
            }
            if (fromCoords.getRow() == toCoords.getRow() + 1) {
                return GridDirection.NORTH;
            }
        }
        return null;
    }

    private void captureGameState() {
        this.gridViewer.getGameStateHistory().captureCurrentState();
    }
}

